/* MPEG/WAVE Sound library

   (C) 1997 by Woo-jae Jung */

// Binput.cc
// Inputstream from file

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/stat.h>
#include <unistd.h>

#include "mpegsound.h"

typedef struct _audioheader {
        int ID;
	int layer;
	int protection_bit;
	int bitrate_index;
	int sampling_frequency;
	int padding_bit;
	int private_bit;
	int mode;
	int mode_extension;
	int copyright;
	int original;
	int emphasis;
} AUDIO_HEADER;

static inline int header_sanity_check(struct AUDIO_HEADER *header)
{
   if (header->layer == 0 || header->bitrate_index == 15 ||
       header->sampling_frequency == 3) 
           return -1;

   if (header->ID == 1 && header->layer == 3 && header->protection_bit == 1)
      return -1;
   return 0;
}

/************************/
/* Input bitstrem class */
/************************/
Soundinputstreamfromfile::~Soundinputstreamfromfile()
{
  if(fp)fclose(fp);
}

bool Soundinputstreamfromfile::open(char *filename)
{
  struct stat buf;

  FILE *filein = fopen(filename, "r");
  if (!filein) {
    seterrorcode(SOUND_ERROR_FILEOPENFAIL);
    return false;
  }
  int happy = 0;
  long count = 0;
  unsigned char buffer[4];
  AUDIO_HEADER tmp;
  fread(&buffer[0], 1, 1, filein);
  fread(&buffer[1], 1, 1, filein);
  fread(&buffer[2], 1, 1, filein);
  fread(&buffer[3], 1, 1, filein);
  while (!happy) {
     if (buffer[0] == 0xff) {
        if ((buffer[1] & 0xE0) == 0xE0) {
	   tmp.protection_bit = (buffer[1]&0x01);
	   tmp.layer = (buffer[1]>>1)&0x03;
	   tmp.ID = (buffer[1]>>3)&0x03;
	   if (!tmp.ID)
	      tmp.ID = 2;
	   else
	      tmp.ID = tmp.ID&0x01;

	   tmp.private_bit = buffer[2]&0x01;
	   tmp.padding_bit = (buffer[2]>>1)&0x01;
	   tmp.sampling_frequency = (buffer[2]>>2)&0x03;
	   tmp.bitrate_index = (buffer[2]>>4)&0x0F;

	   tmp.emphasis = buffer[3]&0x03;
	   tmp.original = (buffer[3]>>2)&0x01;
	   tmp.copyright = (buffer[3]>>3)&0x01;
	   tmp.mode_extension = (buffer[3]>>4)&0x03;
	   tmp.mode = (buffer[3]>>6)&0x03;

	   if (header_sanity_check(&tmp) == 0) 
	      happy = 1;
	   else {
	      buffer[0] = buffer[1];
	      buffer[1] = buffer[2];
	      buffer[2] = buffer[3];
	      fread(&buffer[3], 1, 1, filein);
	      count++;
	   }
	}
	else {
	   buffer[0] = buffer[1];
	   buffer[1] = buffer[2];
	   buffer[2] = buffer[3];
	   fread(&buffer[3], 1, 1, filein);
	   count++;
	}
     }
     else {
        buffer[0] = buffer[1];
	buffer[1] = buffer[2];
	buffer[2] = buffer[3];
	fread(&buffer[3], 1, 1, filein);
	count++;
     }
  }

  fclose(filein);
  add = count;

  if(filename==NULL)
  {
    fp=stdin;
    size=0;
    return true;
  }
  else if((fp=fopen(filename,"r"))==NULL)
  {
    seterrorcode(SOUND_ERROR_FILEOPENFAIL);
    return false;
  }

  stat(filename,&buf);
  size=buf.st_size - add;

  fseek(fp, add, SEEK_SET);
  return true;
}

int Soundinputstreamfromfile::getbytedirect(void)
{
  int c;

  if((c=getc(fp))<0)
    seterrorcode(SOUND_ERROR_FILEREADFAIL);

  return c;
}

bool Soundinputstreamfromfile::_readbuffer(char *buffer,int size)
{
  if(fread(buffer,size,1,fp)!=1)
  {
    seterrorcode(SOUND_ERROR_FILEREADFAIL);
    return false;
  }
  return true;
}

bool Soundinputstreamfromfile::eof(void)
{
  return feof(fp);
};

int Soundinputstreamfromfile::getblock(char *buffer,int size)
{
  return fread(buffer,1,size,fp);
}

int Soundinputstreamfromfile::getsize(void)
{
  return size;
}

void Soundinputstreamfromfile::setposition(int pos)
{
  if(fp==stdin)return;
  fseek(fp,pos+add,SEEK_SET);
}

int  Soundinputstreamfromfile::getposition(void)
{
  if(fp==stdin)return 0;
  return ftell(fp);
}

