#include "emusic.h"

int save_on_exit = FALSE;

void DefaultsEmusic(void)
{
   char *s;

   EDBUG(1, "DefaultsEmusic");
   HomeDir = homedir(getuid());
   s = getenv("DISPLAY");
   if (s) {
      esdhost = duplicate(s);
      s = strrchr(esdhost, ':');
      if (s) {
	 s[0] = '\0';
	 esdhost = Erealloc(esdhost, strlen(esdhost) + 1);
      }
   }
   p_list = Emalloc(strlen(HomeDir) + 20);
   sprintf(p_list, "%s/.emusic/list", HomeDir);
   songlist = Emalloc(sizeof(PlayList));
   songlist->first = songlist->last = NULL;
   playlist = songlist;
   cdlist = Emalloc(sizeof(PlayList));
   cdlist->first = cdlist->last = NULL;
   shufflelist = Emalloc(sizeof(PlayList));
   shufflelist->first = shufflelist->last = NULL;
   need_to_reload_theme = FALSE;
   themepath = duplicate("DEFAULT");
   newthemepath = NULL;
   eMusicDir = duplicate(EMUSICDIR);
   ThemeDir = duplicate(THEMEDIR);
   winamp_default_path = Emalloc(strlen(ThemeDir) + 20);
   strcpy(winamp_default_path, ThemeDir);
   strcat(winamp_default_path, "/winamp-base");
   textmode = FALSE;
   EDBUG_RETURN_;
}

void ConfigMain(char *left, char *right)
{
   EDBUG(4, "ConfigMain");
   if (!strncmp("BEGIN", left, 5));
   else if (!strncmp("END", left, 3));
   else if (!strncmp("THEME", left, 5)) {
      Efree(themepath);
      themepath = duplicate(right);
   }
   else if (!strncmp("PLAYLIST", left, 8)) {
      Efree(p_list);
      p_list = duplicate(right);
   }
   else if (!strncmp("LOOPMODE", left, 8))
      loop_mode = parsebool(right);
   else if (!strncmp("DEFAULT_SKIN_PATH", left, 16)) {
      Efree(winamp_default_path);
      winamp_default_path = duplicate(right);
   }
   else if (!strncmp("SAVE_ON_CLOSE", left, 13))
      save_on_exit = parsebool(right);
   EDBUG_RETURN_;
}

static void loop(void)
{
   unsigned long sleeptime;
   XEvent ev;
   Atom wm_del_win = 0;

   EDBUG(1, "loop");
   if (textmode)
      control(PLAY);
   else
      wm_del_win = XInternAtom(disp, "WM_DELETE_WINDOW", False);
   for (;;) {
      if (need_to_reload_theme) {
	 Unload_Theme(TRUE, newthemepath);
	 Efree(newthemepath);
	 newthemepath = NULL;
      }
      play_frame();
      gettimeofday(&tv, NULL);
      lastDraw = thisDraw;
      thisDraw = tv.tv_usec / 10000 + (tv.tv_sec * 100);
      if (lastDraw == 0)
	 lastDraw = thisDraw;
      sleeptime = (7 - (thisDraw - lastDraw)) * 10000;
      if ((sleeptime >= 0) && (70000 >= sleeptime))
	 usleep(sleeptime);
      gettimeofday(&tv, NULL);
      thisDraw = tv.tv_usec / 10000 + (tv.tv_sec * 100);
      if (!textmode) {
	 if (CurMW->MainWin->visible)
	    Display_MainWin(CurMW);
	 while (XPending(disp)) {
	    XNextEvent(disp, &ev);
	    switch (ev.type) {
	    case MotionNotify:
	       while (XCheckTypedEvent(disp, ev.type, &ev));
	       if (CurMW)
		  Event_MainWin(CurMW, ev);
	       if (PlayWin && PlayWin->visible)
		  Event_PlayEditor(ev);
	       if (moving) {
		  MoveWidget(CurMW->MainWin, NULL, ev.xmotion.x_root - move_x, ev.xmotion.y_root - move_y);
		  if (PlayWin->visible)
		     MoveWidget(PlayWin, CurMW->MainWin, ev.xmotion.x_root - move_x, ev.xmotion.y_root - move_y);
	       }
	       break;
	    case ButtonRelease:
	    case ButtonPress:
	       if (CurMW)
		  Event_MainWin(CurMW, ev);
	       if (PlayWin && PlayWin->visible)
		  Event_PlayEditor(ev);
	       break;
	    case KeyPress:
	       if (CurMW)
		  Event_MainWin(CurMW, ev);
	       if (PlayWin && PlayWin->visible)
		  Event_PlayEditor(ev);
	       break;
	    case EnterNotify:
	    case LeaveNotify:
	       if (CurMW)
		  Event_MainWin(CurMW, ev);
	       if (PlayWin && PlayWin->visible)
		  Event_PlayEditor(ev);
	       break;
	    case Expose:
	       if (ev.xexpose.window == CurMW->MainWin->win) {
		  CurMW->MainWin->exposed = TRUE;
		  if (CurMW->MainWin->visible) {
		     if (CurMW->name_box)
			CurMW->name_box->drawn = FALSE;
		     Display_MainWin(CurMW);
		  }
	       }
	       else if (ev.xexpose.window == PlayWin->win) {
		  PlayWin->exposed = TRUE;
		  if (PlayWin->visible)
		     Display_PlayEditor();
	       }
	       break;
	    case ClientMessage:
	       if ((ev.xclient.format == 32) &&
		   (ev.xclient.data.l[0] == wm_del_win)) {
		  if (ev.xclient.window == CurMW->MainWin->win)
		     do_action(A_EXIT);
		  else if (ev.xclient.window == PlayWin->win)
		     do_action(A_PLAYLIST_TOGGLE);
	       }
	       else {
		  Atom a = XInternAtom(disp, "ENL_MSG", False);

		  if (ev.xclient.message_type == a)
		     HandleEComms(ev);
	       }
	       break;
	    case ConfigureNotify:
	       if ((ev.xconfigure.window == PlayWin->win) && (PlayWin->visible))
		  ResizeWidget(PlayWin, ev.xconfigure.width, ev.xconfigure.height);
	       break;
	    default:
	       break;
	    }
	 }
	 XFlush(disp);
      }
      else if (!playing) {
	 inputFinished = TRUE;
	 while (buffer_running)
	    usleep(100);
	 EDBUG_RETURN_;
      }
   }
   EDBUG_RETURN_;
}

void displayDisclaimer(void)
{
   EDBUG(1, "displayDisclaimer");
   printf("This is eMusic %s, (c) 1997,1998 Isaac Richards\n", VERSION);
   printf("  Comments/suggestions?  Find me on efnet as Chutt.\n");
   printf("\n Read the README for details\n");
   EDBUG_RETURN_;
}

void displayUsage(void)
{
   EDBUG(1, "displayUseage");
   printf("\nusage: emusic [options]\n");
   printf("  --no-graphics, -N <path>\tNo GUI, plays file(s) in path and exits. \"path\"\n");
   printf("\t\t\t\tneeds to exist, and can contain wildcards.\n");
   printf("  --recursive, -R         \tIf used with a wildcard in the path of the above\n");
   printf("\t\t\t\toption this'll recursively search through the\n");
   printf("\t\t\t\tpath adding files to the playlist\n\n");
   printf(" --host, -H <host>        \tUse esound host <host>\n");
   printf(" --theme, -T <theme>      \tLoads the theme <theme>\n");
   printf(" --convert, -C <path1> <path2>\tConverts skin at path1 to themeball at path2\n");
   exit(1);
}

void parse_args(int add, int argc, char *argv[])
{
   int i;
   int bad_options = FALSE;
   int textmode_recursive = FALSE;

   EDBUG(1, "parse_args");
   for (i = 1; i < argc; i++) {
      if ((!strcmp("--no-graphics", argv[i]) || !strcmp("-N", argv[i])) && ((argc - i) >= 1)) {
	 textmode = TRUE;
	 loop_mode = FALSE;
      }
      else if ((!strcmp("--recursive", argv[i]) || !strcmp("-R", argv[i])))
	 textmode_recursive = TRUE;
      else if ((!strcmp("--theme", argv[i]) || !strcmp("-T", argv[i])) && ((argc - i) >= 1)) {
	 if (themepath)
	    Efree(themepath);
	 themepath = duplicate(argv[i + 1]);
	 i++;
      }
      else if ((!strcmp("--host", argv[i]) || !strcmp("-H", argv[i])) && ((argc - i) >= 1)) {
	 if (esdhost)
	    Efree(esdhost);
	 esdhost = duplicate(argv[i + 1]);
	 i++;
      }
      else if ((!strcmp("--convert", argv[i]) || !strcmp("-C", argv[i])) && ((argc - i) >= 2)) {
	 char *skinpath;
	 char *savepath;

	 skinpath = GetRightPath(argv[i + 1]);
	 savepath = GetRightPath(argv[i + 2]);
	 InitX(&argc, &argv);
	 ConvertSkinToThemeball(skinpath, savepath);
	 exit(0);
      }
      else {
	 if (exists(argv[i])) {
	    if (isdir(argv[i]))
	       dirtolist(argv[i], "*", textmode_recursive);
	    else if (isfile(argv[i])) {
	       char *temp = splitdir(argv[i]);

	       if (strlen(argv[i]) == 0)
		  dirtolist("/", temp, textmode_recursive);
	       else
		  dirtolist(argv[i], temp, textmode_recursive);
	    }
	    else
	       bad_options = TRUE;
	 }
	 else
	    bad_options = TRUE;
      }
   }
   if (bad_options)
      displayUsage();
   EDBUG_RETURN_;
}

void Shutdown(void)
{
   char *home;

   EDBUG(1, "Shutdown");
   playing = TRUE;
   Unload_Theme(FALSE, NULL);
   if (save_on_exit) {
      home = duplicate(HomeDir);
      home = Erealloc(home, strlen(home) + 20);
      strcat(home, "/.emusic/list");
      saveplaylist(playlist, home);
      Efree(home);
   }
   ShutdownAnalysis();
   exit(0);
}

void Seg(int sig)
{
   fprintf(stderr, "Reality is on the blink again..  Somethin segged..\n");
   fprintf(stderr, "Fix it and fire off a diff to ijr@po.cwru.edu.\n");
   fprintf(stderr, "At least, run eMusic through gdb and mail me the backtrace.\n");
   Unload_Theme(FALSE, NULL);
   exit(0);
}

void Pipe(int sig)
{
   fprintf(stderr, "Oops, broken pipe.  This could be caused by some other process using /dev/dsp,\n");
   fprintf(stderr, "by EsounD dying on eMusic, or by you not having permission to talk to EsounD..\n");
   Unload_Theme(FALSE, NULL);
   exit(0);
}

void Interrupt(int sig)
{
   Shutdown();
   exit(0);
}

void SetUpSigs(void)
{
   struct sigaction sigact;

   EDBUG(1, "SetUpSigs");
#ifndef DEBUG
   sigact.sa_handler = Seg;
   sigemptyset(&sigact.sa_mask);
   sigact.sa_flags = 0;
   sigaction(SIGSEGV, &sigact, 0);
   sigaction(SIGFPE, &sigact, 0);
   sigaction(SIGILL, &sigact, 0);
   sigact.sa_handler = Pipe;
   sigaction(SIGPIPE, &sigact, 0);
#endif
   sigact.sa_handler = SecondTimer;
   sigemptyset(&sigact.sa_mask);
   sigact.sa_flags = 0;
   sigaction(SIGALRM, &sigact, 0);
   EDBUG_RETURN_;
}

int main(int argc, char *argv[])
{
   char *dir;

   EDBUG(1, "main");
   InitStringList();
   displayDisclaimer();
   SetUpSigs();
   DefaultsEmusic();
   loadconfig("/.emusic/MAIN");
   dir = Emalloc(strlen(eMusicDir) + 20);
   strcpy(dir, eMusicDir);
   strcat(dir, "/players");
   InitPlayers(dir);
   Efree(dir);
   loadconfig("/.emusic/MAIN.players");
   audioInit();
   if (argc > 1)
      parse_args(0, argc, argv);
   else
      textmode = FALSE;
   if (!textmode) {
      InitX(&argc, &argv);
      loadconfig(NULL);
      SpawnAnalysis();
      getlist(p_list);
      XSync(disp, True);
   }
   else {
      setplugsplaylist(playlist);
      cur_item = playlist->first;
   }
   Info("Welcome to eMusic DR0.7", TRUE, FALSE);
   loop();
   Unload_Theme(FALSE, NULL);
   EDBUG_RETURN(0);
}
