#include "aumix.h"
#if HAVE_LIBGPM && HAVE_LIBNCURSES
extern int GpmHalfdelay(void);
extern int MouseHandler(Gpm_Event * event, void *data);

int MouseHandler(Gpm_Event * event, void *data)
{
	int dev, dev_orig, i, j, temp;
	if ((event->type & GPM_DOWN) || (event->type & GPM_DRAG)) {
/* menu */
		if (event->x < 6) {
/* quit */
			if (event->y == 3) {
				Gpm_Close();
				close(mixer_fd);
				CloseScreen();
				exit(0);
			}
/* load */
			if (event->y == 4) {
				LoadSettings();
				return 0;
			}
/* save */
			if (event->y == 5) {
				SaveSettings();
				return 0;
			}
/* keys */
			if (event->y == 6) {
				KeysBox();
				return 0;
			}
/* mute */
			if (event->y == 7) {
				ToggleMute();
				return 0;
			}
		}
		dev = event->y - 1 - YOFFSET;
		j = 0;
		dev_orig = dev;
		for (i = 0; j <= dev_orig; i++) {
			if (!(devmask & (1 << i))) {
				dev++;
			} else {
				j++;
			}
		}
		temp = event->x - 2 - XOFFSET;
		if ((temp > 41) & (temp < 69)) {	/*balance */
			temp = (temp - 42) * BALANCE_INCREMENT;
			if ((((1 << dev) & stereodevs) && ((1 << dev) & devmask))) {
				AdjustBalance(dev, 0, temp);
				EraseLevel(dev);
				DrawLevel(dev);
			}
			return 0;
		}
		if (temp == -1) {
			SwitchRecordPlay(dev);
			return 0;
		}
		if (temp < 34) {
			temp = temp * INCREMENT;
			AdjustLevel(dev, 0, temp);
		}
	}
	return 0;
}

int GpmHalfdelay(void)
{				/* from Alessandro Rubini */
/*
   MouseHandler();
 */
	return (getch());
}
#endif
