#!/bin/sh
##
## imgvview.sh
##	Very simple viewer script for Image Viewer PDB files.  This
##	converts the image to a temporary pgm file and launches
##	a pgm viewer (xli, xv, or display (from Image Magick) will
##	work here).  This script makes it a bit easier to wire the
##	pdb files into your web browser or just to view them from the
##	command line.
##
## Copyright (C) 1997 Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:  Eric A. Howe (mu@trends.net)
##
## $Mu: imgvtopgm/imgvview.sh 1.7 1998/06/02 22:31:07 $
##
TEMPFILE=/tmp/$$-imgvview.pnm

cleanup() {
	[ -r $TEMPFILE ] && rm -f $TEMPFILE
}

trap cleanup 2 3 9 13 15 

##
## Choose your weapons.
##
#VIEWER=xli
VIEWER=xv
#VIEWER=display

usage() {
	NAME=`basename $1`
	echo "$NAME [-hv] [file]"
	cat <<_DONE_DONE_DONE_
	Convert file to a temporary PGM or PBM file and launch $VIEWER to
	view it.  If file is not specified or file is "-", then the standard
	input is read.

	-h	Display this usage message and exit.
	-v	Display the version number and exit.
_DONE_DONE_DONE_
}

version() {
	NAME=`basename $1`
	echo "$NAME @@VERSION@@"
}

IMAGE=""
while [ X"$IMAGE" = X"" -a $# -ne 0 ]; do
	case X"$1" in
	X"-h")	usage $0;	exit 0		;;
	X"-v")	version $0;	exit 0		;;
	X"--")	shift;		IMAGE=$1	;;
	X*)	IMAGE=$1			;;
	esac
done

if [ X"$IMAGE" = X"" ]; then
	IMAGE="-"
fi
imgvtopnm "$IMAGE" "$TEMPFILE"
if [ $? -ne 0 ]; then
	cleanup
	exit 1
fi
$VIEWER $TEMPFILE
cleanup
