/*  VER 035  TAB P   $Id: incoming.c,v 1.9 1998/09/27 07:34:33 src Exp $
 *
 *  place incoming news in spool
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: incoming.c,v $
 *  Revision 1.9  1998/09/27 07:34:33  src
 *  Removed snprintf
 *
 *  Revision 1.8  1998/09/21 10:04:29  src
 *  Added new command line options for --inews
 *
 *  Revision 1.7  1998/09/18 07:30:59  src
 *  Implemented --inews
 *
 *  Revision 1.6  1998/09/09 07:32:11  src
 *  Version 1.1
 *
 *  Revision 1.5  1998/07/12 09:39:28  src
 *  newsx version 1.0
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "news.h"
#include "nntp.h"

/* 
 * statics  
 *          
 * BUG: must delete intmpname in case of error/interrupt etc
 */
static char intmpname[PATH_MAX];
static FILE *pull_spoolfp = 0; /* currently open spool */
static int pull_pid = 0; 

/*
 *  get name of (incoming) spool directory
 */
static void
incoming_spool(char *name /* size is PATH_MAX */)
{
    build_alt_filename(name,SPOOL,INCOMING,incoming);
}

/*
 *  open spool file
 */
static int 
open_spool(void)
{
    if (!pull_spoolfp) {
	if (rnews_opt || inews_opt) {
	    if (!(pull_spoolfp = open_rnews(&pull_pid))) {
		return 0;
	    }
	} else {
	    /* temporary name */
	    char incomingdir[PATH_MAX];
	    char pid_string[100];
	    int pid = getpid();
	
	    sprintf(pid_string,".%d",pid); /* add PID to temporary filename */

	    incoming_spool(incomingdir);
	    build_filename(intmpname,incomingdir,_IN_TMP,spoolname,pid_string);
	
	    /* open temporary spool file proper */
	    if (!(pull_spoolfp = fopen(intmpname,"w"))) {
		log_msg(L_ERRno,"can't open incoming spool \"%s\"", intmpname);
		return 0;
	    }
	    log_msg(L_DEBUGMORE,"opened incoming spool: %s",intmpname);
	}
    }
    return 1;
}

/*
 *  write to incoming spool
 */
int 
write_incoming(char *buffer,long bytecount,int is_a_path)
{
    char *extra_header = NULL;
    char buf[2*NNTP_STRLEN+1];

    if (bytecount > 0) {
	/* open outgoing spool */
	if (!pull_spoolfp && !open_spool()) return 0;

	/* add anything at start? */
	if (add_header) {
	    if (strcmp(add_header,"Path")) {
		/* default path, but only if no other Path in incoming... */
		if (!is_a_path) {
		    char *p = get_exclusion();
		    if (!*p) p = hostname;
		    sprintf(buf,"Path: %s!not-for-mail",p);
		    extra_header = buf;
		}
	    } else {
		extra_header = add_header;
	    }
	}

	if (!inews_opt) {
	    fprintf(pull_spoolfp,"#! rnews %ld\n",bytecount+
				 (extra_header ? strlen(extra_header)+1 : 0));
	}

	if (extra_header) fprintf(pull_spoolfp,"%s\n",extra_header);
	if (fwrite(buffer,sizeof(char),bytecount,pull_spoolfp)
						    != bytecount) {
	    log_msg(L_ERRno,"error writing to incoming spool");
	    return 0;
	}
	if (ferror(pull_spoolfp)) {
	    log_msg(L_ERRno,"problems with incoming spool");
	    return 0;
	}
	if (inews_opt) {
	    /* close for every article */
	    flush_spool(0);
	}
    }
    return 1;
}

/*
 *  flush incoming spool file
 *  NOTE: could be called from a signal handler
 */
int 
flush_spool(int urgent)
{
    char inspoolname[PATH_MAX];
    FILE *f;
    static int sequence = 0;
    int l_debug = urgent ? L_DEBUG : L_DEBUGMORE;

    /* finished of spooled batch */
    if (pull_spoolfp) {
	if (rnews_opt || inews_opt) {
	    progtitle("pull: close rnews pipe");
	    log_msg(l_debug,"close %s pipe to pid %d", rnews_name, pull_pid);
	    f = pull_spoolfp;
	    pull_spoolfp = 0;
	    if (!close_rnews(f,pull_pid)) {
		log_msg(L_ERRno,"error closing %s pipe", rnews_name);
		exit_cleanup(6);
	    }
	    pull_spoolfp = 0;
	} else {
	    char incomingdir[PATH_MAX];
	    char spoolfile[PATH_MAX];
	
	    progtitle("pull: flush spool");
	    log_msg(l_debug,"flush spool");
	    f = pull_spoolfp;
	    pull_spoolfp = 0;
	    if (fclose(f) == EOF) {
		log_msg(L_ERRno,"error writing \"%s\"", intmpname);
		exit_cleanup(6);
	    }
	
	    /* spool file is now ready for newsrun */
	    /* rename it so that it becomes visible */
	    sprintf(spoolfile,_INSPOOL,time((time_t *)0),getpid(),++sequence);
	
	    build_alt_filename(incomingdir,SPOOL,INCOMING,incoming);
	    build_filename(inspoolname,incomingdir,"/",spoolfile,NULL);

	    log_msg(l_debug,"rename spool from %s to %s",
						intmpname,inspoolname);
	
	    if (!rename_file(intmpname,inspoolname)) {
		unlink(intmpname);
		exit_cleanup(6);
	    }
	}
    } else {
	log_msg(l_debug,"no spool to flush");
    }
    return 1;
}


