/*
libutil -- read config file

Written by Arnt Gulbrandsen <agulbra@troll.no> and copyright 1995
Troll Tech AS, Postboks 6133 Etterstad, 0602 Oslo, Norway, fax +47
22646949.
Modified by Cornelius Krasel <krasel@wpxx02.toxi.uni-wuerzburg.de>
and Randolf Skerka <rskerka@metronet.de>.
Copyright of the modifications 1997.
Modified by Kent Robotti <robotti@erols.com>. Copyright of the
modifications 1998.
Modified by Markus Enzenberger <enz@cip.physik.uni-muenchen.de>.
Copyright of the modifications 1998.
Modified by Cornelius Krasel <krasel@wpxx02.toxi.uni-wuerzburg.de>.
Copyright of the modifications 1998.

See file COPYING for restrictions on the use of this software.
*/

#include <ctype.h>
#include <errno.h>
#include <limits.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <time.h>

#include "leafnode.h"

char s[PATH_MAX+1024]; /* long string, here to cut memory usage */

/*
 * misc. global variables, documented in leafnode.h
 */
char * username;
char * password;
time_t expire = 0;
struct expire_entry * expire_base;
int artlimit = 0;
int initiallimit = 0;
int crosspostlimit = 0;
int delaybody = 0;
int scarce_links = 0;
int maxage = 10;
int maxlines = 0;
int nntpport = 0;
struct serverlist * readserver = NULL;
struct serverlist * postserver = NULL;

int parse_line ( char *l, char * param, char * value ) ;

/* parse a line */
int parse_line ( char *l, char * param, char * value ) {
    char *p, *q;

    p = strdup(l);
    if ( p == NULL )
       return 0;
    /* skip comments */
    q = strchr( p, '#' );
    if ( q )
       *q = '\0';
    if ( *p == 0 )
        return 0;
    if (( q = strsep( &p, "=" ) ) != NULL ) {
        /* skipping leading blanks or tabs */
	while ( isspace( *p ) )
	   p++;
	while ( isspace( *q ) )
	   q++;
        strcpy( param, q );
        strcpy( value, p );
    }
    /* now param contains the stuff before '=' and value the stuff behind it */
    if ( value == NULL || param == NULL )
       return 0;
    /* skipping trailing blanks or tabs */
    q = rindex( param, '\0' );
    q--;
    while ( isspace ( *q ) ) {
       *q = '\0';
       q--;
    }
    q = rindex( value, '\0' );
    q--;
    while ( isspace ( *q ) ) {
       *q = '\0';
       q--;
    }
    return 1;
}

/*
05/25/97 - T. Sweeney - Modified to read user name and password for AUTHINFO.
                        Security questionable as password is stored in
                        plaintext in insecure file.
*/

int readconfig( void ) {
    struct serverlist *p, *q ;
    struct expire_entry *ent = NULL, *prev = NULL;
    FILE * f;
    char * l;
    char * param, * value;
    int i;

    artlimit = 0;
    param = malloc(80);
    value = malloc(80);

    sprintf( s, "%s/config", libdir );
    if ( (f=fopen( s, "r" )) == 0 ) {
        syslog( LOG_ERR, "cannot open %s", s );
	return 0;
    }
    while ( (l=getaline( f )) ) {
	if ( parse_line( l, param, value ) ) {
            if ( strcmp ( "username", param ) == 0 ) {
	        username = strdup( value );
	        syslog( LOG_DEBUG, "config: username is %s", username);
	    }
	    else if ( strcmp ( "password", param ) == 0 ) {
	        password = strdup( value );
		syslog( LOG_DEBUG, "config: password is %s", password);
	    }
	    else if ( strcmp ( "expire", param ) == 0 ) {
	        expire = time(NULL)-(time_t)(86400*atol( value ));
		syslog( LOG_DEBUG, "config: expire is %s days", value);
	    }
	    else if ( strcmp ( "maxcrosspost", param ) == 0 ) {
		crosspostlimit = atoi( value );
		syslog( LOG_DEBUG, "config: crosspostlimit is %d groups",
			crosspostlimit );
	    }
	    else if ( strcmp( "maxlines", param ) == 0 ) {
		maxlines = atoi( value );
		syslog( LOG_DEBUG, "config: postings have max. %d lines",
			maxlines );
	    }
	    else if ( strcmp ( "delaybody", param ) == 0 ) {
		delaybody = atoi( value );
		syslog( LOG_DEBUG, "config: delaybody is %d (default 0)",
			delaybody );
	    }
	    else if ( strncmp( "groupexpire", param, 11 ) == 0 ) {
		char * m;
	        m = strtok(param, " \t" );
		m = strtok(NULL, " \t" );
		if ( m != NULL ) {
		    i = time(NULL)-(time_t)(86400*atol(value));
                    ent = (struct expire_entry *)
                           malloc( sizeof(struct expire_entry) );
                    ent->group = strdup(m);
                    ent->xtime = i;
                    ent->next = prev;
                    prev = ent;
		    syslog( LOG_DEBUG, "config: groupexpire for %s is %s days",
			    m, value);
		}
            }
	    else if ( strcmp( "maxage", param ) == 0 ) {
	        maxage = atoi( value );
		syslog( LOG_DEBUG, "config: maxage is %d", maxage );
	    }
	    else if ( strcmp( "maxfetch", param ) == 0 ) {
	        artlimit = atol( value );
		syslog( LOG_DEBUG, "config: maxfetch is %d", artlimit);
	    }
	    else if ( strcmp( "port", param ) == 0 ) {
	        nntpport = atoi ( value );
		syslog( LOG_DEBUG, "config: nntpport is %d", nntpport);
	    }
	    else if ( strcmp( "initialfetch", param ) == 0 ) {
	        initiallimit = atol ( value );
		syslog( LOG_DEBUG, "config: initialfetch is %d", initiallimit);
	    }
            else if ( strcmp ( "post", param ) == 0 ) {
	    	/* still quite improvised */
		if ( postserver == NULL ) {
		    syslog( LOG_DEBUG,
			    "config: additional posting server is %s", value );
		    postserver = (struct serverlist *)
				 critmalloc( sizeof(struct serverlist) +
				 strlen(value),
				 "allocating space for server name");
		    strcpy( postserver->name, value );
		    postserver->next = NULL;
		} else {
		    syslog( LOG_DEBUG,
			    "config: additional postservers not yet supported");
		}
	    }
	    else if (( strcmp ( "server", param ) == 0 ) ||
		    ( strcmp ( "supplement", param ) == 0 )) {
		syslog( LOG_INFO, "config: server is %s", value );
		p = (struct serverlist *)critmalloc( sizeof(struct serverlist)
		     + strlen(value), "allocating space for server name");
		strcpy( p->name, value );
		p->next = NULL;
		if ( readserver == NULL )
		    readserver = p;
		else
		    q->next = p;
		q = p;
	    }
	    else if ( strcmp ( "create_all_links", param ) == 0 ) {
	        if ( strcasecmp ( "no", value ) == 0 ) {
		   scarce_links = 1;
		   syslog( LOG_INFO,
		           "config: create only necessary hardlinks" );
		}
		else
		   scarce_links = 0;
	    }
	}
    }
    expire_base = ent;
    fclose(f);
    if ( readserver == NULL )
	syslog( LOG_ERR, "no server declaration in config file");
    if ( readserver && ( postserver == NULL ) ) {
	postserver = (struct serverlist *)critmalloc(sizeof(struct serverlist)+
			strlen( readserver->name ),
			"allocating space for postserver" );
	strcpy( postserver->name, readserver->name ) ;
	postserver->next = NULL;
	syslog( LOG_INFO, "config: no postserver declaration in config file, "
			  "using %s", postserver->name );
    }
    if ( !expire )
	syslog( LOG_ERR, "no expire declaration in config file");
    return 1;
}
