/*

 X-Chat
 
Copyright (c) 1998 Peter Zelezny.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "xchat.h"
#include "urlgrab.h"
#include <signal.h>


long urlselected = -1;
GtkWidget *urlgrabberwindow = 0;
GtkWidget *urlgrabberlist;
extern struct url firsturl;

extern char *nocasestrstr(char *, char *);
void url_addurlgui(char *urltext);


void url_closegui()
{
   if(urlgrabberwindow)
   {
      gtk_widget_destroy(urlgrabberwindow);   
      urlgrabberwindow = 0;
      urlselected = -1;
   }
}

void url_button_sendlynx(void)
{
   char *url;
   char buf[128];
   if(urlselected == -1) return;
   gtk_clist_get_text(GTK_CLIST(urlgrabberlist), urlselected, 0, &url);
   sprintf(buf, "xterm -e lynx %s", url);
   popen(buf, "r");
}

void url_button_send(void)
{
   char *url;
   char buf[128];
   if(urlselected == -1) return;
   gtk_clist_get_text(GTK_CLIST(urlgrabberlist), urlselected, 0, &url);
   sprintf(buf, "netscape -remote 'openURL(%s)'", url);
   popen(buf, "r");
}

void url_button_clear(void)
{
   struct url *url = &firsturl, *next;
   do
   {
      next = url->next;
      if(url->used)
      {
	 url->used = 0;
	 if(url != &firsturl) free(url);
      }
      url = next;
   } while(url);
   firsturl.next = 0;
   gtk_clist_clear((GtkCList*)urlgrabberlist);
   urlselected = -1;
}

void url_row_unselected(GtkWidget *clist, gint row, gint column,
		       GdkEventButton *even, struct server *serv)
{
     urlselected = -1;
}

void url_row_selected(GtkWidget *clist, gint row, gint column,
		       GdkEventButton *even, struct server *serv)
{
     urlselected = row;
}

void url_opengui()
{
   GtkWidget *wid, *vbox, *hbox;
   
   if(urlgrabberwindow)
   {
      gtk_widget_destroy(urlgrabberwindow);
      urlgrabberwindow = 0;
      return;
   }
   
   urlgrabberwindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_widget_set_usize(GTK_WIDGET(urlgrabberwindow), 350, 100);
   gtk_window_set_title(GTK_WINDOW(urlgrabberwindow), "X-Chat: URL Grabber");
   gtk_signal_connect(GTK_OBJECT(urlgrabberwindow), "destroy",
                             GTK_SIGNAL_FUNC(url_closegui), 0);

   vbox = gtk_vbox_new(FALSE, 1);
   gtk_container_add(GTK_CONTAINER(urlgrabberwindow), vbox);
   gtk_widget_show(vbox);

     hbox = gtk_hbox_new(FALSE, 1);
     gtk_container_add(GTK_CONTAINER(vbox), hbox);
     gtk_widget_show(hbox);
   
   urlgrabberlist = gtk_clist_new(1);
   gtk_signal_connect(GTK_OBJECT(urlgrabberlist),
		      "select_row", GTK_SIGNAL_FUNC(url_row_selected), 0);
   gtk_signal_connect(GTK_OBJECT(urlgrabberlist),
		      "unselect_row", GTK_SIGNAL_FUNC(url_row_unselected), 0);
   gtk_clist_set_border(GTK_CLIST(urlgrabberlist), GTK_SHADOW_OUT);
   gtk_clist_set_policy(GTK_CLIST(urlgrabberlist), GTK_POLICY_AUTOMATIC,
			      GTK_POLICY_AUTOMATIC);
   gtk_container_add(GTK_CONTAINER(hbox), urlgrabberlist); 
   gtk_widget_show(urlgrabberlist);

     hbox = gtk_hbox_new(FALSE, 1);
     gtk_box_pack_end(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);
     gtk_widget_show(hbox);
   
       wid = gtk_button_new_with_label("Clear");
       gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(url_button_clear), 0);
       gtk_container_add(GTK_CONTAINER(hbox), wid);
       gtk_widget_show(wid);
   
       wid = gtk_button_new_with_label("-> Lynx");
       gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(url_button_sendlynx), 0);
       gtk_container_add(GTK_CONTAINER(hbox), wid);
       gtk_widget_show(wid);
   
       wid = gtk_button_new_with_label("-> Netscape");
       gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(url_button_send), 0);
       gtk_container_add(GTK_CONTAINER(hbox), wid);
       gtk_widget_show(wid); 
   
   gtk_widget_show(urlgrabberwindow);
   
   {
      struct url *url = &firsturl;
      do
      {
	 if(url->used) url_addurlgui(url->urltext);
	 url = url->next;
      } while(url);
   }
}

void url_addurlgui(char *urltext)
{
   if(urlgrabberwindow)
      gtk_clist_append((GtkCList*)urlgrabberlist, &urltext);
}

int url_findurl(char *urltext)
{
   struct url *url = &firsturl;
   do
   {
      if(url->used)
      {
	 if(!strcasecmp(urltext, url->urltext)) return 1;
      }
      url = url->next;
   } while(url);
   return 0;
}

void url_addurl(char *urltext)
{
   struct url *url = &firsturl;
   if(url_findurl(urltext)) return;
   do
   {
      if(url->used == 0)
      {
	 strcpy(url->urltext, urltext);
	 url->used = 1;
	 url_addurlgui(url->urltext);
	 return;
      }
      if(!url->next)
      {
	 url->next = malloc(sizeof(struct url));
	 if(!url->next) return;
	 url->next->used = 0;
	 url->next->next = 0;
      }
      url = url->next;
   } while(url);
}

void url_checkurl(char *buf)
{
   char *po, *url = nocasestrstr(buf, "http:");
   if(!url) url = nocasestrstr(buf, "www.");
   if(!url) url = nocasestrstr(buf, "ftp:");
   if(url)
   {
      po = strchr(url, ' ');
      if(po)
      {
	 char tbuf[256], t;
	 t = *po;
	 *po = 0;
	 strcpy(tbuf, url);
	 url_addurl(tbuf);
	 *po = t;
      } else
	 url_addurl(url);
   }
}
