/*
Copyright (c) 1998 Peter Zelezny.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "xchat.h"
#include <fcntl.h>

extern struct xchatprefs prefs;
extern struct session firstsession;

typedef void (*menucallback) (GtkWidget *wid, gpointer data);

#define M_MENU 0
#define M_MENUD 5
#define M_NEWMENU 1
#define M_END 2
#define M_SEP 3
#define M_MENUTOG 4

struct mymenu
{
   int type;
   char *text;
   menucallback callback;
   int state;
   int activate;
};

extern void chanlist_opengui(struct server *serv);
extern void url_opengui(GtkWidget *, gpointer);
extern void cmd_help(struct session *sess, char *tbuf, char *word[], char *word_eol[]);
extern void xchat_cleanup(GtkWidget *wid, gpointer sess);
extern void kill_session(GtkWidget *win, struct session *sess);
extern struct server *new_server(void);
extern struct session *new_session(struct server *, char *);
extern void PrintText(struct session *, char *);
extern void open_rawlog(struct server *);
extern void open_dcc_recv_window(GtkWidget *wid, gpointer sess);
extern void open_dcc_send_window(GtkWidget *wid, gpointer sess);
extern void open_dcc_chat_window(GtkWidget *wid, gpointer sess);
extern void open_server_list(GtkWidget *wid, gpointer sess);
extern void save_config(void);
extern void load_config(void);
extern void settings_opengui(struct session *sess);


void menu_settings(GtkWidget *wid, gpointer sess)
{
   settings_opengui((struct session *)sess);
}

void menu_newserver(GtkWidget *wid, gpointer sess)
{
   struct server *serv = new_server();
   if(serv) new_session(serv, 0);
}

void menu_newchannel(GtkWidget *wid, gpointer sess)
{
   new_session(((struct session *)sess)->server, 0);
}

void menu_rawlog(GtkWidget *wid, gpointer sess)
{
   open_rawlog(((struct session *)sess)->server);
}

void flipflag(int flag)
{
   if(prefs.flags&(1<<flag))
     prefs.flags &= ~(1<<flag);
   else
     prefs.flags |= (1<<flag);
}

void menu_autorejoin(GtkWidget *wid, gpointer sess)
{
   flipflag(PREFS_AUTOREJOIN);
}

void menu_autoreconnect(GtkWidget *wid, gpointer sess)
{
   flipflag(PREFS_AUTORECONNECT);
}

void menu_autodialog(GtkWidget *wid, gpointer sess)
{
   flipflag(PREFS_AUTODIALOG);
}

void menu_saveexit(GtkWidget *wid, gpointer sess)
{
   flipflag(PREFS_AUTOSAVE);
}

void menu_close(GtkWidget *wid, gpointer sess)
{
   kill_session(((struct session *)sess)->window, sess);
}

void menu_flushbuffer(GtkWidget *wid, gpointer sess)
{
   gtk_text_backward_delete((GtkText *)((struct session *)sess)->textgad,
			    gtk_text_get_length((GtkText *)((struct session *)sess)->textgad));
}

GtkWidget *freq = 0;

void close_savebuffer(void)
{
   gtk_widget_destroy(freq);
   freq = 0;
}

void savebuffer_req_done(GtkWidget *wid, struct session *sess)
{
   int fh;
   char file[128];
   strcpy(file, gtk_file_selection_get_filename(GTK_FILE_SELECTION(freq)));
   close_savebuffer();
   
   fh = open(file, O_WRONLY | O_CREAT, 0600);
   if(fh != -1)
   {
      char *buf = gtk_editable_get_chars((GtkEditable*)sess->textgad, 0, -1);
      write(fh, buf, strlen(buf));
      g_free(buf);
      close(fh);
   }
}

void menu_savebuffer(GtkWidget *wid, gpointer sess)
{
   if(freq) close_savebuffer();
   freq = gtk_file_selection_new("Save review buffer");
   gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(freq)->cancel_button),
			     "clicked", (GtkSignalFunc) close_savebuffer, 0);
   gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(freq)->ok_button),
		      "clicked", (GtkSignalFunc) savebuffer_req_done, sess);
   gtk_widget_show(freq);
}

void menu_wallops(GtkWidget *wid, gpointer sess)
{
   char tbuf[128];
   flipflag(PREFS_WALLOPS);
   if(((struct session *)sess)->server->flags&(1<<0))
   {
      if(prefs.flags&(1<<PREFS_WALLOPS))
        sprintf(tbuf, "MODE %s +w\r\n", ((struct session *)sess)->server->nick);
      else
        sprintf(tbuf, "MODE %s -w\r\n", ((struct session *)sess)->server->nick);
      send(((struct session *)sess)->server->sok, tbuf, strlen(tbuf), 0);
   }
}

void menu_servernotice(GtkWidget *wid, gpointer sess)
{
   char tbuf[128];
   flipflag(PREFS_SERVERNOTICE);
   if(((struct session *)sess)->server->flags&(1<<0))
   {
      if(prefs.flags&(1<<PREFS_SERVERNOTICE))
        sprintf(tbuf, "MODE %s +s\r\n", ((struct session *)sess)->server->nick);
      else
        sprintf(tbuf, "MODE %s -s\r\n", ((struct session *)sess)->server->nick);
      send(((struct session *)sess)->server->sok, tbuf, strlen(tbuf), 0);
   }
}

void menu_away(GtkWidget *wid, gpointer sess)
{
   char tbuf[128];
   flipflag(PREFS_AWAY);
   if(((struct session *)sess)->server->flags&(1<<0))
   {
      if(prefs.flags&(1<<PREFS_AWAY))
      {
	 sprintf(tbuf, "AWAY :%s\r\n", prefs.awayreason);
	 send(((struct session *)sess)->server->sok, tbuf, strlen(tbuf), 0);
      } else
	send(((struct session *)sess)->server->sok, "AWAY\r\n", 6, 0);
   }
}

void menu_invisible(GtkWidget *wid, gpointer sess)
{
   char tbuf[128];
   flipflag(PREFS_INVISIBLE);
   if(((struct session *)sess)->server->flags&(1<<0))
   {
      if(prefs.flags&(1<<PREFS_INVISIBLE))
        sprintf(tbuf, "MODE %s +i\r\n", ((struct session *)sess)->server->nick);
      else
        sprintf(tbuf, "MODE %s -i\r\n", ((struct session *)sess)->server->nick);
      send(((struct session *)sess)->server->sok, tbuf, strlen(tbuf), 0);
   }
}

void menu_help(GtkWidget *wid, gpointer sess)
{
   cmd_help(sess, 0, 0, 0);
}

GtkWidget *about = 0;

void about_close(void)
{
   gtk_widget_destroy(about);
   about = 0;
}

void menu_savedefault(GtkWidget *wid, gpointer sess)
{
   save_config();
}

void menu_chanlist(GtkWidget *wid, gpointer sess)
{
   chanlist_opengui(((struct session *)sess)->server);
}

void goto_url()
{
   popen("netscape -remote 'openURL(http://Users.Mentasm.com/~zed/xchat/)'", "r"); 
}

void menu_about(GtkWidget *wid, gpointer sess)
{
   GtkWidget *label, *button;

   if(about) gtk_widget_destroy(about);

   about = gtk_dialog_new();
   gtk_window_position (GTK_WINDOW(about), GTK_WIN_POS_CENTER);

   label = gtk_label_new(
			 "X-Chat "VERSION" by Peter Zelezny\n\n"
			 );
   gtk_container_border_width(GTK_CONTAINER(GTK_DIALOG(about)->vbox), 10);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(about)->vbox), label, TRUE, TRUE, 10);
   gtk_widget_show(label);

   button = gtk_button_new_with_label("http://Users.Mentasm.com/~zed/xchat/");
   gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                               GTK_SIGNAL_FUNC (goto_url), 0);
   gtk_box_pack_end(GTK_BOX(GTK_DIALOG(about)->vbox), button, TRUE, TRUE, 10);
   gtk_widget_show(button);

   button = gtk_button_new_with_label ("Ok");
   GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG(about)->action_area), button, TRUE, TRUE, 10);
   gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                               GTK_SIGNAL_FUNC (about_close), 0);
   gtk_widget_grab_default (button);
   gtk_widget_show (button);
   
   gtk_widget_show(about);
}

static struct mymenu mymenu[] =
{
     {M_NEWMENU, "X-Chat", 0,0,1},
     {M_MENU, "Server List..", open_server_list, 0, 1},
     {M_MENU, "New Server Window..", menu_newserver,0,1},
     {M_MENU, "New Channel Window..", menu_newchannel,0,1},
     {M_SEP, 0, 0,0,0},
     {M_MENU, "Help..", menu_help,0,1},
     {M_MENU, "About..", menu_about,0,1},
     {M_SEP, 0, 0,0,0},
     {M_MENU, "Close", menu_close,0,1},
     {M_SEP, 0, 0,0,0},
     {M_MENU, "Quit", xchat_cleanup,0,1}, /* 10 */
     
     {M_NEWMENU, "Windows", 0,0,1},
     {M_MENU, "Channel List Window..", menu_chanlist,0,1},
     {M_MENU, "DCC Send Window..", open_dcc_send_window,0,1},
     {M_MENU, "DCC Receive Window..", open_dcc_recv_window,0,1},
     {M_MENU, "DCC Chat Window..", open_dcc_chat_window,0,1},
     {M_MENU, "Raw Log Window..", menu_rawlog,0,1},
     {M_MENU, "URL Grabber Window..", url_opengui,0,1},
     {M_SEP, 0, 0,0,0},
     {M_MENU, "Flush Buffer", menu_flushbuffer,0,1},
     {M_MENU, "Save Buffer..", menu_savebuffer,0,1},
     
     {M_NEWMENU, "User Modes", 0,0,1},
     {M_MENUTOG, "Invisible", menu_invisible,1,1},
     {M_MENUTOG, "Receive Wallops", menu_wallops,1,1},
     {M_MENUTOG, "Receive Server Notices", menu_servernotice,1,1},
     {M_SEP, 0, 0,0,0},
     {M_MENUTOG, "Marked Away", menu_away,0,1},
     {M_SEP, 0, 0,0},
     {M_MENUTOG, "Auto ReJoin on Kick", menu_autorejoin,0,1},
     {M_MENUTOG, "Auto ReConnect to Server", menu_autoreconnect,0,1},
     {M_SEP, 0, 0,0},
     {M_MENUTOG, "Auto Open Dialog Windows", menu_autodialog,0,1},
     /*{M_MENUTOG, "Auto Accept DCC Chat", 0,0,0},   
     {M_MENUTOG, "Do BEEP Sounds", 0,0,0},
     {M_MENUTOG, "Play CTCP Sounds", 0,0,0},*/  
     
     {M_NEWMENU, "Settings", 0,0,1}, 
     {M_MENU, "Setup..", menu_settings,0,1},
     {M_MENU, "Lists..", 0,0,0},
     {M_MENU, "Function Keys..", 0,0,0},
     {M_SEP, 0, 0,0,0},
     {M_MENU, "Save Settings now", menu_savedefault,0,1},
     {M_MENUTOG, "Save Settings on exit", menu_saveexit,1,1}, 
     
     {M_END, 0, 0,0,0},
};


GtkWidget *createmenus(struct session *sess)
{
   int i = 0;
   GtkWidget *item;
   GtkWidget *menu = 0;
   GtkWidget *menu_item = 0;
   GtkWidget *menu_bar = gtk_menu_bar_new();

   if(prefs.flags&(1<<PREFS_INVISIBLE))
     mymenu[22].state = 1;
   else
     mymenu[22].state = 0;
   
   if(prefs.flags&(1<<PREFS_WALLOPS))
     mymenu[23].state = 1;
   else
     mymenu[23].state = 0;
   
   if(prefs.flags&(1<<PREFS_SERVERNOTICE))
     mymenu[24].state = 1;
   else
     mymenu[24].state = 0;

   if(prefs.flags&(1<<PREFS_AUTOREJOIN))
     mymenu[28].state = 1;
   else
     mymenu[28].state = 0;

   if(prefs.flags&(1<<PREFS_AUTORECONNECT))
     mymenu[29].state = 1;
   else
     mymenu[29].state = 0;
   
   if(prefs.flags&(1<<PREFS_AUTODIALOG))
     mymenu[31].state = 1;
   else
     mymenu[31].state = 0;

   if(prefs.flags&(1<<PREFS_AUTOSAVE))
     mymenu[38].state = 1;
   else
     mymenu[38].state = 0;
   
   while(1)
   {
      switch(mymenu[i].type)
      {
       case M_NEWMENU:
	 if(menu) gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item), menu);
	 menu = gtk_menu_new();
	 menu_item = gtk_menu_item_new_with_label(mymenu[i].text);
	 gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), menu_item);
	 gtk_widget_show(menu_item);
	 break;
       case M_MENU:
	 item = gtk_menu_item_new_with_label(mymenu[i].text);
	 if(mymenu[i].callback)
	   gtk_signal_connect_object(GTK_OBJECT(item), "activate",
				     GTK_SIGNAL_FUNC(mymenu[i].callback), (gpointer)sess);
	 gtk_menu_append(GTK_MENU(menu), item);
	 gtk_widget_show(item);
	 gtk_widget_set_sensitive(item, mymenu[i].activate);
	 break;
       case M_MENUTOG:
	 item = gtk_check_menu_item_new_with_label(mymenu[i].text);
	 gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(item), mymenu[i].state);
	 if(mymenu[i].callback)
	   gtk_signal_connect_object(GTK_OBJECT(item), "toggled",
				     GTK_SIGNAL_FUNC(mymenu[i].callback), (gpointer)sess);
	 gtk_menu_append(GTK_MENU(menu), item);
	 gtk_widget_show(item);
	 gtk_widget_set_sensitive(item, mymenu[i].activate);
	 break;
       case M_SEP:
	 item = gtk_menu_item_new();
	 gtk_widget_set_sensitive(item, FALSE);
	 gtk_menu_append(GTK_MENU(menu), item);
	 gtk_widget_show(item);	 
	 break;
       case M_END:
	 if(menu) gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item), menu);
	 return(menu_bar);
      }
      i++;
   }
}
