/*
Copyright (c) 1998 Peter Zelezny.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "style.h"
#include "xchat.h"
#include <sys/utsname.h>
#include <netdb.h>
#include <time.h>

// xchat.c

extern struct session *find_session_from_nick(char *nick, struct server *serv);
extern struct session *find_session_from_channel(char *chan, struct server *serv);
extern struct session *find_session_from_waitchannel(char *chan);
extern void show_generic_channel(struct server *serv, char *chan, char *msg);
extern void PrintText(struct session *sess, char *text);
extern void PrintTextServ(struct server *serv, char *text);
extern struct session *new_session(struct server *serv, char *channel);

// rawlog.c

extern void add_rawlog(struct server *serv, char *text);

// dcc.c

extern void handle_dcc(struct session *sess, char *outbuf, char *nick, char *word[], char *word_eol[]);

// dialog.c

extern int add_to_dialog(struct server *, char *tbuf, char *nick, char *text, char *ip, int notice);

// userlist.c

extern struct user *find_name(struct session *sess, char *name);
extern void update_user_list(struct session *sess);
extern void clear_user_list(struct session *sess);
extern void sort_namelist(struct session *sess);
extern void voice_name(struct session *sess, char *name);
extern void devoice_name(struct session *sess, char *name);
extern void op_name(struct session *sess, char *name);
extern void deop_name(struct session *sess, char *name);
extern void add_name(struct session *sess, char *name, int sort, int update);
extern int sub_name(struct session *sess, char *name);
extern void change_nick(struct session *sess, char *oldnick, char *newnick);
extern void gui_change_nick(struct server *serv, char *newnick);

// urlgrab.c

extern void url_checkurl(char *buf);

// outbound.c

extern void process_data_init(unsigned char *buf, char *cmd, char *word[], char *word_eol[]);

// chanlist.c

extern void chanlist_addentry(struct server *serv, char *chan, char *users, char *topic);

// util.c

extern char *nocasestrstr(char *text, char *tofind);

extern GSList *sess_list;
extern struct server firstserver;
extern struct xchatprefs prefs;

#define find_word_to_end(a, b) word_eol[b]
#define find_word(a, b) word[b]

char chan_flags[] = {'t','n','s','i','p','m','l','k'};

void private_msg(struct server *serv, char *tbuf, char *from, char *ip, char *text)
{
   struct session *sess;
   if(add_to_dialog(serv, tbuf, from, text, ip, FALSE)) return;
   sprintf(tbuf, PRIVMSG_TEXT, from, text);
   sess = find_session_from_nick(from, serv);
   if(!sess) sess = serv->front_session;
   PrintText(sess, tbuf);
}

void channel_action(struct session *sess, char *chan, char *from, char *text)
{
   char outbuf[1024];
   struct session *def = sess;
   
   sprintf(outbuf, ACTION_TEXT, from, text);
   
   sess = find_session_from_channel(chan, sess->server);
   if(sess)
     PrintText(sess, outbuf);
   else
     PrintText(def, outbuf);
}

void channel_msg(struct server *serv, char *outbuf, char *chan, char *from, char *text, char fromme)
{
   if(fromme)
     sprintf(outbuf, CHANNEL_MSG_FROM_USER, from, text);
   else {
      if(nocasestrstr(text, serv->nick))
	sprintf(outbuf, CHANNEL_MSG_WITH_NICK, from, text);
      else
	sprintf(outbuf, CHANNEL_MSG, from, text);
   }
   show_generic_channel(serv, chan, outbuf);
}

void user_new_nick(struct server *serv, char *outbuf, char *nick, char *newnick, int quiet)
{
   int me;
   struct session *sess;
   GSList *list = sess_list;
   if(!strcasecmp(nick, serv->nick)) me = TRUE; else me = FALSE;
   while(list)
   {
      sess = (struct session *)sess_list->data;
      if(sess->server == serv)
      {
	 if(me || find_name(sess, nick))
	 {
	    if(!quiet)
	    {
	       if(me)
	       	 sprintf(outbuf, STARTON" You are now known as %s\n", newnick);
	       else
		 sprintf(outbuf, STARTON" %s is now known as %s\n",
		    nick, newnick);
	       PrintText(sess, outbuf);
	    }
	    change_nick(sess, nick, newnick);
	 }
      }
      list = list->next;
   }

   if(me) gui_change_nick(serv, newnick);
}

void you_joined(struct session *def, char *outbuf, char *chan, char *nick, char *ip)
{
   struct session *sess = find_session_from_waitchannel(chan);
   if(sess)
   {
      strcpy(sess->channel, chan);
      sess->waitchannel[0] = 0;
      sess->chanflags = 0;
      gtk_label_set(GTK_LABEL(sess->changad), chan);
      jump:
      sprintf(outbuf, "MODE %s\r\n", chan);
      send(sess->server->sok, outbuf, strlen(outbuf), 0);
      sprintf(outbuf, STARTON"\00311 \002%s\002 \00314(\00310%s\00314)\003  has joined %s\n", nick, ip, chan);
      PrintText(sess, outbuf);
      clear_user_list(sess);
   } else {
      sess = new_session(def->server, chan);
      if(sess) goto jump;
   }
}

void you_kicked(struct server *serv, char *tbuf, char *chan, char *kicker, char *reason)
{
   struct session *sess = find_session_from_channel(chan, serv);
   if(sess)
   {
      sess->channel[0] = 0;
      sprintf(tbuf, STARTON" You have been kicked from %s by %s (%s)\n",
	      chan, kicker, reason);
      PrintText(sess, tbuf);
      gtk_entry_set_text(GTK_ENTRY(sess->topicgad), "");
      gtk_label_set(GTK_LABEL(sess->namelistinfo), "");
      gtk_label_set(GTK_LABEL(sess->changad), "#nonejoined");
      clear_user_list(sess);
      if(prefs.flags&(1<<PREFS_AUTOREJOIN))
      {
	 sprintf(tbuf, "JOIN %s\r\n", chan);
	 send(sess->server->sok, tbuf, strlen(tbuf), 0);
	 strcpy(sess->waitchannel, chan);
      }
   }
}

void you_parted(struct server *serv, char *tbuf, char *chan)
{
   struct session *sess = find_session_from_channel(chan, serv);
   if(sess)
   {
      sess->channel[0] = 0;
      sprintf(tbuf, STARTON" You have left channel %s\n", chan);
      PrintText(sess, tbuf);
      gtk_entry_set_text(GTK_ENTRY(sess->topicgad), "");
      gtk_label_set(GTK_LABEL(sess->namelistinfo), "");
      gtk_label_set(GTK_LABEL(sess->changad), "#nonejoined");
      clear_user_list(sess);
   }
}

void names_list(struct server *serv, char *tbuf, char *buf)
{
   char *po;
   buf+=2;
   po = strchr(buf, ' ');
   if(po)
   {
      struct session *sess;
      char name[52];
      int pos = 0;

      po[0] = 0;
 
      sess = find_session_from_channel(buf, serv);
      if(!sess) return;
 
      if(sess->chanflags&(1<<0))
      {
	 sprintf(tbuf, STARTON" \00311Users: \003 %s\n", po+2); // buf = chan
	 PrintText(sess, tbuf);
      }

      if(sess->chanflags&(1<<4)) // end of names
      {
	 sess->chanflags &= ~(1<<4);
	 clear_user_list(sess);
      }

      buf = po+1;

      while(1)
      {
	 buf++;
	 switch(*buf)
	 {
	  case 0:
	    name[pos] = 0;
	    if(pos != 0) add_name(sess, name, FALSE, FALSE);
	    sort_namelist(sess);
	    update_user_list(sess);
	    return;
	  case ' ':
	    name[pos] = 0;
	    pos = 0;
	    add_name(sess, name, FALSE, FALSE);
	    break;
	  default:
	    name[pos] = *buf;
	    pos++;
	    if(pos == 51) pos = 50;
	 }
      }
   }
}

void topic(struct server *serv, char *tbuf, char *buf)
{
   char *po = strchr(buf, ' ');
   if(po)
   {
      struct session *sess;
      po[0] = 0;
      sess = find_session_from_channel(buf, serv);
      if(sess)
      {
	 gtk_entry_set_text(GTK_ENTRY(sess->topicgad), po+2);
	 sprintf(tbuf, STARTON" Topic for\00311 %s \003 is\00311 %s\n", buf, po+2);
	 PrintText(sess, tbuf);
      }
   }
}

void new_topic(struct server *serv, char *tbuf, char *nick, char *chan, char *topic)
{
   struct session *sess = find_session_from_channel(chan, serv);
   if(sess)
   {
      gtk_entry_set_text(GTK_ENTRY(sess->topicgad), topic);
      sprintf(tbuf, STARTON" %s has changed the topic to: %s\n", nick, topic);
      PrintText(sess, tbuf);
   }
}

void user_joined(struct server *serv, char *outbuf, char *chan, char *user, char *ip)
{
   struct session *sess = find_session_from_channel(chan, serv);
   if(sess)
   {
      sprintf(outbuf, STARTON"\00311 \002%s\002 \00314(\00310%s\00314)\003  has joined %s\n", user, ip, chan);
      PrintText(sess, outbuf);
      add_name(sess, user, TRUE, TRUE);
   }
}

void user_kicked(struct server *serv, char *outbuf, char *chan, char *user, char *kicker, char *reason)
{
   struct session *sess = find_session_from_channel(chan, serv);
   if(sess)
   {
      sprintf(outbuf, STARTON" %s has kicked %s from %s (%s)\n",
	      kicker, user, chan, reason);
      PrintText(sess, outbuf);
      sub_name(sess, user);
   }
}

void user_parted(struct server *serv, char *chan, char *user, char *ip)
{
   char outbuf[136];
   struct session *sess = find_session_from_channel(chan, serv);
   if(sess)
   {
      sprintf(outbuf, STARTON" %s \00314(\003 %s\00314)\003  has left %s\n", user, ip, chan);
      PrintText(sess, outbuf);
      sub_name(sess, user);
   } /*else
     printf("- stray PART %s %s\n", chan, user);*/
}

void channel_date(struct session *sess, char *tbuf, char *chan, char *timestr)
{
   long n = atol(timestr);
   sprintf(tbuf, STARTON" Channel %s created on %s",
	   chan, ctime(&n));
   PrintText(sess, tbuf);
   //show_generic_channel(serv, chan, tbuf);
}

void topic_nametime(struct server *serv, char *tbuf, char *chan, char *nick, char *date)
{
   long n = atol(date);
   sprintf(tbuf, STARTON" Topic for\00311 %s \003 set by \00311%s \003 at \00311%s",
	   chan, nick, ctime(&n));
   show_generic_channel(serv, chan, tbuf);
}

void set_server_name(char *tbuf, struct server *serv, char *name)
{
   GSList *list = sess_list;
   struct session *sess;
   
   sprintf(tbuf, "X-Chat ("VERSION"): %s", name);
   strcpy(serv->servername, name);
   
   while(list)
   {
      sess = (struct session *)list->data;
      if(sess->server == serv)
	   gtk_window_set_title(GTK_WINDOW(sess->window), tbuf);
      list = list->next;
   }
}

extern int hidever;

void handle_ctcp(struct session *sess, char *outbuf, char *to, char *nick, char *msg, char *word[], char *word_eol[])
{
   char *po;
   if(!strncasecmp(msg, "VERSION", 7))
   {
      if(!hidever)
      {
      struct utsname un;
      if(uname(&un) < 0)
	sprintf(outbuf, "NOTICE %s :\001VERSION X-Chat "VERSION" By ZED/DC\001\r\n",
		nick);
      else
	sprintf(outbuf, "NOTICE %s :\001VERSION X-Chat "VERSION" By ZED/DC - %s %s\001\r\n",
		nick, un.sysname, un.release);
      send(sess->server->sok, outbuf, strlen(outbuf), 0);
      }
   }
   if(!strncasecmp(msg, "PING", 4))
   {
      sprintf(outbuf, "NOTICE %s :\001%s\r\n", nick, msg);
      send(sess->server->sok, outbuf, strlen(outbuf), 0);
   }
   if(!strncasecmp(msg, "ACTION", 6))
   {
      char *po = strchr(msg+7, '\001');
      if(po) po[0] = 0;
      channel_action(sess, to, nick, msg+7);
      return;
   }
   if(!strncasecmp(msg, "DCC", 3))
   {
      handle_dcc(sess, outbuf, nick, word, word_eol);
      return;
   }
   if(!strncasecmp(msg, "TIME", 4))
   {
      char timestr[64];
      long tt = time(0);
      char *p, *t = ctime(&tt);
      strcpy(timestr, t);
      p = strchr(timestr, '\n');
      if(p) *p=0;
      sprintf(outbuf, "NOTICE %s :\001TIME %s\001\r\n",
		nick, timestr);
      send(sess->server->sok, outbuf, strlen(outbuf), 0);
   }
   
   po = strchr(msg, '\001');
   if(po) po[0] = 0;
   if(*to != '#')
     sprintf(outbuf, STARTON" Received a CTCP %s from %s\n", msg, nick);
   else
     sprintf(outbuf, STARTON" Received a CTCP %s from %s (to %s)\n", msg, nick, to);
   PrintText(sess->server->front_session, outbuf);
}

void user_quit(struct session *sess, char *outbuf, char *nick, char *reason)
{
   GSList *list = sess_list;
   struct server *serv = sess->server;
   sprintf(outbuf, STARTON" %s has quit \00314(\003 %s\00314)\n", nick, reason);
   while(list)
   {
      sess = (struct session *)list->data;
      if(sess->server == serv)
      {
	 if(sub_name(sess, nick)) PrintText(sess, outbuf);
      }
      list = list->next;
   }
}

void notice(struct server *serv, char *outbuf, char *to, char *nick, char *msg, char *ip)
{
   char *po;
   struct session *sess = 0;

   if(to[0] == '#') sess = find_session_from_channel(to, serv);
   if(!sess)
   {
      sess = find_session_from_nick(nick, serv);
      if(!sess) sess = serv->front_session;
   }

   if(msg[0] == 1)
   {
      msg++;
      if(!strncmp(msg, "PING", 4))
      {
	 long t;
	 time(&t);
	 sprintf(outbuf,
		 STARTON" Ping time %ld seconds to %s \n",
		 t-atol(msg+5), nick);
	 PrintText(sess, outbuf);
	 return;
      }
   }
   po = strchr(msg, '\001');
   if(po) po[0] = 0;
   if(add_to_dialog(sess->server, outbuf, nick, msg, ip, TRUE)) return;
   sprintf(outbuf, "\00312-\00313%s\00312- \003 %s\n", nick, msg);
   PrintText(sess, outbuf);
}

void channel_mode(struct server *serv, char *outbuf, char *chan, char *nick, char sign, char mode, char *extra)
{
   int state, i;
   struct session *sess = find_session_from_channel(chan, serv);
   if(sess)
   {
      switch(sign)
      {
       case '+':
	 switch(mode)
	 {
	  case 'o':
	    op_name(sess, extra);
	    sprintf(outbuf, STARTON" %s gives channel operator status to %s\n", nick, extra);
	    PrintText(sess, outbuf);
	    return;
	  case 'v':
	    voice_name(sess, extra);
	    sprintf(outbuf, STARTON" %s gives voice to %s\n", nick, extra);
	    PrintText(sess, outbuf);
	    return;
	  case 'b':
	    sprintf(outbuf, STARTON" %s sets ban on %s\n", nick, extra);
	    PrintText(sess, outbuf);
	    return;
	 }
	 break;
       case '-':
	 switch(mode)
	 {
	  case 'o':
	    deop_name(sess, extra);
	    sprintf(outbuf, STARTON" %s removes channel operator status from %s\n", nick, extra);
	    PrintText(sess, outbuf);
	    return;
	  case 'v':
	    devoice_name(sess, extra);
	    sprintf(outbuf, STARTON" %s removes voice from %s\n", nick, extra);
	    PrintText(sess, outbuf);
	    return;
	  case 'b':
	    sprintf(outbuf, STARTON" %s removes ban on %s\n", nick, extra);
	    PrintText(sess, outbuf);
	    return;  
	 }
	 break;
      }
      if(extra && *extra)
	sprintf(outbuf, STARTON" %s sets mode %c%c %s\n", nick, sign, mode, extra);
      else
	sprintf(outbuf, STARTON" %s sets mode %c%c %s\n", nick, sign, mode, chan);
      PrintText(sess, outbuf);

      if(sign == '+') state = TRUE; else state = FALSE;

      for(i=0; i<8; i++)
      {
	 if(chan_flags[i] == mode)
	 {
	    gtk_toggle_button_set_state((GtkToggleButton*)sess->flag_wid[i],
				  state);
	 }
      }
   } else {
      sprintf(outbuf, STARTON" %s sets mode %c%c %s\n", nick, sign, mode, chan);
      PrintTextServ(serv, outbuf);
   }
}

void channel_modes(struct server *serv, char *outbuf, char *word[], char *buf, char *nick)
{
   char *chan = find_word(pdibuf, 3);
   if(*chan)
   {
      char *modes = find_word(pdibuf, 4);
      if(*modes)
      {
	 int i = 5;
	 char sign;
	 if(*modes == ':') modes++; // not a channel mode, eg +i
	 sign = modes[0];
	 modes++;
	 while(1)
	 {
	    channel_mode(serv, outbuf, chan, nick, sign, modes[0], word[i]);
	    i++;
	    modes++;
	    if(modes[0] == 0 || modes[0] == ' ') return;
	    if(modes[0] == '-' || modes[0] == '+')
	    {
	       sign = modes[0];
	       modes++;
	       if(modes[0] == 0 || modes[0] == ' ') return;
	    }
	 }
      }
   }
}

void end_of_names(struct server *serv, char *outbuf, char *chan, char *text)
{
   struct session *sess = find_session_from_channel(chan, serv);
   if(sess)
   {
      sess->chanflags |= (1<<0); // names done
      sess->chanflags |= (1<<4); // end of names
      //PrintText(sess, STARTON" End of User List.\n");
   }
}

void server_pong(struct session *sess, char *outbuf, char *from, char *tim)
{
      long t;
      time(&t);
      sprintf(outbuf,
	      STARTON" Ping time %ld seconds to %s \n",
	      t-atol(tim), from);
      PrintText(sess, outbuf);
      return;
}

void check_willjoin_channels(struct server *serv, char *tbuf)
{
   struct session *sess;
   GSList *list = sess_list;
   while(list)
   {
      sess = (struct session *)list->data;
      if(sess->server == serv)
      {
	 if(sess->willjoinchannel[0] != 0)
	 {
	    strcpy(sess->waitchannel, sess->willjoinchannel);
	    sess->willjoinchannel[0] = 0;
	    sprintf(tbuf, "JOIN %s\r\n", sess->waitchannel);
	    send(serv->sok, tbuf, strlen(tbuf), 0);
	 }
      }
      list = list->next;
   }
}

void next_nick(struct session *sess, char *outbuf, char *nick)
{
   sess->server->nickcount++;

   switch(sess->server->nickcount)
   {
    case 2:
      sprintf(outbuf, "NICK %s\r\n", prefs.nick2);
      send(sess->server->sok, outbuf, strlen(outbuf), 0);
      sprintf(outbuf, STARTON" %s already in use. Retrying with %s..\n", nick, prefs.nick2);
      PrintText(sess, outbuf);
      break;

    case 3:
      sprintf(outbuf, "NICK %s\r\n", prefs.nick3);
      send(sess->server->sok, outbuf, strlen(outbuf), 0);
      sprintf(outbuf, STARTON" %s already in use. Retrying with %s..\n", nick, prefs.nick3);
      PrintText(sess, outbuf);
      break;

    default:
      PrintText(sess, STARTON" Nickname already in use. Use /NICK to try another.\n");
   }
}

void channel_flags(struct session *sess, char *flags, char *therest)
{
   int i;

   for(i=0; i<8; i++)
     gtk_toggle_button_set_state((GtkToggleButton*)sess->flag_wid[i], 0);  
   if(*flags == '+') flags++;
   while(*flags)
   { 
      for(i=0; i<8; i++)
      {
	 if(chan_flags[i] == *flags)
	    gtk_toggle_button_set_state((GtkToggleButton*)sess->flag_wid[i], 1);
      }
      flags++;
   }
}

void process_line(struct session *sess, struct server *serv, char *buf)
{
   char pdibuf[4096];
   char outbuf[4096];
   char *word[32];
   char *word_eol[32];
   int n;

   add_rawlog(serv, buf);
   url_checkurl(buf);

   if(buf[0] != ':')
   {
      if(!strncmp(buf, "NOTICE ", 7))
      {
	 sprintf(outbuf, STARTON" %s\n", buf+7);
	 PrintText(sess, outbuf);
	 return;
      }
      if(!strncmp(buf, "PING :", 6))
      {
	 sprintf(outbuf, "PONG :%s\r\n", buf+6);
	 send(serv->sok, outbuf, strlen(outbuf), 0);
	 return;
      }
      if(!strncmp(buf, "ERROR", 5))
      {
	 sprintf(outbuf, STARTON" %s\n", buf+7);
	 //send(serv->sok, outbuf, strlen(outbuf), 0);
	 PrintText(serv->front_session, outbuf);
	 return;
      }
      PrintText(sess, STARTON" ");
      PrintText(sess, buf);
      PrintText(sess, "\n");
   } else {
      buf++;

      process_data_init(pdibuf, buf, word, word_eol);
      
      n = atoi(find_word(pdibuf, 2));
      if(n)
      {
	 struct session *realsess = 0;
	 char *text = find_word_to_end(buf, 3);
	 if(*text)
	 {
	    if(!strncasecmp(serv->nick, text, strlen(serv->nick)))
	       text += strlen(serv->nick) + 1;
	    if(*text == ':') text++;
	    switch(n)
	    {
	     case 1:
	       //new_nick(sess, find_word(pdibuf, 3), TRUE);
	       user_new_nick(serv, outbuf, serv->nick, word[3], TRUE);
	       set_server_name(outbuf, serv, pdibuf); goto def;
	     case 301:
	       sprintf(outbuf, STARTON" %s is away (%s)\n",
		       find_word(pdibuf, 4), find_word_to_end(buf, 5)+1);
	       PrintText(serv->front_session, outbuf);
	       break;
	     case 312:
	       sprintf(outbuf, STARTON" \00312[\003 %s\00312] \003 %s\n",
		      word[4], word_eol[5]);
	       PrintText(serv->front_session, outbuf);
	       break;
	     case 311:
	     case 314:
	       sprintf(outbuf, STARTON" \00312[\003 %s\00312] \00314(\003 %s@%s\00314) \003 : %s\n",
		       find_word(pdibuf, 4), find_word(pdibuf, 5),
		       find_word(pdibuf, 6), find_word_to_end(buf, 8)+1);
	       PrintText(serv->front_session, outbuf);
	       break;
	     case 317:
	       {
		  long n = atol(find_word(pdibuf, 6));
		  sprintf(outbuf, STARTON" \00312[\003 %s\00312] \003 idle \00311%s\003 , signon: \00311%s",
		       find_word(pdibuf, 4), find_word(pdibuf, 5),
		       ctime(&n));
		  PrintText(serv->front_session, outbuf);
	       }
	       break;
	     case 318:
	       sprintf(outbuf, STARTON" \00312[\003 %s\00312] \003 End of WHOIS list.\n",
		       word[4]);
	       PrintText(serv->front_session, outbuf);
	       break;
	     case 313:
	     case 319:
	       sprintf(outbuf, STARTON" \00312[\003 %s\00312] \003 %s\n",
		       word[4], word_eol[5]+1);
	       PrintText(serv->front_session, outbuf);
	       break;
	     case 321:
	       if(!sess->server->chanlist_window)
		 PrintText(sess, STARTON" Channel\t\t\tUsers\tTopic\n"); break;
	     case 322:
	       if(sess->server->chanlist_window)
	       {
		  chanlist_addentry(sess->server, find_word(pdibuf, 4),
				    find_word(pdibuf, 5),
				    find_word_to_end(buf, 6)+1);
	       } else {
		  sprintf(outbuf, STARTON" %-16.16s %-7d %s\n",
		       find_word(pdibuf, 4),
		       atoi(find_word(pdibuf, 5)),
		       find_word_to_end(buf, 6)+1);
		  PrintText(sess, outbuf);
	       }
	       break;
	     case 323:
	       	if(!sess->server->chanlist_window) goto def;
		break;
	     case 324:
	       sess = find_session_from_channel(word[4], serv);
	       if(sess)
	       {
		  if(sess->chanflags&(1<<1))
		  {
		     sprintf(outbuf, STARTON" Channel %s modes: %s\n",
		       word[4], word_eol[5]);
		     PrintText(sess, outbuf);
		     //show_generic_channel(serv, word[4], outbuf);
		  } else
		     sess->chanflags |= (1<<1);
		  channel_flags(sess, word[5], word_eol[6]);
	       }
	       break;
	     case 329:
	       sess = find_session_from_channel(word[4], serv);
	       if(sess)
	       {
		  if(sess->chanflags&(1<<2))
		    channel_date(sess, outbuf, word[4], word[5]);
		  else
		    sess->chanflags |= (1<<2);
	       }
	       break;
	     case 332:
	       topic(serv, outbuf, text); break;
	     case 333:
	       topic_nametime(serv, outbuf, find_word(pdibuf, 4), 
			      find_word(pdibuf, 5),
			      find_word(pdibuf, 6)); break;
	     case 353:
	       names_list(serv, outbuf, text); break;
	     case 366:
	       end_of_names(serv, outbuf, find_word(pdibuf, 4), text); break;
	     case 376:
	       check_willjoin_channels(serv, outbuf); goto def;
	     case 433:
	       next_nick(sess, outbuf, word[4]); break;
	     default:
	       def:
	       if(prefs.flags&(1<<PREFS_SKIPMOTD))
	       {
		  if(n == 375 || n == 372) return;
		  if(n == 376)
		  {
		     PrintText(sess, STARTON" Skiped.\n");
		     return;
		  }
	       }
	       sprintf(outbuf, STARTON" %s\n", text);
	       if(*text == '#')
	       {
		  char *chan = find_word(pdibuf, 3);
		  if(!strncasecmp(serv->nick, chan, strlen(serv->nick)))
		    chan += strlen(serv->nick) + 1;
		  if(*chan == ':') chan++;
		  realsess = find_session_from_channel(chan, serv);
		  if(!realsess) realsess = sess;
		  PrintText(realsess, outbuf);
	       } else {
		  PrintText(serv->front_session, outbuf);
	       }
	    }
	 }
      } else {
	 char t;
	 char nick[64], ip[80];
	 char *po2, *po = strchr(buf, '!');

	 if(po)
	 {
	    po2 = strchr(buf, ' ');
	    if((unsigned long)po2 < (unsigned long)po) po = 0;
	 }

	 if(!po) // SERVER Message
	 {
	       strcpy(ip, pdibuf);
	       strcpy(nick, pdibuf);
	       goto j2;
	 }

	 if(po)
	 {
	    t = *po;
	    *po = 0;
	    strcpy(nick, buf);
	    *po = t;
	    po2 = strchr(po, ' ');
	    if(po2)
	    {
	       char *cmd;
	       t = *po2;
	       *po2 = 0;
	       strcpy(ip, po+1);
	       *po2 = t;
	       j2:	       
	       cmd = find_word(pdibuf, 2);
	       
	       if(!strcmp("JOIN", cmd))
	       {
		  if(!strcmp(nick, serv->nick))
		    you_joined(sess, outbuf, find_word_to_end(buf, 3)+1, nick, ip);
		  else
		    user_joined(serv, outbuf, find_word_to_end(buf, 3)+1, nick, ip);
		  return;
	       }
 	       
	       if(!strcmp("MODE", cmd))
	       {
		  channel_modes(serv, outbuf, word, buf, nick);
		  return;
	       }

	       if(!strcmp("NICK", cmd))
	       {
		  /*if(!strcmp(nick, serv->nick))
		     new_nick(sess, find_word_to_end(buf, 3)+1, FALSE);
		  else*/
		     user_new_nick(serv, outbuf, nick, find_word_to_end(buf, 3)+1, FALSE);
		  return;
	       }
	       
	       if(!strcmp("NOTICE", cmd))
	       {
		  char *to = find_word(pdibuf, 3);
		  if(*to)
		  {
		     char *msg = find_word_to_end(buf, 4)+1;
		     if(*msg)
		     {
			notice(serv, outbuf, to, nick, msg, ip);
			return;
		     }
		  }
	       }
	       
	       if(!strcmp("PART", cmd))
	       {
		  if(!strcmp(nick, serv->nick))
		    you_parted(serv, outbuf, cmd+5);
		  else
		    user_parted(serv, cmd+5, nick, ip);
		  return;
	       }
	       
	       if(!strcmp("PRIVMSG", cmd))
	       {
		  char *to = find_word(pdibuf, 3);
		  if(*to)
		  {
		     char *msg = find_word_to_end(buf, 4)+1;
		     if(msg[0] == 1) // CTCP
			handle_ctcp(sess, outbuf, to, nick, msg+1, word, word_eol);
		     else {
			if(to[0] == '#')
			   channel_msg(serv, outbuf, to, nick, msg, FALSE);
			else
			   private_msg(serv, outbuf, nick, ip, msg);
		     }
		     return;
		  }
	       }
	       
	       if(!strcmp("PONG", cmd))
	       {
		  server_pong(sess, outbuf, find_word(pdibuf, 3),
			      find_word(pdibuf, 4)+1);
		  return;
	       }
	       
	       if(!strcmp("QUIT", cmd))
	       {
		  user_quit(sess, outbuf, nick, find_word_to_end(buf, 3)+1);
		  return;
	       }
	   
	       if(!strcmp("TOPIC", cmd))
	       {
		  new_topic(serv, outbuf, nick, find_word(pdibuf, 3),
			    find_word_to_end(buf, 4)+1);
		  return;
	       }
	       
	       if(!strcmp("KICK", cmd))
	       {
		  char *kicked = find_word(pdibuf, 4);
		  if(*kicked)
		  {
		     if(!strcmp(kicked, serv->nick))
			 you_kicked(serv, outbuf, find_word(pdibuf, 3), nick,
				    find_word_to_end(buf, 5)+1);
		     else
		       user_kicked(serv, outbuf, find_word(pdibuf, 3), kicked,
				   nick, find_word_to_end(buf, 5)+1);
		     return;
		  }
	       }
	       
	       if(!strcmp("KILL", cmd))
	       {
		  sprintf(outbuf,
			  STARTON" You have been killed by %s %s\n",
			  word[3], word_eol[5]);
		  PrintText(sess, outbuf);
		  return;
	       }

	       sprintf(outbuf, "(%s/%s) %s\n", nick, ip, find_word_to_end(buf, 2));
	       PrintText(sess, outbuf);
	       return;
	    }
	 }
	 PrintText(sess, STARTON" ");
	 PrintText(sess, buf);
	 PrintText(sess, "\n");
      }
   }
}
