/* filename: rlpr-util.h
 * project: rlpr
 * author: meem  --  meem@sherilyn.wustl.edu
 * version: $Id: rlpr-util.h,v 1.1 1997/02/22 07:22:27 meem Exp meem $
 * contents: useful #defines, headers for general-purpose rlpr functions
 *
 * Time-stamp: <1997/04/27 14:44:13 cdt -- meem@sherilyn.wustl.edu>
 */

#ifndef RLPR_UTIL_H
#define RLPR_UTIL_H

#include <sys/types.h>
#include <errno.h>
#include <netinet/in.h>         /* for sockaddr_in struct */
#include <sys/socket.h>         /* for AF_INET definition */

#include "rlpr-msg.h"		/* check_ptr uses rlpr_msg() */

#ifdef  MAXHOSTNAMELEN_BROKEN
#include <netdb.h>
#else
#include <sys/param.h>
#endif

#ifndef __GNUC__
#define __FUNCTION__      ""
#endif 

#ifdef  OFF_T_LONG_LONG
#define OFF_T_S "%llu"
#else
#define OFF_T_S "%lu"
#endif

/* exported functions */

int        bind_try_range(struct sockaddr_in *, int, int, int);
off_t              filesz(int);
void   get_and_verify_ack(int sock, char *caller);
int    get_local_hostname(char *, size_t); 
const char *   h_strerror(void);
void        init_sockaddr(struct sockaddr_in *, const char *, u_short);
ssize_t     read_fd_to_fd(int, int);
char *           strlower(char *);
void          toggle_euid(void);
int                writen(int, const char *, int);

/* inline functions */

inline void * rlpr_malloc(size_t sz);
inline void * rlpr_strdup(char * orig);

/* handy macros */

#define check_ptr(x) \
 do { \
  if ((x) == NULL) rlpr_msg(FATAL, NO_ERRNO, \
                           "%s: ouch, out of memory!", __FUNCTION__); \
 } while(0)

#define safe_writen(fd, buf, buflen) \
 do { \
  if (writen((fd), (buf), (buflen)) < 0) \
    rlpr_msg(FATAL, ERRNO, "writen in %s", __FUNCTION__); \
 } while(0)

#ifndef HAVE_STRDUP
extern char * strdup(const char *s);
#endif

#ifndef HAVE_STRCSPN
extern size_t strcspn(const char *s, const char *reject);
#endif

#ifndef HAVE_STRSTR
extern char * strstr(const char *haystack, const char *needle);
#endif

#ifndef HAVE_VSNPRINTF
#include <stdarg.h>
int vsnprintf(char *str, size_t n, const char *format, va_list ap);
#endif

#endif /* RLPR_UTIL_H */
