/* ncftp.h */

#ifndef _ncftp_h_
#define _ncftp_h_ 1

#define kLibraryVersion "@(#) LibNcFTP 2.5.1 (June 24, 1998)"

#include <stdio.h>
#include <sys/time.h>
#if !defined(__ultrix) || !defined(XTI)
#include <sys/socket.h>
#endif
#include <netinet/in.h>

#include "ncftp_errno.h"

/* This is used to verify validty of the data passed in.
 * It also specifies the minimum version that is binary-compatibile with
 * this version.  (So this may not necessarily be kLibraryVersion.)
 */
#define kLibraryMagic "LibNcFTP 2.5.1"

#ifndef longest_int
#define longest_int long long
#define longest_uint unsigned long long
#endif

typedef void (*FTPSigProc)(int);

typedef struct Line *LinePtr;
typedef struct Line {
	LinePtr prev, next;
	char *line;
} Line;

typedef struct LineList {
	LinePtr first, last;
	int nLines;
} LineList, *LineListPtr;

typedef struct Response {
	LineList msg;
	int codeType;
	int code;
	int printMode;
	int eofOkay;
	int hadEof;
} Response, *ResponsePtr;

typedef struct FTPLibraryInfo {
	char magic[16];				/* Don't modify this field. */
	int init;				/* Don't modify this field. */
	int socksInit;				/* Don't modify this field. */
	unsigned int defaultPort;		/* Don't modify this field. */
	char ourHostName[64];			/* Don't modify this field. */
	int hresult;				/* Don't modify this field. */
	int htried;				/* Don't modify this field. */
	char defaultAnonPassword[80];		/* You may set this after init. */
} FTPLibraryInfo, *FTPLIPtr;

typedef struct FTPConnectionInfo *FTPCIPtr;
typedef void (*FTPProgressMeterProc)(const FTPCIPtr, int);
typedef void (*FTPLogProc)(const FTPCIPtr, char *);
typedef void (*FTPConnectMessageProc)(const FTPCIPtr, ResponsePtr);
typedef void (*FTPRedialStatusProc)(const FTPCIPtr, int, int);
typedef void (*FTPPrintResponseProc)(const FTPCIPtr, ResponsePtr);

typedef struct FTPConnectionInfo {
	char magic[16];				/* Don't modify this field. */
	char host[64];				/* REQUIRED input parameter. */
	char user[32];				/* OPTIONAL input parameter. */
	char pass[64];				/* OPTIONAL input parameter. */
	char acct[32];				/* OPTIONAL input parameter. */
	unsigned int port;			/* OPTIONAL input parameter. */
	int xferTimeout;			/* OPTIONAL input parameter. */
	int connTimeout;			/* OPTIONAL input parameter. */
	int ctrlTimeout;			/* OPTIONAL input parameter. */
	int abortTimeout;			/* OPTIONAL input parameter. */
	FILE *debugLog;				/* OPTIONAL input parameter. */
	FILE *errLog;				/* OPTIONAL input parameter. */
	FTPLogProc debugLogProc;		/* OPTIONAL input parameter. */
	FTPLogProc errLogProc;			/* OPTIONAL input parameter. */
	FTPLIPtr lip;				/* Do not modify this field. */
	int maxDials;				/* OPTIONAL input parameter. */
	int redialDelay;			/* OPTIONAL input parameter. */
	int dataPortMode;			/* OPTIONAL input parameter. */
	char actualHost[64];			/* Do not modify this field. */
	char ip[32];				/* Do not modify this field. */
	int connected;				/* Do not modify this field. */
	int loggedIn;				/* Do not modify this field. */
	int curTransferType;			/* Do not modify this field. */
	longest_int startPoint;			/* Do not modify this field. */
	int hasPASV;				/* Do not modify this field. */
	int hasSIZE;				/* Do not modify this field. */
	int hasMDTM;				/* Do not modify this field. */
	int hasNLST_d;				/* Do not modify this field. */
	int hasUTIME;				/* Do not modify this field. */
	struct sockaddr_in servCtlAddr;		/* Do not modify this field. */
	struct sockaddr_in servDataAddr;	/* Do not modify this field. */
	struct sockaddr_in ourCtlAddr;		/* Do not modify this field. */
	struct sockaddr_in ourDataAddr;		/* Do not modify this field. */
	int netMode;				/* Do not use or modify. */
	char *buf;				/* Do not modify this field. */
	size_t bufSize;				/* Do not modify this field. */
	FILE *cin;				/* Do not use or modify. */
	FILE *cout;				/* Do not use or modify. */
	int ctrlSocketR;			/* You may use but not modify/close. */
	int ctrlSocketW;			/* You may use but not modify/close. */
	int dataSocket;				/* You may use but not modify/close. */
	int errNo;				/* You may modify this if you want. */
	unsigned short ephemLo;			/* You may modify this if you want. */
	unsigned short ephemHi;			/* You may modify this if you want. */
	int cancelXfer;				/* You may modify this. */
	longest_int bytesTransferred;		/* Do not modify this field. */
	FTPProgressMeterProc progress;		/* You may modify this if you want. */
	int useProgressMeter;			/* Used internally. */
	int leavePass;				/* You may modify this. */
	double sec;				/* Do not modify this field. */
	double secLeft;				/* Do not modify this field. */
	double kBytesPerSec;			/* Do not modify this field. */
	double percentCompleted;		/* Do not modify this field. */
	longest_int expectedSize;		/* Do not modify this field. */
	time_t mdtm;				/* Do not modify this field. */
	time_t nextProgressUpdate;		/* Do not modify this field. */
	const char *rname;			/* Do not modify this field. */
	const char *lname;			/* Do not modify this field. */
	struct timeval t0;			/* Do not modify this field. */
	int stalled;				/* Do not modify this field. */
	int eofOkay;				/* Do not use or modify. */
	char lastFTPCmdResultStr[128];		/* You may modify this if you want. */
	LineList lastFTPCmdResultLL;		/* Use, but do not modify. */
	int lastFTPCmdResultNum;		/* You may modify this if you want. */
	char firewallHost[64];			/* You may modify this. */
	char firewallUser[64];			/* You may modify this. */
	char firewallPass[64];			/* You may modify this. */
	unsigned int firewallPort;		/* You may modify this. */
	int firewallType;			/* You may modify this. */
	int require20;				/* You may modify this. */
	FTPConnectMessageProc onConnectMsgProc; /* You may modify this. */
	FTPRedialStatusProc redialStatusProc;	/* You may modify this. */
	FTPPrintResponseProc printResponseProc; /* You may modify this. */
	int reserved[32];			/* Do not use or modify. */
} FTPConnectionInfo;

typedef struct FileInfo *FileInfoPtr, **FileInfoVec;
typedef struct FileInfo {
	FileInfoPtr prev, next;
	char *relname;
	char *rname;
	char *rlinkto;
	char *lname;
	char *plug;	/* permissions, links, user, group */
	int type;
	time_t mdtm;
	longest_int size;
	size_t relnameLen;
} FileInfo;

typedef struct FileInfoList {
	FileInfoPtr first, last;
	FileInfoVec vec;
	size_t maxFileLen;
	int nFileInfos;
	int sortKey;
	int sortOrder;
} FileInfoList, *FileInfoListPtr;

/* Messages we pass to the current progress meter function. */
#define kPrInitMsg			1
#define kPrUpdateMsg			2
#define kPrEndMsg			3

/* Parameter for OpenDataConnection() */
#define kSendPortMode			0
#define kPassiveMode			1
#define kFallBackToSendPortMode		2

/* Parameter for AcceptDataConnection() */
#define kAcceptForWriting		00100
#define kAcceptForReading		00101
#define kNetWriting			kAcceptForWriting
#define kNetReading			kAcceptForReading

#define kDefaultFTPPort			21

#define kDefaultFTPBufSize		4096

/* The library doesn't use timeouts by default because it would
 * break apps that don't have a SIGALRM handler.
 */
#define kDefaultXferTimeout		(-1)	/* No timeout. */
#define kDefaultConnTimeout		(-1)	/* No timeout. */
#define kDefaultCtrlTimeout		(-1)	/* No timeout. */
#define kDefaultAbortTimeout		10

/* Suggested timeout values, in seconds, if you use timeouts. */
#define kSuggestedDefaultXferTimeout	(-1)	/* No timeout on data blocks. */
#define kSuggestedDefaultConnTimeout	30
#define kSuggestedDefaultCtrlTimeout	135	/* 2*MSL, + slop */ 
#define kSuggestedAbortTimeout		10

#define kDefaultMaxDials		3
#define kDefaultRedialDelay		20	/* seconds */

#define kDefaultDataPortMode		kSendPortMode

#define kRedialStatusDialing		0
#define kRedialStatusSleeping		1

#ifndef INADDR_NONE
#	define INADDR_NONE		(0xffffffff)	/* <netinet/in.h> should have it. */
#endif

#define kTypeAscii			'A'
#define kTypeBinary			'I'
#define kTypeEbcdic			'E'

#define kGlobChars 			"[*?"
#define GLOBCHARSINSTR(a)		(strpbrk(a, kGlobChars) != NULL)

#define kGlobYes			1
#define kGlobNo				0
#define kRecursiveYes			1
#define kRecursiveNo			0
#define kAppendYes			1
#define kAppendNo			0
#define kResumeYes			1
#define kResumeNo			0
#define kDeleteYes			1
#define kDeleteNo			0
#define kTarYes				1
#define kTarNo				0

#define UNIMPLEMENTED_CMD(a)		((a == 500) || (a == 502) || (a == 504))

/* Possible values returned by GetDateAndTime. */
#define kSizeUnknown			((longest_int) (-1))
#define kModTimeUnknown			((time_t) (-1))

#define kCommandAvailabilityUnknown	(-1)
#define kCommandAvailable		1
#define kCommandNotAvailable		0

/* Values returned by FTPDecodeURL. */
#define kNotURL				(-1)
#define kMalformedURL			(-2)

/* Values for the firewall/proxy open. */
#define kFirewallNotInUse			0
#define kFirewallUserAtSite			1
#define kFirewallLoginThenUserAtSite		2
#define kFirewallSiteSite			3
#define kFirewallOpenSite			4
#define kFirewallUserAtUserPassAtPass		5
#define kFirewallFwuAtSiteFwpUserPass		6
#define kFirewallLastType			kFirewallFwuAtSiteFwpUserPass		
#ifndef _ftp_c_
extern char gLibNcFTPVersion[64];
#endif

#ifdef __cplusplus
extern "C"
{
#endif	/* __cplusplus */

/* Public routines */
void FTPAbortDataTransfer(const FTPCIPtr);
int FTPChdir(const FTPCIPtr, const char *);
int FTPChdirAndGetCWD(const FTPCIPtr, const char *, char *, size_t);
int FTPChmod(const FTPCIPtr, const char *, const char *, int);
int FTPCloseHost(const FTPCIPtr);
int FTPCmd(const FTPCIPtr, const char *,...);
int FTPDecodeURL(const FTPCIPtr, char *, LineListPtr, char *, size_t, int *, int *);
int FTPDelete(const FTPCIPtr, const char *, int, int);
int FTPFileModificationTime(const FTPCIPtr, const char *, time_t *);
int FTPFileSize(const FTPCIPtr, const char *, longest_int *, int);
int FTPGetCWD(const FTPCIPtr, char *, size_t);
int FTPGetFiles3(const FTPCIPtr, const char *, const char *, int, int, int, int, int, int, int);
int FTPGetOneFile3(const FTPCIPtr, const char *, const char *, int, int, int, int, int, int);
void FTPInitializeOurHostName(const FTPLIPtr);
void FTPInitializeAnonPassword(const FTPLIPtr);
int FTPInitConnectionInfo(const FTPLIPtr, const FTPCIPtr, size_t);
int FTPInitLibrary(const FTPLIPtr);
int FTPIsDir(const FTPCIPtr, const char *const);
int FTPList(const FTPCIPtr, int, int, const char *);
int FTPListToMemory(const FTPCIPtr, const char *, LineListPtr, const char *);
int FTPLocalGlob(FTPCIPtr, LineListPtr, const char *, int);
int FTPLoginHost(const FTPCIPtr);
int FTPMkdir(const FTPCIPtr, const char *, int);
int FTPOpenHost(const FTPCIPtr);
int FTPOpenHostNoLogin(const FTPCIPtr);
void FTPPerror(const FTPCIPtr, int, int, const char *const, const char *const);
int FTPPutFiles3(const FTPCIPtr, const char *, const char *, int, int, int, int, const char *, const char *, int, int, int);
int FTPPutOneFile3(const FTPCIPtr, const char *, const char *, int, int, int, const char *, const char *, int, int, int);
int FTPRemoteGlob(FTPCIPtr, LineListPtr, const char *, int);
int FTPRename(const FTPCIPtr, const char *, const char *);
int FTPRmdir(const FTPCIPtr, const char *, int, int);
void FTPShutdownHost(const FTPCIPtr);
const char *FTPStrError(int);
int FTPSymlink(const FTPCIPtr cip, const char *const, const char *const);
int FTPUmask(const FTPCIPtr, const char *);
int FTPUtime(const FTPCIPtr, const char *, time_t, time_t, time_t);

/* LineList routines */
int CopyLineList(LineListPtr, LineListPtr);
void DisposeLineListContents(LineListPtr);
void InitLineList(LineListPtr);
LinePtr RemoveLine(LineListPtr, LinePtr);
LinePtr AddLine(LineListPtr, const char *);

/* Other routines that might be useful. */
char *StrDup(const char *);
char *FGets(char *, size_t, FILE *);
void GetHomeDir(char *, size_t);
void GetUserName(char *, size_t);
void Scramble(unsigned char *dst, size_t dsize, unsigned char *src, char *key);
time_t UnMDTMDate(char *);
int MkDirs(const char *const);

#ifdef HAVE_SIGACTION
void (*NcSignal(int signum, void (*handler)(int)))(int);
#elif !defined(NcSignal)
#	define NcSignal signal
#endif

/* Obselete routines. */
int FTPGetFiles(const FTPCIPtr, const char *, const char *, int, int);
int FTPGetFiles2(const FTPCIPtr, const char *, const char *, int, int, int, int, int);
int FTPGetFilesAscii(const FTPCIPtr, const char *, const char *, int, int);
int FTPGetOneFile(const FTPCIPtr, const char *, const char *);
int FTPGetOneFile2(const FTPCIPtr, const char *, const char *, int, int, int, int);
int FTPGetOneFileAscii(const FTPCIPtr, const char *, const char *);
int FTPPutFiles(const FTPCIPtr, const char *, const char *, int, int);
int FTPPutFiles2(const FTPCIPtr, const char *, const char *, int, int, int, int, const char *, const char *);
int FTPPutFilesAscii(const FTPCIPtr, const char *, const char *, int, int);
int FTPPutOneFile2(const FTPCIPtr, const char *, const char *, int, int, int, const char *, const char *);
int FTPPutOneFile(const FTPCIPtr, const char *, const char *);
int FTPPutOneFileAscii(const FTPCIPtr, const char *, const char *);

/* Private routines, or stuff for testing */
int FTPListToMemory2(const FTPCIPtr, const char *, LineListPtr, const char *, int);
void FTPInitIOTimer(const FTPCIPtr);
int FTPStartDataCmd(const FTPCIPtr, int, int, longest_int, const char *,...);
void FTPStartIOTimer(const FTPCIPtr);
void FTPStopIOTimer(const FTPCIPtr);
void FTPUpdateIOTimer(const FTPCIPtr);
int FTPSetTransferType(const FTPCIPtr, int);
int FTPEndDataCmd(const FTPCIPtr, int);
int FTPRemoteHelp(const FTPCIPtr, const char *, LineListPtr);
int FTPCmdNoResponse(const FTPCIPtr, const char *,...);
int WaitResponse(const FTPCIPtr, unsigned int);
int FTPLocalRecursiveFileList(FTPCIPtr, LineListPtr, FileInfoListPtr);
int FTPRemoteRecursiveFileList(FTPCIPtr, LineListPtr, FileInfoListPtr);
int FTPRemoteRecursiveFileList1(FTPCIPtr, char *const, FileInfoListPtr);
int BufferGets(char *, size_t, int, char *, char **, char **, size_t);
void DisposeFileInfoListContents(FileInfoListPtr);
void InitFileInfoList(FileInfoListPtr);
void InitFileInfo(FileInfoPtr);
FileInfoPtr RemoveFileInfo(FileInfoListPtr, FileInfoPtr);
FileInfoPtr AddFileInfo(FileInfoListPtr, FileInfoPtr);
void SortFileInfoList(FileInfoListPtr, int, int);
void VectorizeFileInfoList(FileInfoListPtr);
void UnvectorizeFileInfoList(FileInfoListPtr);
int ComputeRNames(FileInfoListPtr, const char *, int, int);
int ComputeLNames(FileInfoListPtr, const char *, const char *, int);
int ConcatFileInfoList(FileInfoListPtr, FileInfoListPtr);
int ConcatFileToFileInfoList(FileInfoListPtr, char *);
int LineListToFileInfoList(LineListPtr, FileInfoListPtr);
int LineToFileInfoList(LinePtr, FileInfoListPtr);
void URLCopyToken(char *, size_t, const char *, size_t);
int UnLslR(FileInfoListPtr, LineListPtr);
void TraceResponse(const FTPCIPtr, ResponsePtr);
void PrintResponse(const FTPCIPtr, LineListPtr);
void DoneWithResponse(const FTPCIPtr, ResponsePtr);
ResponsePtr InitResponse(void);
void ReInitResponse(const FTPCIPtr, ResponsePtr);
int GetTelnetString(const FTPCIPtr, char *, size_t, FILE *, FILE *);
int GetResponse(const FTPCIPtr, ResponsePtr);
int RCmd(const FTPCIPtr, ResponsePtr, const char *, ...);

#ifdef __cplusplus
}
#endif	/* __cplusplus */

#endif /* _ncftp_h_ */
