/*
 * IRC - Internet Relay Chat, include/h.h
 * Copyright (C) 1996 - 1997 Carlo Wood
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef NUMNICKS_H
#define NUMNICKS_H

/*=============================================================================
 * General defines
 */

/* These must be the same on ALL servers ! Do not change ! */

#define NUMNICKLOG 6
#define NUMNICKMAXCHAR 'z'	/* See convert2n[] */
#define NUMNICKBASE 64		/* (2 << NUMNICKLOG) */
#define NUMNICKMASK 63		/* (NUMNICKBASE-1) */
#define MAX_MAXCLIENTS 4096	/* (NUMNICKBASE * NUMNICKBASE) */

#define NUMNICKLEN 3		/* strlen("YXX") */

/*=============================================================================
 * Macro's
 */

/* Use this macro as follows: sprintf(buf, "%c%c%c ...", NumNick(cptr), ...); */
#define NumNick(cptr) *(cptr)->user->server->yxx, (cptr)->yxx[0], (cptr)->yxx[1]
/* Use this macro as follows: sprintf(buf, "%c ...", NumServ(cptr), ...); */
#define NumServ(cptr) *(cptr)->yxx

#define FindNServer(y) (server_list[convert2n[(unsigned char)(y)]])

/*
 * Index()
 *
 * Returns the index in the [remote] server array client_list of `cptr'.
 */
#define Index(cptr, on_server) \
    (((convert2n[(unsigned char)(cptr)->yxx[0]] << NUMNICKLOG) + \
    convert2n[(unsigned char)(cptr)->yxx[1]]) & (on_server)->serv->nn_mask)

/*=============================================================================
 * Structures
 */

/*=============================================================================
 * Proto types
 */

extern void SetRemoteNumNick(aClient *cptr, const char *yxx);
extern void SetLocalNumNick(aClient *cptr);
extern aClient *find_user_on(const aClient *server, u_char x1, u_char x2);
extern void SetServerYXX(aClient *cptr, aClient *server, char *yxx);
extern void ClearServerYXX(aClient *server);
extern aClient *FindNClient(const char *yxx);

#ifndef NO_PROTOCOL9
extern char *CreateNNforProtocol9server(aClient *server);
#endif

extern char convert2y[NUMNICKBASE];
extern unsigned char convert2n[NUMNICKMAXCHAR + 1];
extern aClient *server_list[NUMNICKBASE];

#endif /* NUMNICKS_H */
