#include <gtk/gtk.h>
#include <libpq-fe.h>
#include <string.h>
#include <postgres.h>

#include "common.h"
#include "dialogs.h"

#define TABLE_NAME_KEY "Table Name"

GtkWidget *name_list;
GtkWidget *info_clist;
int tables_in_list = 0;

void NewConnection() {
  int i;
  PGresult *tables;
  char query[512];

  sprintf(query, "SELECT usename, relname, relkind, relhasrules
                  FROM pg_class, pg_user
                  WHERE relkind = 'r' AND
                        relname !~ '^pg_' AND
                        relname !~ '^xin[vx][0-9]+' AND
                        usesysid = relowner
                  ORDER BY relname");
  
  tables = PQexec(conn, query);
  if ((tables == NULL) || (PQresultStatus(tables) != PGRES_TUPLES_OK)) {
    GtkWidget *dialog;
    char buf[256];

    sprintf(buf, " Error retrieving table list \n %s ",
	    PQerrorMessage(conn));
    
    dialog = CreateStandardDialog("Error retrieving table list",
				  buf,
				  0, NULL,
				  "Ok", NULL,
				  NULL, NULL,
				  NULL);
    gtk_widget_show(dialog);
  } else {
    tables_in_list = PQntuples(tables);
  
    for (i = 0; i < tables_in_list; i++) {
      GtkWidget *list_item;
      
      list_item = gtk_list_item_new_with_label(PQgetvalue(tables, i, 1));
      gtk_object_set_data(GTK_OBJECT(list_item),
			  TABLE_NAME_KEY,
			  g_strdup(PQgetvalue(tables, i, 1)));
      gtk_container_add(GTK_CONTAINER(name_list), list_item);
      gtk_widget_show(list_item);
    }
  }
  if (tables != NULL)
    PQclear(tables);
}

void ConnectionClosed() {
  GList *list;

  /* We must clean all the g_strdup... */
  list = GTK_LIST(name_list)->children;
  while (list != NULL) {
    GtkWidget *list_item;

    list_item = list->data;
    g_free(gtk_object_get_data(GTK_OBJECT(list_item), TABLE_NAME_KEY));
    
    list = list->next;
  }
  gtk_list_clear_items(GTK_LIST(name_list), 0, tables_in_list);

  /* Now, we empty the clist */
  gtk_clist_clear(GTK_CLIST(info_clist));
}

static void name_selection_callback(GtkWidget *widget, gpointer data) {
  GList *selected_list;
         
  /* Gets the selection from the widget */
  selected_list = GTK_LIST(widget)->selection;
  gtk_clist_clear(GTK_CLIST(info_clist));
  
  if (selected_list == NULL) {
    /* No selection... */
    /* Happens ONLY when no connection active */
  } else {
    /* We are in browse mode -> only ONE selection possible */
    GtkObject *list_item;
    char *table_name;
    PGresult *table_info;
    char query[512];

    /* We get the table name */
    list_item = GTK_OBJECT(selected_list->data);
    table_name = (char *) gtk_object_get_data(GTK_OBJECT(list_item),
					      TABLE_NAME_KEY);

    /* We display the table information */
    sprintf(query, "SELECT a.attnum, a.attname, t.typname, a.attlen,
                           a.atttypmod, a.attnotnull, a.atthasdef
                    FROM pg_class c, pg_attribute a, pg_type t
                    WHERE c.relname = '%s' AND
                          a.attnum > 0 AND
                          a.attrelid = c.oid AND
                          a.atttypid = t.oid
                    ORDER BY attnum", table_name);
  
    table_info = PQexec(conn, query);
    if ((table_info == NULL) ||
	(PQresultStatus(table_info) != PGRES_TUPLES_OK)) {
      GtkWidget *dialog;
      char buf[256];

      sprintf(buf, " Error retrieving information for table %s \n %s ",
	      table_name,
	      PQerrorMessage(conn));
    
      dialog = CreateStandardDialog("Error retrieving table information",
				    buf,
				    0, NULL,
				    "Ok", NULL,
				    NULL, NULL,
				    NULL);
      gtk_widget_show(dialog);
    } else {
      int i;
      
      for (i = 0; i < PQntuples(table_info); i++) {
	char *line[3];
	char type_str[64];
	char *rtype, *rnotnull, *rhasdef;
	int attlen, atttypmod;
	char buf[512];
	PGresult *table_info2;

	line[0] = PQgetvalue(table_info, i, 1);
	
	rtype = PQgetvalue(table_info, i, 2);
	attlen = atoi(PQgetvalue(table_info, i, 3));
	atttypmod = atoi(PQgetvalue(table_info, i, 4));
	rnotnull = PQgetvalue(table_info, i, 5);
	rhasdef = PQgetvalue(table_info, i, 6);
	
	strcpy(type_str, rtype);
	if (strcmp(rtype, "bpchar") == 0)
	  strcpy(type_str, "char()");
	else if (strcmp(rtype, "varchar") == 0)
	  strcpy(type_str, "varchar()");
	else if (rtype[0] == '_') {
	  strcpy(type_str, rtype + 1);
	  strcat(type_str, "[]");
	}
	
	if (rnotnull[0] == 't')
	  strcat(type_str, " not null");
	if (rhasdef[0] == 't') {
	  sprintf(buf, "SELECT d.adsrc
                        FROM pg_attrdef d, pg_class c
                        WHERE c.relname = '%s' AND
                              c.oid = d.adrelid AND
                              d.adnum = %s",
		  table_name, PQgetvalue(table_info, i, 0));
	  table_info2 = PQexec(conn, buf);
	  if ((table_info2 == NULL) ||
	      (PQresultStatus(table_info2) != PGRES_TUPLES_OK)) {
	    GtkWidget *dialog;
	    
	    sprintf(buf, " Error retrieving information for table %s \n %s ",
		    table_name,
		    PQerrorMessage(conn));
	    
	    dialog = CreateStandardDialog("Error retrieving table information",
					  buf,
					  0, NULL,
					  "Ok", NULL,
					  NULL, NULL,
					  NULL);
	    gtk_widget_show(dialog);
	    
	    gtk_clist_clear(GTK_CLIST(info_clist));
	    return;
	  }
	  strcat(type_str, " default ");
	  strcat(type_str, PQgetvalue(table_info2, 0, 0));
	  PQclear(table_info2);
	}
	line[1] = type_str;
	
	if (strcmp(rtype, "text") == 0)
	  sprintf(buf, "var");
	else if (strcmp(rtype, "bpchar") == 0 ||
		 strcmp(rtype, "varchar") == 0) {
	  sprintf(buf, "%i", atttypmod != -1 ? atttypmod - VARHDRSZ : 0);
	} else {
	  if (attlen > 0)
	    sprintf(buf, "%i", attlen);
	  else
	    sprintf(buf, "var");
	}
	line[2] = buf;

	gtk_clist_append(GTK_CLIST(info_clist), line);
      }
    }
    if (table_info != NULL)
      PQclear(table_info);
  }
}


GtkWidget *InitTablesPane() {
  GtkWidget *notebook, *name_scroll;
  char *col_titles[] = {
    "Field", "Type", "Length"
  };
  
  notebook = gtk_notebook_new();
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_TOP);
  
  /* Table name list */
  name_scroll = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(name_scroll),
				 GTK_POLICY_AUTOMATIC, 
				 GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize(name_scroll, 130, 300);
  gtk_paned_add1(GTK_PANED(pane), name_scroll);
  gtk_widget_show (name_scroll);
  
  name_list = gtk_list_new();
  gtk_list_set_selection_mode(GTK_LIST(name_list), GTK_SELECTION_BROWSE);
  gtk_container_add(GTK_CONTAINER(name_scroll), name_list);
  gtk_signal_connect(GTK_OBJECT(name_list),
		     "selection_changed",
		     GTK_SIGNAL_FUNC(name_selection_callback),
		     NULL);
  gtk_widget_show(name_list);

  /* Table definition */
  info_clist = gtk_clist_new_with_titles(3, col_titles);
  gtk_clist_set_policy(GTK_CLIST(info_clist), 
		       GTK_POLICY_AUTOMATIC,
		       GTK_POLICY_AUTOMATIC);
  gtk_clist_set_column_width(GTK_CLIST(info_clist), 0, 130);
  gtk_clist_set_column_width(GTK_CLIST(info_clist), 1, 130);
  gtk_paned_add2(GTK_PANED(pane), info_clist);
  gtk_widget_show(info_clist);
  
  gtk_widget_show(notebook);
  
  return notebook;
}
