/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

#include "myheader.h"
#include <string.h>


/**************************************************************************/
void create_help_window()
{
	GtkWidget *vbox, *vbox2, *hbox, *hsep, *ok_button, *table, *vscrollbar;
	extern GtkWidget *help_window, *help_text;
	

	if (help_window)
		gtk_widget_destroy(help_window);
		
	help_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (help_window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &help_window);
	gtk_window_position(GTK_WINDOW (help_window), GTK_WIN_POS_CENTER);
	gtk_window_set_title (GTK_WINDOW (help_window), "Help");
	gtk_container_border_width (GTK_CONTAINER (help_window), 0);
	gtk_widget_set_usize(GTK_WIDGET (help_window), 600, 0);
	
	vbox = gtk_vbox_new (FALSE, 10);
      	gtk_container_border_width (GTK_CONTAINER (vbox), 0);
      	gtk_container_add (GTK_CONTAINER (help_window), vbox);
      	gtk_widget_show (vbox);
      	
      	vbox2 = gtk_vbox_new (FALSE, 0);
      	gtk_container_border_width (GTK_CONTAINER (vbox2), 10);
      	gtk_box_pack_start (GTK_BOX (vbox), vbox2, TRUE, TRUE, 0);
      	gtk_widget_show (vbox2);
      	
      	table = gtk_table_new (2, 2, FALSE);
      	gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
      	gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
      	gtk_box_pack_start (GTK_BOX (vbox2), table, TRUE, TRUE, 0);
      	gtk_widget_show (table);
      	
      	help_text = gtk_text_new (NULL, NULL);
      	gtk_text_set_editable (GTK_TEXT (help_text), FALSE);
      	gtk_table_attach (GTK_TABLE (table), help_text, 0, 1, 0, 1,
			GTK_EXPAND | GTK_SHRINK | GTK_FILL,
			GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
      	gtk_widget_show (help_text);
      	
      	vscrollbar = gtk_vscrollbar_new (GTK_TEXT (help_text)->vadj);
      	gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
			GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
      	gtk_widget_show (vscrollbar);
      	
      	hsep = gtk_hseparator_new();
	gtk_box_pack_start (GTK_BOX (vbox), hsep, FALSE, TRUE, 0);
        gtk_widget_show(hsep);

      	hbox = gtk_hbutton_box_new ();
      	gtk_container_border_width (GTK_CONTAINER (hbox), 10);
      	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
      	gtk_hbutton_box_set_spacing_default(10);
      	gtk_hbutton_box_set_layout_default(GTK_BUTTONBOX_END);
      	gtk_widget_show (hbox);
      	
      	ok_button = gtk_button_new_with_label("OK");
      	gtk_box_pack_end (GTK_BOX (hbox), ok_button, FALSE, TRUE, 0);
      	gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(help_window));
	gtk_widget_show (ok_button);
	GTK_WIDGET_SET_FLAGS(ok_button, GTK_CAN_DEFAULT);
      	gtk_widget_grab_default(ok_button);
	
	gtk_widget_realize (help_text);
	gtk_widget_show(help_window);
}
/*********************************************************************************/
void help_index()
{
	extern GtkWidget *help_text;
	extern char *text1, *text2, *text3, *text4, *text5;
	
	create_help_window();
	gtk_text_insert(GTK_TEXT(help_text), NULL, NULL, NULL, text1, -1);
	gtk_text_insert(GTK_TEXT(help_text), NULL, NULL, NULL, text2, -1);
	gtk_text_insert(GTK_TEXT(help_text), NULL, NULL, NULL, text3, -1);
	gtk_text_insert(GTK_TEXT(help_text), NULL, NULL, NULL, text4, -1);
	gtk_text_insert(GTK_TEXT(help_text), NULL, NULL, NULL, text5, -1);
}
/***********************************************************************************/
void help_workwith_groups_window()
{
	
	extern GtkWidget *help_text;
	extern char *text2;
	
	create_help_window();
	gtk_text_insert(GTK_TEXT(help_text), NULL, NULL, NULL, text2, -1);
}
/***********************************************************************************/
void help_workwith_charts_window()
{
	extern GtkWidget *help_text;
	extern char *text2;
	
	create_help_window();
	gtk_text_insert(GTK_TEXT(help_text), NULL, NULL, NULL, text2, -1);
}
/***********************************************************************************/
void help_goto_chart_window()
{
	extern GtkWidget *help_text;
	extern char *text4;
	
	create_help_window();
	gtk_text_insert(GTK_TEXT(help_text), NULL, NULL, NULL, text4, -1);
}
/***********************************************************************************/
void help_edit_indicator_window()
{
	extern GtkWidget *help_text;
	extern char *text3;
	
	create_help_window();
	gtk_text_insert(GTK_TEXT(help_text), NULL, NULL, NULL, text3, -1);
}
/***********************************************************************************/
void help_alert_scan_window()
{
	extern GtkWidget *help_text;
	extern char *text5;
	
	create_help_window();
	gtk_text_insert(GTK_TEXT(help_text), NULL, NULL, NULL, text5, -1);
}
/***********************************************************************************/
void help_alert_view_window()
{
	extern GtkWidget *help_text;
	extern char *text5;
	
	create_help_window();
	gtk_text_insert(GTK_TEXT(help_text), NULL, NULL, NULL, text5, -1);
}
/***********************************************************************************/
void help_new_group_window()
{
	extern GtkWidget *help_text;
	extern char *text2;
	
	create_help_window();
	gtk_text_insert(GTK_TEXT(help_text), NULL, NULL, NULL, text2, -1);
}
/***********************************************************************************/
void help_import_options_window()
{
	extern GtkWidget *help_text;
	extern char *text2;
	
	create_help_window();
	gtk_text_insert(GTK_TEXT(help_text), NULL, NULL, NULL, text2, -1);
}
/***********************************************************************************/
void help_export_options_window()
{
	extern GtkWidget *help_text;
	extern char *text2;
	
	create_help_window();
	gtk_text_insert(GTK_TEXT(help_text), NULL, NULL, NULL, text2, -1);
}
/***********************************************************************************/
void help_edit_options_window()
{
	extern GtkWidget *help_text;
	extern char *text3;
	
	create_help_window();
	gtk_text_insert(GTK_TEXT(help_text), NULL, NULL, NULL, text3, -1);
}
/***********************************************************************************/
void help_edit_group_window()
{
	extern GtkWidget *help_text;
	extern char *text2;
	
	create_help_window();
	gtk_text_insert(GTK_TEXT(help_text), NULL, NULL, NULL, text2, -1);
}
/***********************************************************************************/
void help_rename_group_window()
{
	extern GtkWidget *help_text;
	extern char *text2;
	
	create_help_window();
	gtk_text_insert(GTK_TEXT(help_text), NULL, NULL, NULL, text2, -1);
}
/***********************************************************************************/
void help_edit_chart_window()
{
	extern GtkWidget *help_text;
	extern char *text2;
	
	create_help_window();
	gtk_text_insert(GTK_TEXT(help_text), NULL, NULL, NULL, text2, -1);
}
/***********************************************************************************/
void help_update_quotes_window()
{
	extern GtkWidget *help_text;
	extern char *text5;
	
	create_help_window();
	gtk_text_insert(GTK_TEXT(help_text), NULL, NULL, NULL, text5, -1);
}