/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

#include "myheader.h"
#include "myerrors.h"
#include <ctype.h>
#include <string.h>


/************************************************************************************/
void yesno_global_indicators()
{
	char tstring[250];
    	extern GtkWidget *yesno_window, *yesno_yes_button, *yesno_no_button;
    	extern struct record3 config;
    	
	
	if (config.global_indicators)
		strcpy(tstring, "Turn off global indicators?");
	else
		strcpy(tstring, "Turn on global indicators?");
	show_yesno_window(tstring);
   	gtk_signal_connect (GTK_OBJECT (yesno_yes_button), "clicked",
			    GTK_SIGNAL_FUNC (toggle_global_indicators), NULL);
      	gtk_signal_connect_object (GTK_OBJECT (yesno_no_button), "clicked",
			    	   GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    	   GTK_OBJECT(yesno_window));
}
/*************************************************************************************/
void toggle_global_indicators()
{
	extern GtkWidget *yesno_window;
    	extern struct record3 config;
    	extern int data_window_flag;
    	
    	
    	if (config.global_indicators)
    		config.global_indicators = 0;
    	else
    		config.global_indicators = 1;
	update_indicator_clist();
	show_indicators();
	draw();
	if (data_window_flag)
		update_data_window();
	if (yesno_window)
		gtk_widget_destroy(yesno_window);
}
/*************************************************************************************/
void update_indicator2()
{
	char tstring[25];
	int tint, tint2;
    	GList *list;
	char *text, *text2;
	extern GtkWidget *edit_indicator2_window, *edit_indicator2_entry, *edit_indicator_clist;
	extern GtkWidget *indicator_type_combo;
	extern struct record2 header;
	extern char *error_message;
	extern struct record3 config;
		
	
	text = gtk_entry_get_text(GTK_ENTRY(edit_indicator2_entry));
	text2 = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(indicator_type_combo)->entry));
	strcpy(tstring, text);
	tint = strlen(tstring);
	for (tint2 = 0; tint2 < tint; tint2++)
	{
		if (! isdigit(tstring[tint2]))
			RETURN_ERR(gs_invalid_moving);
	}
	list = GTK_CLIST (edit_indicator_clist)->selection;
	tint = (int) list->data;
	if (tint == 0)
	{
		if (config.global_indicators)
		{
			config.global_moving_length = atoi(text);
			if (! strcmp(text2, "Simple"))
				config.global_moving_type = 1;
			if (! strcmp(text2, "Exponential"))
				config.global_moving_type = 3;
			if (! strcmp(text2, "Weighted"))
				config.global_moving_type = 2;
		}
		else
		{
			header.moving[2] = atoi(text);
			if (! strcmp(text2, "Simple"))
				header.moving[1] = 1;
			if (! strcmp(text2, "Exponential"))
				header.moving[1] = 3;
			if (! strcmp(text2, "Weighted"))
				header.moving[1] = 2;
		}
	}
	if (tint == 1)
	{
		if (config.global_indicators)
		{
			config.global_moving2_length = atoi(text);
			if (! strcmp(text2, "Simple"))
				config.global_moving2_type = 1;
			if (! strcmp(text2, "Exponential"))
				config.global_moving2_type = 3;
			if (! strcmp(text2, "Weighted"))
				config.global_moving2_type = 2;
		}
		else
		{
			header.moving2[2] = atoi(text);
			if (! strcmp(text2, "Simple"))
				header.moving2[1] = 1;
			if (! strcmp(text2, "Exponential"))
				header.moving2[1] = 3;
			if (! strcmp(text2, "Weighted"))
				header.moving2[1] = 2;
		}
	}
	if (tint == 2)
	{
		if (config.global_indicators)
		{
			config.global_moving3_length = atoi(text);
			if (! strcmp(text2, "Simple"))
				config.global_moving3_type = 1;
			if (! strcmp(text2, "Exponential"))
				config.global_moving3_type = 3;
			if (! strcmp(text2, "Weighted"))
				config.global_moving3_type = 2;
		}
		else
		{
			header.moving3[2] = atoi(text);
			if (! strcmp(text2, "Simple"))
				header.moving3[1] = 1;
			if (! strcmp(text2, "Exponential"))
				header.moving3[1] = 3;
			if (! strcmp(text2, "Weighted"))
				header.moving3[1] = 2;
		}
	}
	update_indicator_clist();
	draw_price();
	gtk_widget_destroy(edit_indicator2_window);
}
/*************************************************************************************/
void show_indicators()
{
	extern GtkWidget *chart, *date, *volume, *scrolled_win;
	extern unsigned int records;
	extern struct record2 header;
	extern struct record3 config;

	
	gtk_widget_set_usize(GTK_WIDGET (chart), records * header.pixelspace, 0);
       	gtk_widget_set_usize(GTK_WIDGET (date), records * header.pixelspace, DATE_SIZE);
       	if (config.global_indicators)
       	{
       		if ((config.global_volume_status) || (config.volume))
       		{
       			gtk_widget_show(volume);
			gtk_widget_set_usize(GTK_WIDGET(volume),records * header.pixelspace,VOLUME_SIZE);
       		}
       		else
			gtk_widget_hide(volume);
       	}
       	else
       	{
		if ((header.volume) || (config.volume))
		{
			gtk_widget_show(volume);
			gtk_widget_set_usize(GTK_WIDGET(volume),records * header.pixelspace,VOLUME_SIZE);
		}
		else
			gtk_widget_hide(volume);
	}
	gtk_widget_set_usize(GTK_WIDGET(scrolled_win), 0, 0);
}
/***********************************************************************************/
void update_indicator_clist()
{
	int tint = 0, flag = 0, type=0, type2=0, type3=0, status=0, status2=0, status3=0;
	int status4=0, length=0, length2=0, length3=0;
    	GList *list;
	GdkPixmap *on = NULL, *off = NULL, *color = NULL;
	GdkBitmap *mask;
	GtkStyle *style;
	char tstring[250], tstring2[25], tstring3[15], tstring4[15], *line[4];
	extern struct record2 header;
	extern GtkWidget *edit_indicator_clist, *main_window, *edit_indicator_window;
	extern char global_string[GS_LENGTH];
	extern struct record3 config;
	extern struct record2 header;
	
	style = gtk_widget_get_style(edit_indicator_clist);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_on.xpm");
    	on = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					&style->bg[GTK_STATE_NORMAL], tstring);
	
	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_off.xpm");
    	off = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
	
	list = GTK_CLIST (edit_indicator_clist)->selection;
	if (list)
	{
		tint = (int) list->data;
		flag++;
	}
	gtk_clist_freeze (GTK_CLIST (edit_indicator_clist));
      	gtk_clist_clear(GTK_CLIST(edit_indicator_clist));
      	
      	if (config.global_indicators)
      	{
      		type = config.global_moving_type;
      		type2 = config.global_moving2_type;
      		type3 = config.global_moving3_type;
      		length = config.global_moving_length;
      		length2 = config.global_moving2_length;
      		length3 = config.global_moving3_length;
      		status = config.global_moving_status;
      		status2 = config.global_moving2_status;
      		status3 = config.global_moving3_status;
      		status4 = config.global_volume_status;
      	}
      	else
      	{
      		type = header.moving[1];
      		type2 = header.moving2[1];
      		type3 = header.moving3[1];
      		length = header.moving[2];
      		length2 = header.moving2[2];
      		length3 = header.moving3[2];
      		status = header.moving[0];
      		status2 = header.moving2[0];
      		status3 = header.moving3[0];
      		status4 = header.volume;
      	}
      	
      	line[0] = 0;
      	switch(type)
      	{
      		case 1: strcpy(tstring2, "MA 1 Simple");
      			break;
      		case 2: strcpy(tstring2, "MA 1 Weighted");
      			break;
      		case 3: strcpy(tstring2, "MA 1 Exponential");
      			break;
      		default: break;
      	}
      	line[1] = tstring2;
     	get_color2(config.moving_red, config.moving_green, config.moving_blue);
      	strcpy(tstring3, global_string);
      	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_");
      	strcat(tstring, tstring3);
      	strcat(tstring, ".xpm");
    	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
      	line[2] = 0;
      	sprintf(tstring4, "%d", length);
      	line[3] = tstring4;
      	gtk_clist_append (GTK_CLIST (edit_indicator_clist), line);
      	if (status)
      		gtk_clist_set_pixmap(GTK_CLIST(edit_indicator_clist), 0, 0, on, mask);
      	else
      		gtk_clist_set_pixmap(GTK_CLIST(edit_indicator_clist), 0, 0, off, mask);
      	gtk_clist_set_pixmap(GTK_CLIST(edit_indicator_clist), 0, 2, color, mask);
      		
      	
      	switch(type2)
      	{
      		case 1: strcpy(tstring2, "MA 2 Simple");
      			break;
      		case 2: strcpy(tstring2, "MA 2 Weighted");
      			break;
      		case 3: strcpy(tstring2, "MA 2 Exponential");
      			break;
      		default: break;
      	}
      	line[1] = tstring2;
      	get_color2(config.moving2_red, config.moving2_green, config.moving2_blue);
      	strcpy(tstring3, global_string);
      	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_");
      	strcat(tstring, tstring3);
      	strcat(tstring, ".xpm");
    	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
      	line[2] = 0;
      	sprintf(tstring4, "%d", length2);
      	line[3] = tstring4;
      	gtk_clist_append (GTK_CLIST (edit_indicator_clist), line);
      	if (status2)
      		gtk_clist_set_pixmap(GTK_CLIST(edit_indicator_clist), 1, 0, on, mask);
      	else
      		gtk_clist_set_pixmap(GTK_CLIST(edit_indicator_clist), 1, 0, off, mask);
      	gtk_clist_set_pixmap(GTK_CLIST(edit_indicator_clist), 1, 2, color, mask);
      		
      	
      	switch(type3)
      	{
      		case 1: strcpy(tstring2, "MA 3 Simple");
      			break;
      		case 2: strcpy(tstring2, "MA 3 Weighted");
      			break;
      		case 3: strcpy(tstring2, "MA 3 Exponential");
      			break;
      		default: break;
      	}
      	line[1] = tstring2;
      	get_color2(config.moving3_red, config.moving3_green, config.moving3_blue);
      	strcpy(tstring3, global_string);
      	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_");
      	strcat(tstring, tstring3);
      	strcat(tstring, ".xpm");
    	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
      	line[2] = 0;
      	sprintf(tstring4, "%d", length3);
      	line[3] = tstring4;
      	gtk_clist_append (GTK_CLIST (edit_indicator_clist), line);
      	if (status3)
      		gtk_clist_set_pixmap(GTK_CLIST(edit_indicator_clist), 2, 0, on, mask);
      	else
      		gtk_clist_set_pixmap(GTK_CLIST(edit_indicator_clist), 2, 0, off, mask);
      	gtk_clist_set_pixmap(GTK_CLIST(edit_indicator_clist), 2, 2, color, mask);
      	
      	
      	strcpy(tstring2, "Volume");
      	line[1] = tstring2;
      	get_color2(config.volume_red, config.volume_green, config.volume_blue);
      	strcpy(tstring3, global_string);
      	strcpy(tstring, config.pixmap_path);
      	strcat(tstring, "/gs_");
      	strcat(tstring, tstring3);
      	strcat(tstring, ".xpm");
    	color = gdk_pixmap_create_from_xpm(main_window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL], tstring);
      	line[2] = 0;
      	strcpy(tstring4, "NA");
      	line[3] = tstring4;
      	gtk_clist_append (GTK_CLIST (edit_indicator_clist), line);
      	if (status4)
      		gtk_clist_set_pixmap(GTK_CLIST(edit_indicator_clist), 3, 0, on, mask);
      	else
      		gtk_clist_set_pixmap(GTK_CLIST(edit_indicator_clist), 3, 0, off, mask);
      	gtk_clist_set_pixmap(GTK_CLIST(edit_indicator_clist), 3, 2, color, mask);
      		
      	if (flag)
      		gtk_clist_select_row(GTK_CLIST(edit_indicator_clist), tint, 0);
      	gtk_clist_thaw (GTK_CLIST (edit_indicator_clist));
      	
      	if (config.global_indicators)
		strcpy(tstring, "Edit Global Indicators - ");
	else
        	strcpy(tstring, "Edit Indicators - ");
	strcat(tstring, header.name);
	strcat(tstring, " (");
	strcat(tstring, header.symbol);
	strcat(tstring, ")");
	gtk_window_set_title (GTK_WINDOW (edit_indicator_window), tstring);
}
/***********************************************************************************/
void ok_edit_indicator()
{
	int tint;
    	GList *list;
	extern GtkWidget *edit_indicator_clist;
    	extern char *error_message;
    	
    	
	list = GTK_CLIST (edit_indicator_clist)->selection;
	if (list)
	{
		tint = (int) list->data;
		switch(tint)
		{
			case 0: show_indicator2_window();
				break;
			case 1: show_indicator2_window();
				break;
			case 2: show_indicator2_window();
				break;
			default: break;
		}
    	}
    	else
	  RETURN_ERR(gs_nothing_selected_edit);
}
/**********************************************************************************/
void toggle_indicator_status()
{
	int tint;
    	GList *list;
	char *text;
	extern GtkWidget *edit_indicator_clist;
    	extern char *error_message;
    	extern struct record2 header;
    	extern struct record3 config;
    	
    	
    	
	list = GTK_CLIST (edit_indicator_clist)->selection;
	if (list)
	{
		tint = (int) list->data;
		gtk_clist_get_text (GTK_CLIST (edit_indicator_clist), tint, 0, &text);
		switch(tint)
		{
			case 0: if (config.global_indicators)
				{
					if (config.global_moving_status)
						config.global_moving_status = 0;
					else
						config.global_moving_status = 1;
				}
				else
				{
					if (header.moving[0])
						header.moving[0] = 0;
					else
						header.moving[0] = 1;
				}
				break;
			case 1: if (config.global_indicators)
				{
					if (config.global_moving2_status)
						config.global_moving2_status = 0;
					else
						config.global_moving2_status = 1;
				}
				else
				{
					if (header.moving2[0])
						header.moving2[0] = 0;
					else
						header.moving2[0] = 1;
				}
				break;
			case 2: if (config.global_indicators)
				{
					if (config.global_moving3_status)
						config.global_moving3_status = 0;
					else
						config.global_moving3_status = 1;
				}
				else
				{
					if (header.moving3[0])
						header.moving3[0] = 0;
					else
						header.moving3[0] = 1;
				}
				break;
			case 3: if (config.global_indicators)
				{
					if (config.global_volume_status)
						config.global_volume_status = 0;
					else
						config.global_volume_status = 1;
				}
				else
				{
					if (header.volume)
						header.volume = 0;
					else
						header.volume = 1;
				}
				break;
			default: break;
		}
		update_indicator_clist();
		show_indicators();
		draw();
    	}
    	else
	  RETURN_ERR(gs_nothing_selected_edit);
}
/**********************************************************************************/
void show_indicator2_window()
{
	int tint;
    	GList *list;
	char tstring[100], *length;
	GtkWidget *vbox, *hbox, *hbox2, *hbox3, *label, *label2, *button, *button2;
	GtkWidget *button3,*hsep;
	extern GtkWidget *edit_indicator2_window, *edit_indicator2_entry, *edit_indicator_clist;
	extern GtkWidget *indicator_type_combo;
	extern GList *moving_type_list;
	extern struct record2 header;
	extern struct record3 config;
		
    	
	
	edit_indicator2_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect (GTK_OBJECT (edit_indicator2_window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &edit_indicator2_window);
	gtk_window_position(GTK_WINDOW (edit_indicator2_window), GTK_WIN_POS_CENTER);
	gtk_widget_set_usize(GTK_WIDGET (edit_indicator2_window), 300, 0);
	
	vbox = gtk_vbox_new (FALSE, 0);
      	gtk_container_add (GTK_CONTAINER (edit_indicator2_window), vbox);
      	gtk_widget_show (vbox);
      	
     	hbox = gtk_hbox_new (FALSE, 10);
      	gtk_container_border_width (GTK_CONTAINER (hbox), 10);
      	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
      	gtk_widget_show (hbox);
      	
	label = gtk_label_new("Length:");
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, TRUE, 0);
        gtk_widget_show(label);
        
        list = GTK_CLIST (edit_indicator_clist)->selection;
	tint = (int) list->data;
	gtk_clist_get_text (GTK_CLIST (edit_indicator_clist), tint, 3, &length);
        
	edit_indicator2_entry = gtk_entry_new ();
      	gtk_entry_set_text(GTK_ENTRY(edit_indicator2_entry), length);
      	gtk_box_pack_start (GTK_BOX (hbox), edit_indicator2_entry, FALSE, TRUE, 0);
      	gtk_widget_show (edit_indicator2_entry);
      	
      	if (config.global_indicators)
      		strcpy(tstring, "Editing Global ");
      	else
      		strcpy(tstring, "Editing ");
      	gtk_clist_get_text (GTK_CLIST (edit_indicator_clist), tint, 1, &length);
      	strcat(tstring, length);
      	gtk_window_set_title (GTK_WINDOW (edit_indicator2_window), tstring);
      	
      	hbox3 = gtk_hbox_new (FALSE, 10);
      	gtk_container_border_width (GTK_CONTAINER (hbox3), 10);
      	gtk_box_pack_start (GTK_BOX (vbox), hbox3, FALSE, TRUE, 0);
      	gtk_widget_show (hbox3);
      	
      	label2 = gtk_label_new("Type:");
	gtk_box_pack_start (GTK_BOX (hbox3), label2, FALSE, TRUE, 0);
        gtk_widget_show(label2);
        
        indicator_type_combo = gtk_combo_new ();
      	gtk_combo_set_popdown_strings (GTK_COMBO (indicator_type_combo), moving_type_list);
      	if (tint == 0)
      	{
      		if (header.moving[1] == 1)
      			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(indicator_type_combo)->entry), "Simple");
      		if (header.moving[1] == 2)
      			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(indicator_type_combo)->entry), "Weighted");
      	}
      	if (tint == 1)
      	{
      		if (header.moving2[1] == 1)
      			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(indicator_type_combo)->entry), "Simple");
      		if (header.moving2[1] == 2)
      			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(indicator_type_combo)->entry), "Weighted");
      	}
      	if (tint == 2)
      	{
      		if (header.moving3[1] == 1)
      			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(indicator_type_combo)->entry), "Simple");
      		if (header.moving3[1] == 2)
      			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(indicator_type_combo)->entry), "Weighted");
      	}
      	gtk_box_pack_start (GTK_BOX (hbox3), indicator_type_combo, FALSE, TRUE, 0);
      	gtk_widget_show (indicator_type_combo);
      	
        hsep = gtk_hseparator_new();
	gtk_box_pack_start (GTK_BOX (vbox), hsep, FALSE, TRUE, 0);
        gtk_widget_show(hsep);
        
        hbox2 = gtk_hbutton_box_new();
        gtk_hbutton_box_set_spacing_default(10);
        gtk_hbutton_box_set_layout_default(GTK_BUTTONBOX_END);
        gtk_container_border_width (GTK_CONTAINER (hbox2), 10);
        gtk_box_pack_start (GTK_BOX (vbox), hbox2, FALSE, TRUE, 0);
      	gtk_widget_show(hbox2);
      	
      	button = gtk_button_new_with_label("OK");
      	gtk_box_pack_start (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
     	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (update_indicator2), NULL);
	gtk_widget_show (button);
	
	button2 = gtk_button_new_with_label("Cancel");
      	gtk_box_pack_start (GTK_BOX (hbox2), button2, TRUE, TRUE, 0);
      	gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(edit_indicator2_window));
      	gtk_widget_show (button2);
      	
      	button3 = gtk_button_new_with_label("Help");
      	gtk_box_pack_start (GTK_BOX (hbox2), button3, TRUE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button3), "clicked",
			    GTK_SIGNAL_FUNC (help_edit_indicator_window), NULL);
      	gtk_widget_show (button3);
      	
      	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
      	gtk_widget_grab_default(button);
      	gtk_widget_show(edit_indicator2_window);
}
/**********************************************************************************/
void show_indicator3_window()
{
	
}
/*********************************************************************************/
void exit_edit_indicator_window()
{
	extern GtkWidget *edit_indicator_window, *indicator_button;
	extern int edit_indicators_window_flag;
	
	
	gtk_widget_destroy(edit_indicator_window);
	edit_indicators_window_flag = 0;
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(indicator_button), 0);
}
/******************************************************************************************/
void edit_indicators()
{
	char tstring[250], *text[] = {"Status", "Indicator", "Color", "Length"};
    	GtkWidget *edit_button, *help_button, *toggle2_button;
    	GtkWidget *toggle_button, *vbox, *vbox2, *hbox, *hbox2;
    	extern GtkWidget *edit_indicator_window, *edit_indicator_clist, *indicator_button;
    	extern int chartflag, edit_indicators_window_flag;
	extern struct record2 header;
	extern struct record3 config;
	    
	
	
	if (chartflag != 1)
	{
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(indicator_button), 0);
		return;
	}
	if (! GTK_TOGGLE_BUTTON(indicator_button)->active)
    	{
    		if (edit_indicators_window_flag)
    		{
    			exit_edit_indicator_window();
    			return;
    		}
    		else
			return;
	}
	else
	{
		if (edit_indicators_window_flag)
		{
			if (config.global_indicators)
				strcpy(tstring, "Edit Global Indicators - ");
			else
        			strcpy(tstring, "Edit Indicators - ");
			strcat(tstring, header.name);
			strcat(tstring, " (");
			strcat(tstring, header.symbol);
			strcat(tstring, ")");
			gtk_window_set_title (GTK_WINDOW (edit_indicator_window), tstring);
			update_indicator_clist();
			return;
		}
		else
		{
        		edit_indicator_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
        		gtk_signal_connect (GTK_OBJECT (edit_indicator_window), "destroy",
			    GTK_SIGNAL_FUNC (exit_edit_indicator_window), NULL);
        		gtk_window_set_title (GTK_WINDOW (edit_indicator_window), "Edit Chart Indicators");
        		gtk_container_border_width (GTK_CONTAINER (edit_indicator_window), 0);
        		gtk_window_position(GTK_WINDOW (edit_indicator_window), GTK_WIN_POS_CENTER);
			gtk_widget_set_usize(GTK_WIDGET (edit_indicator_window), 450, 0);
	
			if (config.global_indicators)
				strcpy(tstring, "Edit Global Indicators - ");
			else
        			strcpy(tstring, "Edit Indicators - ");
			strcat(tstring, header.name);
			strcat(tstring, " (");
			strcat(tstring, header.symbol);
			strcat(tstring, ")");
			gtk_window_set_title (GTK_WINDOW (edit_indicator_window), tstring);
	
			hbox = gtk_hbox_new (FALSE, 10);
        		gtk_container_add (GTK_CONTAINER (edit_indicator_window), hbox);
        		gtk_container_border_width (GTK_CONTAINER (hbox), 10);
        		gtk_widget_show (hbox);
        
        		vbox = gtk_vbox_new (FALSE, 10);
        		gtk_box_pack_start (GTK_BOX (hbox), vbox, TRUE, TRUE, 0);
        		gtk_widget_show (vbox);
        
        		hbox2 = gtk_hbox_new (FALSE, 10);
        		gtk_box_pack_start (GTK_BOX (vbox), hbox2, TRUE, TRUE, 0);
        		gtk_widget_show (hbox2);

      			vbox2 = gtk_vbutton_box_new ();
      			gtk_vbutton_box_set_spacing_default(5);
      			gtk_vbutton_box_set_layout_default(GTK_BUTTONBOX_START);
      			gtk_box_pack_start (GTK_BOX (hbox), vbox2, FALSE, TRUE, 0);
      			gtk_widget_show (vbox2);
      	
			edit_button = gtk_button_new_with_label("Edit");
      			gtk_box_pack_start (GTK_BOX (vbox2), edit_button, FALSE, TRUE, 0);
			gtk_signal_connect (GTK_OBJECT (edit_button), "clicked",
		    	    GTK_SIGNAL_FUNC (ok_edit_indicator), NULL);
			gtk_widget_show (edit_button);
	
			toggle_button = gtk_button_new_with_label("Toggle Status");
      			gtk_box_pack_start (GTK_BOX (vbox2), toggle_button, FALSE, TRUE, 0);
      			gtk_signal_connect (GTK_OBJECT (toggle_button), "clicked",
			    GTK_SIGNAL_FUNC (toggle_indicator_status), NULL);
			gtk_widget_show (toggle_button);
	
			toggle2_button = gtk_button_new_with_label("Globals");
      			gtk_box_pack_start (GTK_BOX (vbox2), toggle2_button, FALSE, TRUE, 0);
      			gtk_signal_connect (GTK_OBJECT (toggle2_button), "clicked",
			    GTK_SIGNAL_FUNC (yesno_global_indicators), NULL);
			gtk_widget_show (toggle2_button);
	
      			help_button = gtk_button_new_with_label("Help");
      			gtk_box_pack_start (GTK_BOX (vbox2), help_button, FALSE, TRUE, 0);
      			gtk_signal_connect (GTK_OBJECT (help_button), "clicked",
			    GTK_SIGNAL_FUNC (help_edit_indicator_window), NULL);
      			gtk_widget_show (help_button);
      	
        		edit_indicator_clist = gtk_clist_new_with_titles (4, text);
      			gtk_clist_set_column_width(GTK_CLIST(edit_indicator_clist), 0, 40);
      			gtk_clist_set_column_width(GTK_CLIST(edit_indicator_clist), 1, 125);
      			gtk_clist_set_column_width(GTK_CLIST(edit_indicator_clist), 2, 40);
      			gtk_clist_set_column_width(GTK_CLIST(edit_indicator_clist), 3, 40);
      			gtk_clist_set_selection_mode (GTK_CLIST (edit_indicator_clist), GTK_SELECTION_SINGLE);
       			gtk_clist_set_policy(GTK_CLIST(edit_indicator_clist), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
       			gtk_box_pack_start (GTK_BOX (hbox2), edit_indicator_clist, TRUE, TRUE, 0);
      			gtk_widget_show (edit_indicator_clist);
      	
      			edit_indicators_window_flag = 1;
      			gtk_widget_show(edit_indicator_window);
      			update_indicator_clist();
      		}
      	}
}