/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */


#include "myheader.h"

/*****************************************************************************************/
void draw_grid()
{
	GdkColor *color;
       	GdkGC *gc;
	char tstring[15], tstring2[15];
	int tint, x, tint2, tint3, current_width, current_height;
	unsigned int tuint;
	extern unsigned int records;
	extern GtkWidget *chart;
	extern GdkPixmap *pixmap;
	extern struct record1 *data;
	extern struct record2 header;
	extern struct record3 config;
	float tfloat, tfloat2, interval, y = 0;
	extern float range, maxhigh, maxlow;
	
        
        gc = gdk_gc_new(chart->window);
       	color = (GdkColor *)malloc(sizeof(GdkColor));
       	color->red = config.grid_red * (65535/255);
       	color->green = config.grid_green * (65535/255);
       	color->blue = config.grid_blue * (65535/255);
       	gdk_color_alloc(gtk_widget_get_colormap(chart), color);
       	gdk_gc_set_foreground(gc, color);
       	
        current_width = chart->allocation.width;
	current_height = chart->allocation.height;
	sprintf(tstring, "%ld", data[0].date);
	tstring2[0] = tstring[5];
	for (tuint = 0; tuint < records; tuint++)
	{
		sprintf(tstring, "%ld", data[tuint].date);
	     	if (tstring[5] != tstring2[0])
	     	{
			tstring2[0] = tstring[5];
			x = tuint * header.pixelspace;
			tint = 1;
			while (tint < current_height)
			{
				gdk_draw_point (pixmap, gc, x, tint);
				tint = tint + 4;
			}
  		}
  	}
  	if (range < 1)
	{
	  interval = 0.1;
	  if (range / interval < 10)
	  {
	    for (interval = 0.0025; (range / interval) >= 10; interval = interval + 0.0025)
	    {
	    }
	  }
	}
	else
	{
	  if (range < 10)
	  {
	    interval = 1;
	    if (range / interval < 10)
	    {
	      for (interval = 0.1; (range / interval) >= 10; interval = interval + 0.1)
	      {
	      }
	    }
	  }
	  else
	  {
	    if (range < 50)
	    {
	      interval = 5;	      
	      if (range / interval < 10)
	      {
	        for (interval = 1; (range / interval) >= 10; interval = interval + 1)
	        {
	        }
	      }
	    }
	    else
	    {
	      if (range < 100)
	      {
	        interval = 10;
	        if (range / interval < 10)
	        {
	          for (interval = 5; (range / interval) >= 10; interval = interval + 1)
	          {
	          }
	        }
	      }
	      else
	      {
	        if (range < 500)
	        {
	          interval = 50;
	          if (range / interval < 10)
	          {
	            for (interval = 25; (range / interval) >= 10; interval = interval + 5)
	            {
	            }
	          }
	        }
	        else
	        {
	          if (range < 1000)
	          {
	            interval = 100;
	            if (range / interval < 10)
	            {
	            	for (interval = 50; (range / interval) >= 10; interval = interval + 10)
	            	{
	            	}
	            }
	          }
	          else
	          {
	            if (range < 5000)
	            {
	              interval = 500;
	              if (range / interval < 10)
	              {
	            	for (interval = 250; (range / interval) >= 10; interval = interval + 25)
	            	{
	            	}
	              }
	            }
	            else
	            {
	              interval = 1000;
	            }
	          }
	        }
	      }
	    }
	  }
	}
	tint2 = (int)(maxlow / interval);
	for (tint = 1; tint < 10; tint++)
	{
		if (maxlow > 10)
		     tfloat = (tint2 * interval) + (interval * tint);
	       	else
		     tfloat = (tint2 * interval) + (interval * tint);
	       	tfloat2 = (maxhigh - tfloat) * (current_height / range);
	       	y = (int)tfloat2 + 2;
	       	tint3 = 1;
		while (tint3 < current_width)
		{
			gdk_draw_point (pixmap, gc, tint3, y - 2);
			tint3 = tint3 + 4;
		}
	}
}
/*****************************************************************************************/
void draw_date()
{
	GdkRectangle area;
	GdkColor *color;
       	GdkGC *gc;
	char tstring[250], tstring2[250], tstring3[250], *monthstring;
	int x, tint2, current_width, current_height;
	unsigned int tuint;
	GdkFont *font;
	extern unsigned int records;
	extern GtkWidget *date, *chart;
	extern GdkPixmap *date_pixmap;
	extern struct record1 *data;
	extern struct record2 header;
	extern struct record3 config;
	
        
        gc = gdk_gc_new(chart->window);
       	color = (GdkColor *)malloc(sizeof(GdkColor));
       	color->red = config.background_red * (65535/255);
       	color->green = config.background_green * (65535/255);
       	color->blue = config.background_blue * (65535/255);
       	gdk_color_alloc(gtk_widget_get_colormap(date), color);
       	gdk_gc_set_foreground(gc, color);
        
        gdk_draw_rectangle (date_pixmap, gc, TRUE, 0, 0,
			    date->allocation.width,
			    date->allocation.height);
			    
       	color->red = config.border_red * (65535/255);
       	color->green = config.border_green * (65535/255);
       	color->blue = config.border_blue * (65535/255);
       	gdk_color_alloc(gtk_widget_get_colormap(date), color);
       	gdk_gc_set_foreground(gc, color);
       	
        current_width = date->allocation.width;
	current_height = chart->allocation.height;
        font = gdk_font_load ("-Adobe-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-*");
        gdk_draw_line (date_pixmap, gc, 0, 0, current_width, 0);
        	       
	sprintf(tstring, "%ld", data[0].date);
	tstring3[0] = tstring[5];
	for (tuint = 0; tuint < records; tuint++)
	{
	     sprintf(tstring, "%ld", data[tuint].date);
	     if (tstring[5] != tstring3[0])
	     {
		tstring3[0] = tstring[5];
		x = tuint * header.pixelspace;
	       	gdk_draw_line (date_pixmap, gc, x, 0, x, 5);
	       	sprintf(tstring, "%ld", data[tuint].date);
	       	tstring2[0] = tstring[4];
	       	tstring2[1] = tstring[5];
	       	tstring2[2] = 0;
	       	tint2 = (int)atoi(tstring2);
	       	switch(tint2)
        	{
                	case 1 :
                		strcpy(tstring2, tstring);
               			tstring2[4] = 0;
               			gdk_draw_string	 (date_pixmap, font, gc, x - 13, 16, tstring2);
               			break;
               		case 2 :
               			if (header.pixelspace > 2)
               			{
               				monthstring = "Feb";
               				x = x - 9;
               			}
               			else
               			{
               				monthstring = "F";
               				x = x - 4;
               			}
               			gdk_draw_string	 (date_pixmap, font, gc, x, 16, monthstring);
                		break;
                	case 3 :
                		if (header.pixelspace > 2)
                		{
                			monthstring = "Mar";
                			x = x - 13;
                		}
                		else
                		{
                			monthstring = "M";
                			x = x - 5;
                		}
                		gdk_draw_string	 (date_pixmap, font, gc, x , 16, monthstring);
                		break;
                	case 4 :
                		if (header.pixelspace > 2)
                		{
                			monthstring = "Apr";
                			x = x - 9;
                		}
                		else
                		{
                			monthstring = "A";
                			x = x - 4;
                		}
                		gdk_draw_string	 (date_pixmap, font, gc, x , 16, monthstring);
                		break;
                	case 5 :
                		if (header.pixelspace > 2)
                		{
                			monthstring = "May";
                			x = x - 13;
                		}
                		else
                		{
                			monthstring = "M";
                			x = x - 5;
                		}
                		gdk_draw_string	 (date_pixmap, font, gc, x , 16, monthstring);
                		break;
                	case 6 :
                		if (header.pixelspace > 2)
                		{
                			monthstring = "Jun";
                			x = x - 9;
                		}
                		else
                		{
                			monthstring = "J";
                			x = x - 5;
                		}
                		gdk_draw_string	 (date_pixmap, font, gc, x , 16, monthstring);
                		break;
                	case 7 :
                		if (header.pixelspace > 2)
                		{
                			monthstring = "Jul";
                			x = x - 10;
                		}
                		else
                		{
                			monthstring = "J";
                			x = x - 5;
                		}
                		gdk_draw_string	 (date_pixmap, font, gc, x , 16, monthstring);
                		break;
                	case 8 :
                		if (header.pixelspace > 2)
                		{
                			monthstring = "Aug";
                			x = x - 10;
                		}
                		else
                		{
                			monthstring = "A";
                			x = x - 4;
                		}
                		gdk_draw_string	 (date_pixmap, font, gc, x , 16, monthstring);
                		break;
                	case 9 :
                		if (header.pixelspace > 2)
                		{
                			monthstring = "Sep";
                			x = x - 11;
                		}
                		else
                		{
                			monthstring = "S";
                			x = x - 5;
                		}
                		gdk_draw_string	 (date_pixmap, font, gc, x , 16, monthstring);
                		break;
                	case 10 :
                		if (header.pixelspace > 2)
                		{
                			monthstring = "Oct";
                			x = x - 11;
                		}
                		else
                		{
                			monthstring = "O";
                			x = x - 5;
                		}
                		gdk_draw_string	 (date_pixmap, font, gc, x , 16, monthstring);
                		break;
                	case 11 :
                		if (header.pixelspace > 2)
                		{
                			monthstring = "Nov";
                			x = x - 10;
                		}
                		else
                		{
                			monthstring = "N";
                			x = x - 5;
                		}
                		gdk_draw_string	 (date_pixmap, font, gc, x , 16, monthstring);
                		break;
                	case 12 :
                		if (header.pixelspace > 2)
                		{
                			monthstring = "Dec";
                			x = x - 10;
                		}
                		else
                		{
                			monthstring = "D";
                			x = x - 5;
                		}
                		gdk_draw_string	 (date_pixmap, font, gc, x , 16, monthstring);
                		break;
                	default :
				break;
		}
	    }
	}
	area.x = 0;
	area.y = 0;
	area.width = date->allocation.width;
	area.height = date->allocation.height;
	gtk_widget_draw (date, &area);
}
/*********************************************************************************/
void draw_volume()
{
	GdkRectangle area;
	GdkColor *color;
       	GdkGC *gc;
	int tint, tint2, red=0, green=0, blue=0, current_width;
	unsigned int tuint;
	unsigned long tlong;
	float percent;
	extern GdkPixmap *volume_pixmap;
	extern GtkWidget *volume, *chart;
	extern unsigned int records;
	extern long volume_high;
	extern struct record1 *data;
	extern struct record2 header;
	extern struct record3 config;
	
	
	gc = gdk_gc_new(chart->window);
       	color = (GdkColor *)malloc(sizeof(GdkColor));
       	color->red = config.background_red * (65535/255);
       	color->green = config.background_green * (65535/255);
       	color->blue = config.background_blue * (65535/255);
       	gdk_color_alloc(gtk_widget_get_colormap(volume), color);
       	gdk_gc_set_foreground(gc, color);
       	
	gdk_draw_rectangle (volume_pixmap, gc, TRUE, 0, 0,
			    	    volume->allocation.width,
			    	    volume->allocation.height);
	
       	color->red = config.border_red * (65535/255);
       	color->green = config.border_green * (65535/255);
       	color->blue = config.border_blue * (65535/255);
       	gdk_color_alloc(gtk_widget_get_colormap(volume), color);
       	gdk_gc_set_foreground(gc, color);
       	
	current_width = volume->allocation.width;	
	gdk_draw_line (volume_pixmap, gc, 0, 0, current_width, 0);
	
	red = config.volume_red;
	green = config.volume_green;
	blue = config.volume_blue;
	
       	color->red = red * (65535/255);
       	color->green = green * (65535/255);
       	color->blue = blue * (65535/255);
       	gdk_color_alloc(gtk_widget_get_colormap(volume), color);
       	gdk_gc_set_foreground(gc, color);
        	       
	tint = 0;
	percent = volume_high / (VOLUME_SIZE - 1);
	for (tuint = 0; tuint < records; tuint++)
	{
		tlong = data[tuint].volume;
		tint2 = (int)(tlong / percent);
		if (tint2 > 0)
		{
			gdk_draw_line (volume_pixmap, gc, tint, VOLUME_SIZE,
					tint, VOLUME_SIZE - tint2);
		 }
	 	 tint = tint + header.pixelspace;
	 }
	area.x = 0;
	area.y = 0;
	area.width = volume->allocation.width;
	area.height = volume->allocation.height;
	gtk_widget_draw (volume, &area);
}
/**********************************************************************************/
void draw_scale()
{
	GdkRectangle area;
	GdkColor *color;
       	GdkGC *gc;
	float tfloat, tfloat2, interval, y = 0;
	char tstring[250];
	int tint, tint2 = 0, current_height, current_width;
	GdkFont *font;
	extern GdkPixmap *pixmap2;
	extern GtkWidget *scale, *chart;
	extern float range, maxhigh, maxlow;
	extern struct record3 config;
	
	gc = gdk_gc_new(chart->window);
       	color = (GdkColor *)malloc(sizeof(GdkColor));
       	color->red = config.background_red * (65535/255);
       	color->green = config.background_green * (65535/255);
       	color->blue = config.background_blue * (65535/255);
       	gdk_color_alloc(gtk_widget_get_colormap(scale), color);
       	gdk_gc_set_foreground(gc, color);
	
	gdk_draw_rectangle (pixmap2, gc, TRUE, 0, 0,
			    scale->allocation.width,
			    scale->allocation.height);
	
       	color->red = config.border_red * (65535/255);
       	color->green = config.border_green * (65535/255);
       	color->blue = config.border_blue * (65535/255);
       	gdk_color_alloc(gtk_widget_get_colormap(chart), color);
       	gdk_gc_set_foreground(gc, color);
       	
	current_height = scale->allocation.height;
	gdk_draw_line (pixmap2, gc, 0, 0, 0, current_height);
	current_width = chart->allocation.width;
	current_height = chart->allocation.height;
	font = gdk_font_load ("-Adobe-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-*");
	if (range < 1)
	{
	  interval = 0.1;
	  if (range / interval < 10)
	  {
	    for (interval = 0.0025; (range / interval) >= 10; interval = interval + 0.0025)
	    {
	    }
	  }
	}
	else
	{
	  if (range < 10)
	  {
	    interval = 1;
	    if (range / interval < 10)
	    {
	      for (interval = 0.1; (range / interval) >= 10; interval = interval + 0.1)
	      {
	      }
	    }
	  }
	  else
	  {
	    if (range < 50)
	    {
	      interval = 5;	      
	      if (range / interval < 10)
	      {
	        for (interval = 1; (range / interval) >= 10; interval = interval + 1)
	        {
	        }
	      }
	    }
	    else
	    {
	      if (range < 100)
	      {
	        interval = 10;
	        if (range / interval < 10)
	        {
	          for (interval = 5; (range / interval) >= 10; interval = interval + 1)
	          {
	          }
	        }
	      }
	      else
	      {
	        if (range < 500)
	        {
	          interval = 50;
	          if (range / interval < 10)
	          {
	            for (interval = 25; (range / interval) >= 10; interval = interval + 5)
	            {
	            }
	          }
	        }
	        else
	        {
	          if (range < 1000)
	          {
	            interval = 100;
	            if (range / interval < 10)
	            {
	            	for (interval = 50; (range / interval) >= 10; interval = interval + 10)
	            	{
	            	}
	            }
	          }
	          else
	          {
	            if (range < 5000)
	            {
	              interval = 500;
	              if (range / interval < 10)
	              {
	            	for (interval = 250; (range / interval) >= 10; interval = interval + 25)
	            	{
	            	}
	              }
	            }
	            else
	            {
	              interval = 1000;
	            }
	          }
	        }
	      }
	    }
	  }
	}
	tint2 = (int)(maxlow / interval);
	for (tint = 1; tint < 10; tint++)
	{
	       if (maxlow > 10)
	       {
		     sprintf(tstring,"%5.2f",(tint2 * interval) + (interval * tint));
		     tfloat = (tint2 * interval) + (interval * tint);
	       }	
	       else
	       {
		     sprintf(tstring,"%5.4f",(tint2 * interval) + (interval * tint));
		     tfloat = (tint2 * interval) + (interval * tint);
	       }
	       tfloat2 = (maxhigh - tfloat) * (current_height / range);
	       y = (int)tfloat2 + 2;
	       gdk_draw_string(pixmap2, font, gc, 6, y + 5, tstring);
	       gdk_draw_line (pixmap2, gc, 0, y, 4, y);	       
	}
	area.x = 0;
	area.y = 0;
	area.width = scale->allocation.width;
	area.height = scale->allocation.height;
	gtk_widget_draw (scale, &area);
}
/***********************************************************************************/
void draw_price()
{
	GdkRectangle area;
	int tint, firstx, firsty, secondy, current_height;
	unsigned int tuint;
	GdkColor *color;
       	GdkGC *gc;
	extern float maxhigh, range;
	extern unsigned int records;
	extern GdkPixmap *pixmap;
	extern GtkWidget *chart, *style_button;
	extern struct record1 *data;
	extern struct record2 header;
	extern struct record3 config;
	
	
	gc = gdk_gc_new(chart->window);
       	color = (GdkColor *)malloc(sizeof(GdkColor));
       	color->red = config.background_red * (65535/255);
       	color->green = config.background_green * (65535/255);
       	color->blue = config.background_blue * (65535/255);
       	gdk_color_alloc(gtk_widget_get_colormap(chart), color);
       	gdk_gc_set_foreground(gc, color);
	
	gdk_draw_rectangle (pixmap, gc, TRUE, 0, 0,
			    chart->allocation.width,
			    chart->allocation.height);
			    
	if(config.grid)
		draw_grid();
	
       	color->red = config.price_red * (65535/255);
       	color->green = config.price_green * (65535/255);
       	color->blue = config.price_blue * (65535/255);
       	gdk_color_alloc(gtk_widget_get_colormap(chart), color);
       	gdk_gc_set_foreground(gc, color);
       	

       	current_height = chart->allocation.height;
	tint = 0;
	if (! GTK_TOGGLE_BUTTON(style_button)->active)
    	{
		firstx = 0;
		firsty = (maxhigh - data[0].close) * (current_height / range);
		for (tuint = 0; tuint < records; tuint++)
		{
			secondy = (maxhigh - data[tuint].close)*(current_height / range);
			gdk_draw_line (pixmap, gc, firstx, firsty, tint, secondy);
			firstx = tint;
			firsty = secondy;
	     		tint = tint + header.pixelspace;
	       	}
	 }
	 else
	 {
	 	if (header.pixelspace < 6)
	 	{
			header.pixelspace = 6;
			show_indicators();
		}
	 	for (tuint = 0; tuint < records; tuint++)
		{
			firsty = (maxhigh - data[tuint].open) * (current_height / range);
		       	secondy = firsty;
		       	gdk_draw_line (pixmap, gc, tint, firsty, (tint - 2), secondy);
		       	firsty = (maxhigh - data[tuint].high) * (current_height / range);
		       	secondy = (maxhigh - data[tuint].low) * (current_height / range);
		       	gdk_draw_line (pixmap, gc, tint, firsty, tint, secondy);
			firsty = (maxhigh - data[tuint].close)*(current_height / range);
			secondy = firsty;
			gdk_draw_line (pixmap, gc, tint, firsty, (tint + 2), secondy);
	      		tint = tint + header.pixelspace;
	       	}
	}
	if (config.global_indicators)
	{
		if (config.global_moving_status)
			draw_moving_average();
		if (config.global_moving2_status)
			draw_moving_average2();
		if (config.global_moving3_status)
			draw_moving_average3();
	}
	else
	{
		if (header.moving[0])
			draw_moving_average();
		if (header.moving2[0])
			draw_moving_average2();
		if (header.moving3[0])
			draw_moving_average3();
	}
	area.x = 0;
	area.y = 0;
	area.width = chart->allocation.width;
	area.height = chart->allocation.height;
	gtk_widget_draw (chart, &area);
}
/************************************************************************************/
void draw_moving_average()
{
	int tint, firstx, firsty, secondy, type, red, green, blue, period, current_height;
	unsigned int tuint;
	float tfloat = 0.0;
	GdkColor *color;
       	GdkGC *gc;
	extern float maxhigh, range;
	extern GdkPixmap *pixmap;
	extern GtkWidget *chart;
	extern unsigned int records;
	extern struct record2 header;
	extern struct record3 config;
	
	
	if (config.global_indicators)
	{
		type = config.global_moving_type;
		period = config.global_moving_length;
	}
	else
	{
		type = header.moving[1];
		period = header.moving[2];
	}
	red = config.moving_red;
	green = config.moving_green;
	blue = config.moving_blue;
			
	gc = gdk_gc_new(chart->window);
	color = (GdkColor *)malloc(sizeof(GdkColor));
      	color->red = red * (65535/255);
       	color->green = green * (65535/255);
       	color->blue = blue * (65535/255);
       	gdk_color_alloc(gtk_widget_get_colormap(chart), color);
       	gdk_gc_set_foreground(gc, color);
       	
	
       	current_height = chart->allocation.height;
	tuint = period;
	firstx = period * header.pixelspace;
	tint = firstx;
	if (type == 1)
		tfloat = get_simple_movavg(period, tuint);
	if (type == 2)
		tfloat = get_weighted_movavg(period, tuint);
	if (type == 3)
		tfloat = get_exponential_movavg(period, tuint);
	firsty = (maxhigh - tfloat) * (current_height / range);
	tuint++;
	tint = tint + header.pixelspace;
	if (type == 1)
	{
		for (tuint = tuint; tuint < records; tuint++)
		{
			tfloat = get_simple_movavg(period, tuint);
			secondy = (maxhigh - tfloat) * (current_height / range);
			gdk_draw_line (pixmap, gc, firstx, firsty, tint, secondy);
			firstx = tint;
			tint = tint + header.pixelspace;
			firsty = secondy;
		}
	}
	if (type == 2)
	{
		for (tuint = tuint; tuint < records; tuint++)
		{
			tfloat = get_weighted_movavg(period, tuint);
			secondy = (maxhigh - tfloat) * (current_height / range);
			gdk_draw_line (pixmap, gc, firstx, firsty, tint, secondy);
			firstx = tint;
			tint = tint + header.pixelspace;
			firsty = secondy;
		}
	}
	if (type == 3)
	{
		for (tuint = tuint; tuint < records; tuint++)
		{
			tfloat = get_exponential_movavg(period, tuint);
			secondy = (maxhigh - tfloat) * (current_height / range);
			gdk_draw_line (pixmap, gc, firstx, firsty, tint, secondy);
			firstx = tint;
			tint = tint + header.pixelspace;
			firsty = secondy;
		}
	}
}
/*************************************************************************************/
void draw_moving_average2()
{
	int tint, firstx, firsty, secondy, type, red, green, blue, period, current_height;
	unsigned int tuint;
	float tfloat = 0.0;
	GdkColor *color;
       	GdkGC *gc;
	extern float maxhigh, range;
	extern GdkPixmap *pixmap;
	extern GtkWidget *chart;
	extern unsigned int records;
	extern struct record2 header;
	extern struct record3 config;
	
	
	if (config.global_indicators)
	{
		type = config.global_moving2_type;
		period = config.global_moving2_length;
	}
	else
	{
		type = header.moving2[1];
		period = header.moving2[2];
	}
	red = config.moving2_red;
	green = config.moving2_green;
	blue = config.moving2_blue;
			
	gc = gdk_gc_new(chart->window);
	color = (GdkColor *)malloc(sizeof(GdkColor));
      	color->red = red * (65535/255);
       	color->green = green * (65535/255);
       	color->blue = blue * (65535/255);
       	gdk_color_alloc(gtk_widget_get_colormap(chart), color);
       	gdk_gc_set_foreground(gc, color);
       	
	
       	current_height = chart->allocation.height;
	tuint = period;
	firstx = period * header.pixelspace;
	tint = firstx;
	if (type == 1)
		tfloat = get_simple_movavg(period, tuint);
	if (type == 2)
		tfloat = get_weighted_movavg(period, tuint);
	if (type == 3)
		tfloat = get_exponential_movavg(period, tuint);
	firsty = (maxhigh - tfloat) * (current_height / range);
	tuint++;
	tint = tint + header.pixelspace;
	if (type == 1)
	{
		for (tuint = tuint; tuint < records; tuint++)
		{
			tfloat = get_simple_movavg(period, tuint);
			secondy = (maxhigh - tfloat) * (current_height / range);
			gdk_draw_line (pixmap, gc, firstx, firsty, tint, secondy);
			firstx = tint;
			tint = tint + header.pixelspace;
			firsty = secondy;
		}
	}
	if (type == 2)
	{
		for (tuint = tuint; tuint < records; tuint++)
		{
			tfloat = get_weighted_movavg(period, tuint);
			secondy = (maxhigh - tfloat) * (current_height / range);
			gdk_draw_line (pixmap, gc, firstx, firsty, tint, secondy);
			firstx = tint;
			tint = tint + header.pixelspace;
			firsty = secondy;
		}
	}
	if (type == 3)
	{
		for (tuint = tuint; tuint < records; tuint++)
		{
			tfloat = get_exponential_movavg(period, tuint);
			secondy = (maxhigh - tfloat) * (current_height / range);
			gdk_draw_line (pixmap, gc, firstx, firsty, tint, secondy);
			firstx = tint;
			tint = tint + header.pixelspace;
			firsty = secondy;
		}
	}
}
/*************************************************************************************/
void draw_moving_average3()
{
	int tint, firstx, firsty, secondy, type, red, green, blue, period, current_height;
	unsigned int tuint;
	float tfloat = 0.0;
	GdkColor *color;
       	GdkGC *gc;
	extern float maxhigh, range;
	extern GdkPixmap *pixmap;
	extern GtkWidget *chart;
	extern unsigned int records;
	extern struct record2 header;
	extern struct record3 config;
	
	
	if (config.global_indicators)
	{
		type = config.global_moving3_type;
		period = config.global_moving3_length;
	}
	else
	{
		type = header.moving3[1];
		period = header.moving3[2];
	}
	red = config.moving3_red;
	green = config.moving3_green;
	blue = config.moving3_blue;
			
	gc = gdk_gc_new(chart->window);
	color = (GdkColor *)malloc(sizeof(GdkColor));
      	color->red = red * (65535/255);
       	color->green = green * (65535/255);
       	color->blue = blue * (65535/255);
       	gdk_color_alloc(gtk_widget_get_colormap(chart), color);
       	gdk_gc_set_foreground(gc, color);
       	
	
       	current_height = chart->allocation.height;
	tuint = period;
	firstx = period * header.pixelspace;
	tint = firstx;
	if (type == 1)
		tfloat = get_simple_movavg(period, tuint);
	if (type == 2)
		tfloat = get_weighted_movavg(period, tuint);
	if (type == 3)
		tfloat = get_exponential_movavg(period, tuint);
	firsty = (maxhigh - tfloat) * (current_height / range);
	tuint++;
	tint = tint + header.pixelspace;
	if (type == 1)
	{
		for (tuint = tuint; tuint < records; tuint++)
		{
			tfloat = get_simple_movavg(period, tuint);
			secondy = (maxhigh - tfloat) * (current_height / range);
			gdk_draw_line (pixmap, gc, firstx, firsty, tint, secondy);
			firstx = tint;
			tint = tint + header.pixelspace;
			firsty = secondy;
		}
	}
	if (type == 2)
	{
		for (tuint = tuint; tuint < records; tuint++)
		{
			tfloat = get_weighted_movavg(period, tuint);
			secondy = (maxhigh - tfloat) * (current_height / range);
			gdk_draw_line (pixmap, gc, firstx, firsty, tint, secondy);
			firstx = tint;
			tint = tint + header.pixelspace;
			firsty = secondy;
		}
	}
	if (type == 3)
	{
		for (tuint = tuint; tuint < records; tuint++)
		{
			tfloat = get_exponential_movavg(period, tuint);
			secondy = (maxhigh - tfloat) * (current_height / range);
			gdk_draw_line (pixmap, gc, firstx, firsty, tint, secondy);
			firstx = tint;
			tint = tint + header.pixelspace;
			firsty = secondy;
		}
	}
}
/************************************************************************************/
void draw()
{
	extern int chartflag;
	extern struct record2 header;
	extern struct record3 config;
	
	
    	if (chartflag == 0)
    		return;
	draw_date();
	draw_scale();
	draw_price();
	if (config.global_indicators)
	{
		if (config.global_volume_status)
			draw_volume();
	}
	else
	{
		if ((config.volume) || (header.volume))
			draw_volume();
	}
}