/*
    Copyright (C) 1998  Dennis Roddeman
    email: dennis.roddeman@uibk.ac.at

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation 
    59 Temple Place, Suite 330, Boston, MA, 02111-1307, USA
*/

#include "tochnog.h"

void viscous_stress( long int element, long int gr, double user_data[], 
  double old_unknowns[], double new_unknowns[], 
  double old_grad_old_unknowns[], double new_grad_new_unknowns[], 
  double new_sig[] )

  /* The incremental viscous stress is needed */

{
  long int swit=0, idim=0, jdim=0, ldum=0;
  double old_visc=0., new_visc=0.,
    old_laminar_sig[MDIM*MDIM], new_laminar_sig[MDIM*MDIM];

  swit = set_swit(element,-1,"viscous_stress");
  if ( swit ) pri( "In routine VISCOUS_STRESS." );

  array_set( old_laminar_sig, 0., MDIM*MDIM );
  array_set( new_laminar_sig, 0., MDIM*MDIM );

  get_group_data( GROUP_MATERI_VISCOSITY, gr, old_unknowns, &old_visc, ldum, GET_IF_EXISTS );
  get_group_data( GROUP_MATERI_VISCOSITY, gr, new_unknowns, &new_visc, ldum, GET_IF_EXISTS );
  user_viscosity( user_data, old_unknowns, old_visc );
  user_viscosity( user_data, new_unknowns, new_visc );

  for ( idim=0; idim<ndim; idim++ ) {
    for ( jdim=0; jdim<ndim; jdim++ ) {
      old_laminar_sig[idim*MDIM+jdim] = old_visc *
        ( old_grad_old_unknowns[idim*nuknwn+vel_indx+jdim*nder] +
          old_grad_old_unknowns[jdim*nuknwn+vel_indx+idim*nder] );
      new_laminar_sig[idim*MDIM+jdim] = new_visc *
        ( new_grad_new_unknowns[idim*nuknwn+vel_indx+jdim*nder] +
          new_grad_new_unknowns[jdim*nuknwn+vel_indx+idim*nder] );
    }
  }

  if ( swit ) {
    pri( "new_laminar_sig", new_laminar_sig, MDIM, MDIM );
    pri( "old_laminar_sig", old_laminar_sig, MDIM, MDIM );
  }
  array_add( new_sig, new_laminar_sig, new_sig, MDIM*MDIM );
  array_subtract( new_sig, old_laminar_sig, new_sig, MDIM*MDIM );

  if ( swit ) pri( "Out routine VISCOUS_STRESS" );
}
