\name{poly.from.zeros}
\title{Polynomial with Prescribed Zeros}
\usage{
poly.from.zeros(\dots)
}
\arguments{
\item{\dots}{One or more numeric vectors of prescribed polynomial zeros.}
}
\description{
Calculates a monic polynomial with given zeros.

All arguments are catenated and used as prescribed zeros.  Complex
conjugate zeros are allowed, the final polynomial is assumed to have
real coefficients.  This often generates a warning even though the
result is correct.
}
\value{
A polynomial whose zeros are the catenation of all arguments.  If the
same zero is prescribed more than once, it is a multiple zero of the
result.
}
\seealso{
poly.from.values, polyroot
}
\examples{
print(p5 <- poly.from.zeros(1:5))
## -120 + 274*x - 225*x^2 + 85*x^3 - 15*x^4 + x^5 
polyroot(.Last.value)
## [1] 1-4.795001e-20i 2+1.917996e-19i 3+9.863169e-19i 4-3.810907e-18i
## [5] 5+2.680741e-18i
Re(.Last.value) ## [1] 1 2 3 4 5
}
