"print.mcmc" <-
function (x, ...) 
{
        x <- as.mcmc(x)
        cat("Markov Chain Monte Carlo (MCMC) output:\nStart =", 
                start(x), "\nEnd =", end(x), "\nThinning interval =", 
                thin(x), "\nNumber of chains =", dim(x)[3], "\n\n")
        if (is.null(dimnames(x))) 
                dimnames(x) <- list(NULL, NULL, NULL)
        if (is.null(dimnames(x)[[1]])) 
                dimnames(x)[[1]] <- as.vector(time(x))
        if (is.null(dimnames(x)[[3]])) 
                dimnames(x)[[3]] <- paste("chain", 1:dim(x)[3])
        attr(x, "tspar") <- NULL
        attr(x, "class") <- NULL
        for (i in 1:dim(x)[3]) {
                cat(dimnames(x)[[3]][i], "\n\n", sep = "")
                print.default(array(x[, , i, drop = T], dim = dim(x)[1:2], 
                        dimnames = dimnames(x)[1:2]))
        }
        invisible(x)
}
