#Extractor functions for mcmc objects
#These render code a bit more legible and provide a degree of
#data abstraction

"niter" <- function(x) {
	if(is.mcmc(x))
		nrow(x)
}

"nvar" <- function(x) {
	if(is.mcmc(x))
		ncol(x)
}

"nchain" <- function(x) {
	if(is.mcmc(x))
		dim(x)[3]
}

"varnames" <- function(x) {
	if(is.mcmc(x))
		dimnames(x)[[2]]
}

"chanames" <- function(x) {
	if(is.mcmc(x))
		dimnames(x)[[3]]
}
