"geweke.plot" <-
function (x, frac1 = 0.1, frac2 = 0.5, max.bins, bin.width, auto.layout = T) 
{
        if (!missing(bin.width)) {
                if (!missing(max.bins)) 
                        nbin <- min(floor((niter(x) - 50)/bin.width), 
                                max.bins)
                else nbin <- floor((niter(x) - 50)/bin.width)
        }
        else {
                if (!missing(max.bins)) 
                        nbin <- max.bins
                else nbin <- min(floor((niter(x) - 50)/10), 50)
        }
        bin <- floor((niter(x) - 50)/nbin)
        oldpar <- NULL
        if (auto.layout) 
                oldpar <- par(mfrow = set.mfrow(Nchains = nchain(x), 
                        Nparms = nvar(x)))
        oldpar <- c(oldpar, set.scale())
        on.exit(par(oldpar))
        title.scale <- par("cex") * c(1, 0.85, 0.7)[coda.options("ps.plot")]
        scale <- par("cex") * c(1, 0.8, 0.6)[coda.options("ps.plot")]
        ystart <- seq(from = start(x), to = end(x) - 49 * thin(x), 
                by = bin)
        gcd <- array(dim = c(length(ystart), nvar(x), nchain(x)), 
                dimnames = c(ystart, varnames(x), chanames(x)))
        for (n in 1:length(ystart)) gcd[n, , ] <- geweke.diag(window(x, 
                start = ystart[n]), frac1 = frac1, frac2 = frac2)$z
        for (k in 1:nchain(x)) for (j in 1:nvar(x)) {
                ymax <- max(max(gcd[, j, k]), max(-gcd[, j, k]), 
                        2) * 1.4
                ymin <- -ymax
                plot(ystart, gcd[, j, k], type = "p", xlab = "First iteration in segment", 
                        ylab = "Z-score", cex = scale, ylim = c(ymin, 
                                ymax), pch = 4, axes = F)
                axis(1, at = pretty(ystart, 3), cex = scale, 
                        labels = format(pretty(ystart, 3)))
                par(crt = 90, srt = 90)
                axis(2, at = pretty(c(ymin, ymax), 2), cex = scale, 
                        labels = format(pretty(c(ymin, ymax), 
                                2)))
                par(crt = 0, srt = 0)
                box()
                abline(h = 1.96, lty = 2)
                abline(h = -1.96, lty = 2)
                if (dim(x)[3] > 1) {
                        title(main = paste(varnames(x)[j], " (", 
                                chanames(x)[k], ")", sep = ""), 
                                cex = title.scale)
                }
                else {
                        title(main = paste(varnames(x)[j], sep = ""), 
                                cex = title.scale)
                }
                if (!(k == nchain(x) && j == nvar(x)) && mpause2()) 
                        break
        }
        invisible(list(start.iter = ystart, z = gcd))
}
