% $Id: coef.pdCompSymm.Rd,v 1.5 1998/04/02 18:53:10 pinheiro Exp $
\name{coef.pdCompSymm}
\title{pdCompSymm Object Coefficients}
\usage{
coef(object, unconstrained)
}
\alias{coef.pdCompSymm}
\arguments{
 \item{object}{an object inheriting from class \code{pdCompSymm},
   representing a positive-definite matrix with compound symmetry
   structure.}
 \item{unconstrained}{a logical value. If \code{TRUE} the coefficients
   are returned in unconstrained form (the same used in the optimization
   algorithm). If \code{FALSE} the standard deviation and the
   correlation coefficient of the compound symmetry  of
   positive-definite matrix represented by \code{object} are
   returned. Defaults to \code{TRUE}.} 
}
\description{
  This method function extracts the coefficients associated with the
  positive-definite matrix represented by \code{object}. 
}
\value{
  a vector with the coefficients corresponding to \code{object}.
}
\author{Jose Pinheiro and Douglas Bates }

\seealso{\code{\link{coef.pdMat}}, \code{\link{pdMat}}}

\examples{
library(lme)
coef(pdCompSymm(diag(3)), F)
}
\keyword{models}
