% $Id: anova.lme.Rd,v 1.4 1998/04/06 21:35:15 pinheiro Exp $
\name{anova.lme}
\title{Compare Likelihoods of Fitted Objects}
\usage{
anova(object, ..., test, verbose)
}
\alias{anova.lme}
\alias{anova.gls}
\arguments{
 \item{object}{a fitted model object inheriting from class \code{lme} or
   class \code{gls}.}
 \item{\dots}{other optional fitted model objects inheriting from
   classes \code{gls}, \code{lm}, \code{lme}, or \code{lmList}.}
 \item{test}{an optional logical value controlling whether likelihood
   ratio tests should be used to compare the fitted models represented
   by \code{object} and the objects in \code{...}. Defaults to
   \code{TRUE}.} 
 \item{verbose}{an optional logical value. If \code{TRUE}, the calling
   sequences for each fitted model object are printed with the rest of
   the output, being omitted if \code{verbose = FALSE}. Defaults to
   \code{FALSE}.}
}
\description{
  When only one fitted model object is present, a data frame with the
  estimated values, the approximate standard errors, the z-ratios, and the
  p-values for the fixed effects is returned. Otherwise, when multiple
  fitted objects are being compared, a data frame with
  the degrees of freedom, the (restricted) log-likelihood, the 
  Akaike Information Criterion (AIC), and the Bayesian Information
  Criterion (BIC) of each object is returned. If \code{test=TRUE},
  whenever two consecutive  objects have different number of degrees of
  freedom, a likelihood ratio statistic, with the associated p-value is
  included in the returned data frame.   
}
\value{
  a data frame inheriting from class \code{anova.lme}.
}

\author{Jose Pinheiro and Douglas Bates}
\note{
  Likelihood comparisons are not meaningful for objects fit using
  restricted maximum likelihood and with different fixed effects.
}

\seealso{\code{\link{gls}}, \code{\link{lme}}, \code{\link{AIC}},
  \code{\link{BIC}}, \code{\link{print.anova.lme}} } 

\examples{
library(lme)
data(Orthodont)
fm1 <- lme(distance ~ age, Orthodont, random = ~ age | Subject)
fm2 <- update(fm1, distance ~ age * Sex)
anova(fm1, fm2)
}
\keyword{models}
