/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***********************************************************************/
/* $Id: test_data.c,v 1.1 1998/02/28 18:09:06 lance Exp $ */
#include <stdio.h>
#include <assert.h>
#include <math.h>
#include <stdlib.h>
#include <unistd.h>
#include "GNUgetopt.h"


static struct option long_options[] =
{
  {"binary", 0, 0, 'b'},
  {"number-fields", 1, 0, 'f'},
  {"number-lines", 1, 0, 'l'},
  {0, 0, 0, 0}
};

static char * short_options  = {"bf:l:"};


/* default values */
static int num_lines = 2000;
static int num_fields = 4;
static int flag = 0;

#define BINARY_OUT   1  /* binary output flag */


#define RANDOMNESS     0.0
#define SIN_AMPLITUDE  1.0

#ifndef PI /* needed for SGI IRIX */
#define PI 3.14159265358979323846
#endif
 
void get_options(int argc, char **argv)
{
  if(argc < 2)
    return;

  while (1)
    {
      int c,i;
      int option_index = 1;

      if (-1 == (c = GNUgetopt_long (argc, argv, short_options,
               long_options, &option_index)))
	break;

      switch (c)
        {
        case 'b':
          flag |= BINARY_OUT;
          break;
	case 'f':
	  i = atoi(optarg);
	  if(i<1)
	    break;
	  num_fields = i;
	  break;
	case 'l':
	  i = atoi(optarg);
	  if(i<1)
	    break;
	  num_lines = i;
	  break;
	}
    }
}

int main(int argc, char **argv)
{
  double *x,y,dx;
  int i,j;

  get_options(argc, argv);
  assert(NULL != (x = (double *) malloc(num_fields*sizeof(double))));
  srand((unsigned int) (&y));/* random seed */
  if(flag & BINARY_OUT)
    {
      i = num_fields;
      fwrite(&i,sizeof(int),1,stdout);
    }
  dx = 10.0/num_lines;
  x[0] = -1.0;
  for(i=0;i<num_lines;i++)
    {
      for(j=1;j<num_fields;j++)
	x[j] = SIN_AMPLITUDE*(0.07*sin(2.0*PI*j/num_fields + 100.0*x[0]) +
			      cos(x[0] + 
	       2.0*PI*j/num_fields)) + 
	       RANDOMNESS*rand()/RAND_MAX; /* fuNKy function to plot */
      if(flag & BINARY_OUT)
	fwrite(x,sizeof(double),num_fields,stdout);
      else
	{
	  for(j=0;j<num_fields;j++)
	    printf("%.12g ",x[j]);
	  printf("\n");
	}
      x[0] += dx;
    }
  return 0;
}
