
# line 17 "fsaparse.y"

#include <stdio.h>
#include "wa.h"
#include "yystype.h"
#include "y.tab.h"

#define MAXSTATES 100
#define MAXGENS 128

static char copyright[] =
  "Copyright (C) 1991 Mark B. Phillips, The Geometry Center";

static int adj[MAXSTATES];
static int adj_index = 0;
static int install_adjacency();

static wa *fsa;

# define FORMAT 257
# define FSA 258
# define STATES 259
# define SYMBOLS 260
# define BFS 261
# define MIN 262
# define VARIABLES 263
# define ALPHABET 264
# define START 265
# define ATABLE 266
# define INVERSES 267
# define INV 268
# define LEFT_BRACE 269
# define RIGHT_BRACE 270
# define LEFT_PAREN 271
# define RIGHT_PAREN 272
# define SEMICOLON 273
# define PERCENT 274
# define INT 275
# define EQUAL 276
# define STRING 277
# define REAL 278
#define wafsaclearin wafsachar = -1
#define wafsaerrok wafsaerrflag = 0
extern int wafsachar;
extern int wafsaerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE wafsalval, wafsaval;
typedef int wafsatabelem;
# define YYERRCODE 256

# line 161 "fsaparse.y"


wafsaerror(s)
char *s;
{
  printf("wafsaerror: %s\n");
}

static int
  install_adjacency(n)
int n;
{
  int i;

  for (i=0; i<adj_index; ++i)
    fsa->action[n][i+1] = adj[i];
}

parse_init(f)
     wa *f;
{
  fsa = f;

  fsa->fail = fsa->state = 0;
}

/*-----------------------------------------------------------------------
 * Function:	fsaparse
 * Description:	parse a .wa file into an wa struct
 * Args  IN:	fp: .wa file pointer
 *      OUT:	*fsa: the resulting fsa struct
 * Returns:	1 for success, 0 for error
 * Author:	mbp
 * Date:	Sat Mar 23 21:47:04 1991
 * Notes:	Does not recognize the full grammar defined by
 *		"Data Exchange for Automatic Groups".  Only recognizes
 *		files of the form used by several examples I was
 *		using at the time I wrote this.  I think, but am not
 *		at all sure, that this includes all word-acceptor
 *		automata.
 */
int
  fsaparse(fp, fsa)
FILE *fp;
wa *fsa;
{
  extern FILE *wafsain;
  int ret;

  parse_init(fsa);

  wafsain = fp;
  ret = wafsaparse();

  return(ret ==0);
}
wafsatabelem wafsaexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 29
# define YYLAST 81
wafsatabelem wafsaact[]={

     3,    48,    47,    53,    43,    54,    40,    42,    52,    45,
    45,    34,    39,    35,    34,    25,    17,    11,    26,    49,
    36,    29,    28,     6,    31,    22,    23,    14,    15,    16,
    10,     8,     5,     2,    44,    37,    33,    18,    12,    51,
    38,    32,    20,    19,    13,    30,     9,     7,     4,    21,
     1,     0,    24,     0,     0,     0,     0,    27,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
     0,     0,     0,     0,    46,     0,     0,     0,     0,     0,
    50 };
wafsatabelem wafsapact[]={

  -224, -1000,  -278,  -226, -1000,  -246,  -228,  -230,  -258,  -234,
  -259, -1000,  -239,  -234, -1000, -1000,  -260, -1000,  -256,  -239,
 -1000, -1000,  -247,  -248, -1000, -1000,  -242, -1000,  -261,  -262,
  -250,  -263,  -264, -1000,  -269,  -266, -1000, -1000,  -263,  -275,
 -1000, -1000,  -276, -1000,  -251,  -265, -1000,  -267, -1000, -1000,
 -1000,  -270, -1000, -1000, -1000 };
wafsatabelem wafsapgo[]={

     0,    50,    49,    48,    47,    46,    38,    37,    45,    44,
    43,    42,    41,    36,    34,    35,    40,    39 };
wafsatabelem wafsar1[]={

     0,     1,     3,     4,     5,     6,     6,     9,     9,     9,
     7,     7,    10,    10,    11,    12,    12,    13,     2,     2,
    14,    14,     8,     8,    15,    15,    16,    17,    17 };
wafsatabelem wafsar2[]={

     0,     6,    19,     5,     5,     2,     4,     2,     2,     4,
     2,     4,     2,     3,     8,     2,     4,     7,     9,    11,
     2,     4,     4,     2,     2,     4,     9,     3,     5 };
wafsatabelem wafsachk[]={

 -1000,    -1,   257,   278,    -3,   258,   269,    -4,   259,    -5,
   260,   275,    -6,    -9,   261,   262,   263,   275,    -7,   -10,
   -11,    -2,   264,   265,    -6,   275,   274,    -7,   269,   269,
    -8,   266,   -12,   -13,   275,   275,   270,   -15,   -16,   275,
   270,   -13,   276,   270,   -14,   275,   -15,   277,   277,   270,
   -14,   -17,   275,   273,   275 };
wafsatabelem wafsadef[]={

     0,    -2,     0,     0,     1,     0,     0,     0,     0,     0,
     0,     3,     0,     5,     7,     8,     0,     4,     0,    10,
    12,    13,     0,     0,     6,     9,     0,    11,     0,     0,
     0,    23,     0,    15,     0,     0,     2,    22,    24,     0,
    14,    16,     0,    18,     0,    20,    25,     0,    17,    19,
    21,     0,    27,    26,    28 };
typedef struct { char *t_name; int t_val; } wafsatoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

wafsatoktype wafsatoks[] =
{
	"FORMAT",	257,
	"FSA",	258,
	"STATES",	259,
	"SYMBOLS",	260,
	"BFS",	261,
	"MIN",	262,
	"VARIABLES",	263,
	"ALPHABET",	264,
	"START",	265,
	"ATABLE",	266,
	"INVERSES",	267,
	"INV",	268,
	"LEFT_BRACE",	269,
	"RIGHT_BRACE",	270,
	"LEFT_PAREN",	271,
	"RIGHT_PAREN",	272,
	"SEMICOLON",	273,
	"PERCENT",	274,
	"INT",	275,
	"EQUAL",	276,
	"STRING",	277,
	"REAL",	278,
	"-unknown-",	-1	/* ends search */
};

char * wafsareds[] =
{
	"-no such reduction-",
	"fsa_file : FORMAT REAL fsa_format",
	"fsa_format : FSA LEFT_BRACE states symbols fsa_characteristics info_items PERCENT fsa_table RIGHT_BRACE",
	"states : STATES INT",
	"symbols : SYMBOLS INT",
	"fsa_characteristics : fsa_characteristic",
	"fsa_characteristics : fsa_characteristic fsa_characteristics",
	"fsa_characteristic : BFS",
	"fsa_characteristic : MIN",
	"fsa_characteristic : VARIABLES INT",
	"info_items : info_item",
	"info_items : info_item info_items",
	"info_item : alphabet",
	"info_item : start_states",
	"alphabet : ALPHABET LEFT_BRACE symbol_names RIGHT_BRACE",
	"symbol_names : symbol_name",
	"symbol_names : symbol_names symbol_name",
	"symbol_name : INT EQUAL STRING",
	"start_states : START LEFT_BRACE INT RIGHT_BRACE",
	"start_states : START LEFT_BRACE INT int_list RIGHT_BRACE",
	"int_list : INT",
	"int_list : INT int_list",
	"fsa_table : ATABLE acstates",
	"fsa_table : ATABLE",
	"acstates : acstate",
	"acstates : acstate acstates",
	"acstate : INT STRING adjacency SEMICOLON",
	"adjacency : INT",
	"adjacency : adjacency INT",
};
#endif /* YYDEBUG */
/* 
 *	Copyright 1987 Silicon Graphics, Inc. - All Rights Reserved
 */


/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto wafsaerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( wafsachar >= 0 || ( wafsar2[ wafsatmp ] >> 1 ) != 1 )\
	{\
		wafsaerror( "syntax error - cannot backup" );\
		goto wafsaerrlab;\
	}\
	wafsachar = newtoken;\
	wafsastate = *wafsaps;\
	wafsalval = newvalue;\
	goto wafsanewstate;\
}
#define YYRECOVERING()	(!!wafsaerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int wafsadebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** global variables used by the parser
*/
YYSTYPE wafsav[ YYMAXDEPTH ];	/* value stack */
int wafsas[ YYMAXDEPTH ];		/* state stack */

YYSTYPE *wafsapv;			/* top of value stack */
int *wafsaps;			/* top of state stack */

int wafsastate;			/* current state */
int wafsatmp;			/* extra var (lasts between blocks) */

int wafsanerrs;			/* number of errors */
int wafsaerrflag;			/* error recovery flag */
int wafsachar;			/* current input token number */



/*
** wafsaparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
wafsaparse()
{
	register YYSTYPE *wafsapvt;	/* top of value stack for $vars */

	/*
	** Initialize externals - wafsaparse may be called more than once
	*/
	wafsapv = &wafsav[-1];
	wafsaps = &wafsas[-1];
	wafsastate = 0;
	wafsatmp = 0;
	wafsanerrs = 0;
	wafsaerrflag = 0;
	wafsachar = -1;

	goto wafsastack;
	{
		register YYSTYPE *wafsa_pv;	/* top of value stack */
		register int *wafsa_ps;		/* top of state stack */
		register int wafsa_state;		/* current state */
		register int  wafsa_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	wafsanewstate:
		wafsa_pv = wafsapv;
		wafsa_ps = wafsaps;
		wafsa_state = wafsastate;
		goto wafsa_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	wafsastack:
		wafsa_pv = wafsapv;
		wafsa_ps = wafsaps;
		wafsa_state = wafsastate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	wafsa_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( wafsadebug )
		{
			register int wafsa_i;

			printf( "State %d, token ", wafsa_state );
			if ( wafsachar == 0 )
				printf( "end-of-file\n" );
			else if ( wafsachar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( wafsa_i = 0; wafsatoks[wafsa_i].t_val >= 0;
					wafsa_i++ )
				{
					if ( wafsatoks[wafsa_i].t_val == wafsachar )
						break;
				}
				printf( "%s\n", wafsatoks[wafsa_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++wafsa_ps >= &wafsas[ YYMAXDEPTH ] )	/* room on stack? */
		{
			wafsaerror( "yacc stack overflow" );
			YYABORT;
		}
		*wafsa_ps = wafsa_state;
		*++wafsa_pv = wafsaval;

		/*
		** we have a new state - find out what to do
		*/
	wafsa_newstate:
		if ( ( wafsa_n = wafsapact[ wafsa_state ] ) <= YYFLAG )
			goto wafsadefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		wafsatmp = wafsachar < 0;
#endif
		if ( ( wafsachar < 0 ) && ( ( wafsachar = wafsalex() ) < 0 ) )
			wafsachar = 0;		/* reached EOF */
#if YYDEBUG
		if ( wafsadebug && wafsatmp )
		{
			register int wafsa_i;

			printf( "Received token " );
			if ( wafsachar == 0 )
				printf( "end-of-file\n" );
			else if ( wafsachar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( wafsa_i = 0; wafsatoks[wafsa_i].t_val >= 0;
					wafsa_i++ )
				{
					if ( wafsatoks[wafsa_i].t_val == wafsachar )
						break;
				}
				printf( "%s\n", wafsatoks[wafsa_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( wafsa_n += wafsachar ) < 0 ) || ( wafsa_n >= YYLAST ) )
			goto wafsadefault;
		if ( wafsachk[ wafsa_n = wafsaact[ wafsa_n ] ] == wafsachar )	/*valid shift*/
		{
			wafsachar = -1;
			wafsaval = wafsalval;
			wafsa_state = wafsa_n;
			if ( wafsaerrflag > 0 )
				wafsaerrflag--;
			goto wafsa_stack;
		}

	wafsadefault:
		if ( ( wafsa_n = wafsadef[ wafsa_state ] ) == -2 )
		{
#if YYDEBUG
			wafsatmp = wafsachar < 0;
#endif
			if ( ( wafsachar < 0 ) && ( ( wafsachar = wafsalex() ) < 0 ) )
				wafsachar = 0;		/* reached EOF */
#if YYDEBUG
			if ( wafsadebug && wafsatmp )
			{
				register int wafsa_i;

				printf( "Received token " );
				if ( wafsachar == 0 )
					printf( "end-of-file\n" );
				else if ( wafsachar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( wafsa_i = 0;
						wafsatoks[wafsa_i].t_val >= 0;
						wafsa_i++ )
					{
						if ( wafsatoks[wafsa_i].t_val
							== wafsachar )
						{
							break;
						}
					}
					printf( "%s\n", wafsatoks[wafsa_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *wafsaxi = wafsaexca;

				while ( ( *wafsaxi != -1 ) ||
					( wafsaxi[1] != wafsa_state ) )
				{
					wafsaxi += 2;
				}
				while ( ( *(wafsaxi += 2) >= 0 ) &&
					( *wafsaxi != wafsachar ) )
					;
				if ( ( wafsa_n = wafsaxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( wafsa_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( wafsaerrflag )
			{
			case 0:		/* new error */
				wafsaerror( "syntax error" );
				goto skip_init;
			wafsaerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				wafsa_pv = wafsapv;
				wafsa_ps = wafsaps;
				wafsa_state = wafsastate;
				wafsanerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				wafsaerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( wafsa_ps >= wafsas )
				{
					wafsa_n = wafsapact[ *wafsa_ps ] + YYERRCODE;
					if ( wafsa_n >= 0 && wafsa_n < YYLAST &&
						wafsachk[wafsaact[wafsa_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						wafsa_state = wafsaact[ wafsa_n ];
						goto wafsa_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( wafsadebug )
						printf( _POP_, *wafsa_ps,
							wafsa_ps[-1] );
#	undef _POP_
#endif
					wafsa_ps--;
					wafsa_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( wafsadebug )
				{
					register int wafsa_i;

					printf( "Error recovery discards " );
					if ( wafsachar == 0 )
						printf( "token end-of-file\n" );
					else if ( wafsachar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( wafsa_i = 0;
							wafsatoks[wafsa_i].t_val >= 0;
							wafsa_i++ )
						{
							if ( wafsatoks[wafsa_i].t_val
								== wafsachar )
							{
								break;
							}
						}
						printf( "token %s\n",
							wafsatoks[wafsa_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( wafsachar == 0 )	/* reached EOF. quit */
					YYABORT;
				wafsachar = -1;
				goto wafsa_newstate;
			}
		}/* end if ( wafsa_n == 0 ) */
		/*
		** reduction by production wafsa_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( wafsadebug )
			printf( "Reduce by (%d) \"%s\"\n",
				wafsa_n, wafsareds[ wafsa_n ] );
#endif
		wafsatmp = wafsa_n;			/* value to switch over */
		wafsapvt = wafsa_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using wafsa_state here as temporary
		** register variable, but why not, if it works...
		** If wafsar2[ wafsa_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto wafsa_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int wafsa_len = wafsar2[ wafsa_n ];

			if ( !( wafsa_len & 01 ) )
			{
				wafsa_len >>= 1;
				wafsaval = ( wafsa_pv -= wafsa_len )[1];	/* $$ = $1 */
				wafsa_state = wafsapgo[ wafsa_n = wafsar1[ wafsa_n ] ] +
					*( wafsa_ps -= wafsa_len ) + 1;
				if ( wafsa_state >= YYLAST ||
					wafsachk[ wafsa_state =
					wafsaact[ wafsa_state ] ] != -wafsa_n )
				{
					wafsa_state = wafsaact[ wafsapgo[ wafsa_n ] ];
				}
				goto wafsa_stack;
			}
			wafsa_len >>= 1;
			wafsaval = ( wafsa_pv -= wafsa_len )[1];	/* $$ = $1 */
			wafsa_state = wafsapgo[ wafsa_n = wafsar1[ wafsa_n ] ] +
				*( wafsa_ps -= wafsa_len ) + 1;
			if ( wafsa_state >= YYLAST ||
				wafsachk[ wafsa_state = wafsaact[ wafsa_state ] ] != -wafsa_n )
			{
				wafsa_state = wafsaact[ wafsapgo[ wafsa_n ] ];
			}
		}
					/* save until reenter driver code */
		wafsastate = wafsa_state;
		wafsaps = wafsa_ps;
		wafsapv = wafsa_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( wafsatmp )
	{
		
case 2:
# line 60 "fsaparse.y"
{ return(0); } break;
case 3:
# line 64 "fsaparse.y"
{
		      fsa->nstates = wafsapvt[-0].i;
		      fsa->action =
			(int**)malloc((fsa->nstates+1)*sizeof(int*));
		    } break;
case 4:
# line 72 "fsaparse.y"
{
		      int i,j;
		      fsa->ngens = wafsapvt[-0].i;
		      for (i=0; i<=fsa->nstates; ++i) {
			fsa->action[i] =
			  (int*)malloc((fsa->ngens+1)*sizeof(int));
			for (j=0; j<=fsa->ngens; ++j)
			  fsa->action[i][j] = 0;
		      }
		      fsa->genlist=(char**)malloc(fsa->ngens*sizeof(char*));
		      for (i=0; i<fsa->ngens; ++i)
			fsa->genlist[i] = "";
		    } break;
case 13:
# line 106 "fsaparse.y"
{
		      fsa->start= wafsapvt[-0].i;
		    } break;
case 17:
# line 119 "fsaparse.y"
{
		      fsa->genlist[wafsapvt[-2].i-1] =
			(char*)malloc((strlen(wafsapvt[-0].s)+1)*sizeof(char));
		      strcpy(fsa->genlist[wafsapvt[-2].i-1], wafsapvt[-0].s);
		    } break;
case 18:
# line 127 "fsaparse.y"
{ wafsaval.i = wafsapvt[-1].i; } break;
case 19:
# line 129 "fsaparse.y"
{ wafsaval.i = wafsapvt[-2].i; } break;
case 26:
# line 147 "fsaparse.y"
{ install_adjacency(wafsapvt[-3].i); adj_index = 0; } break;
case 27:
# line 151 "fsaparse.y"
{
		    adj[adj_index++] = wafsapvt[-0].i;
		  } break;
case 28:
# line 155 "fsaparse.y"
{
		    adj[adj_index++] = wafsapvt[-0].i;
		  } break;
	}
	goto wafsastack;		/* reset registers in driver code */
}
