/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "mgopengl.h"

#ifdef GLUT
# include <GL/glut.h>
#else
# include <GL/gl.h>
# include <GL/glu.h>
# include <GL/glx.h>
#endif


enum { SGL=0, DBL=1 };

typedef struct mgopenglcontext {
  struct mgcontext mgctx;	/* The mgcontext */
  int born;			/* Has window been displayed on the screen? */
  int win;			/* GL window ID, or 0 */
  double zmin, zmax;		/* max z-buffer value */
  ColorA Cd;			/* Cached diffuse color = mat->diffuse * Kd */
  int lmcolor;			/* lmcolor: GL_DIFFUSE or XXX lmc_COLOR */

  double znudge;		/* _mgc.zfnudge in integer Z-buffer units */
  double znear, zfar;		/* Current Z-buffer glDepthRange(, $2) limits */
  int oldopts;			/* For knowing when we need to reconfigure */
  vvec room;			/* Scratch space */
#ifdef _WIN32

  short used4f;			/* Windows VC++ doesn't like us to use the */
  short useevn3f; 		/* above function pointers. Use flags instead.*/

#  define D4F_ON()	_mgopenglc->used4f = 1
#  define D4F_OFF()	_mgopenglc->used4f = 0
#  define D4F(c)   {	if(_mgopenglc->used4f) mgopengl_d4f(c); \
			else glColor4fv(c); \
		   }
#  define N3F_NOEVERT()	_mgopenglc->useevn3f = 0
#  define N3F_EVERT()	_mgopenglc->useevn3f = 1
#  define N3F(n,p) {	if(_mgopenglc->useevn3f) mgopengl_n3fevert(n,p); \
			else glNormal3fv(n); \
		   }

#else /* use function pointers if the compiler permits */

  void (*d4f)();		/* For shaded colors: apply mat.kd or no? */
  void (*n3f)();		/* Evert normals to face viewer? */
#  define D4F_ON()	_mgopenglc->d4f = mgopengl_d4f
#  define D4F_OFF()	_mgopenglc->d4f = glColor4fv
#  define D4F(c)	(*_mgopenglc->d4f)(c)
#  define N3F_EVERT()	_mgopenglc->n3f = mgopengl_n3fevert
#  define N3F_NOEVERT()	_mgopenglc->n3f = glNormal3fv
#  define N3F(n,p)	(*_mgopenglc->n3f)(n,p)

#endif

#ifndef GLUT
  void *GLXdisplay;		/* X11 Display pointer; if non-NULL, mixed model */
  GLXContext cam_ctx[2];	/* single[0] and double-buf[1] OGL contexts */
  GLXContext curctx;		/* Current OpenGL context */
#endif
  int winids[2];		/* single[0] and double-buffered[1] X win ids */
  int should_lighting, is_lighting; /* Lighting flags so we can turn off
					lighting for points&lines */
  int tevbound;                 /* Texturing currently enabled? */
  TxUser *curtex;              /* Currently-bound texture (NULL if none) */
  int dither;			/* Dither enabled? */
  TxUser *bgimage;		/* Background image (not really a texture) */
} mgopenglcontext;


#define	MAXZNUDGE	8	/* Max possible depth of mgopengl_closer()/farther() calls */

/* We save the current W2C/C2W xforms on each call to mgopengl_worldbegin()
 * because the ModelView matrix stack actually stores both our object
 * xform and the view matrix:
 *
 *   ModelView = [ obj xform ] * [ W2C ]
 *
 * Since we use the GL ModelView stack to keep track of our object xform,
 * instead of using the actual stack in the mgcontext struct, having
 * ModelView = W2C corresponds to [ obj xform ] = identity.  We save W2C
 * and C2W on each mgopengl_worldbegin() because _mgc->cam might change
 * during the course of the frame, but isn't supposed to be reinterpreted
 * until the next mgopengl_worldbegin().
 */

#define _mgopenglc		((mgopenglcontext*)_mgc)

extern void mgopengl_d4f( float c[4] );
extern void mgopengl_n3fevert( Point3 *n, HPoint3 *p );

extern void mgopengl_notexture(void);
extern void mgopengl_needtexture(void);
extern void mgopengl_closer(void);
extern void mgopengl_farther(void);
extern void mgopengl_setshader(mgshadefunc shader);
extern void mgopengl_drawnormal(HPoint3 *p, Point3 *n);
extern void mgopengl_init_zrange();
extern void mgopengl_v4fcloser(HPoint3 *);
extern void mgopengl_txpurge(TxUser *);
extern void mgopengl_lights(LmLighting *lm, struct mgastk *astk);

#ifdef _WIN32
extern void mgopengl_c4f(float *);
extern void mgopengl_n3f(float *);
#else
#define mgopengl_c4f glColor4fv
#define mgopengl_n3f glNormal3fv
#endif

#define	MAY_LIGHT()  { \
	if(_mgopenglc->should_lighting && !_mgopenglc->is_lighting) { \
	    glEnable(GL_LIGHTING); \
	    _mgopenglc->is_lighting = 1; \
	} }

#define DONT_LIGHT() { \
	    if(_mgopenglc->is_lighting) { \
		glDisable(GL_LIGHTING); \
		_mgopenglc->is_lighting = 0; \
	    } \
	}
