/* Copyright (c) 1994 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Author: Timothy Rowley */

/* {{{ Includes */

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include "mgP.h"
#include "mgbufP.h"

/* }}} */

static endPoint *mug=NULL;
static mugSize = 0;

static int rshift, bshift, gshift;

#ifdef __GNUC__
inline
#endif
static int
RGBtoVal(int r, int g, int b)
{
    return ((r << rshift) | (g << gshift) | (b << bshift));
}

static int
maskShift(int mask)
{
    switch (mask)
    {
    case 0xFF000000U:
	return 24;
    case 0xFF0000U:
	return 16;
    case 0xFF00U:
	return 8;
    case 0xFFU:
	return 0;
    default:
	return 32;
    }
}

void
Xmgr_24fullinit(int rmask, int gmask, int bmask)
{
    rshift = maskShift(rmask);
    gshift = maskShift(gmask);
    bshift = maskShift(bmask);
}

/* {{{ clearing routine */

void
Xmgr_24clear(unsigned char *buf, float *zbuf, int zwidth, 
	     int width, int height, int *color, int flag,
	     int fullclear, int xmin, int ymin, int xmax, int ymax)
{
    int *ptr = (int *)buf;
    int i, fill, end, x, length, pos;
    fill = RGBtoVal(color[0], color[1], color[2]);

    if (mug==NULL)
    {
	mug = (endPoint *)malloc(sizeof(endPoint)*height);
	mugSize = height;
    }
    if (height>mugSize)
    {
	mug = (endPoint *)realloc(mug, sizeof(endPoint)*height);
	mugSize = height;
    }

    if (fullclear)
    {
	end = (width*height)/4;
	for (i=0; i<end; i++)
	    ptr[i] = fill;
	
	if (flag)
	    for (i=0; i<zwidth*height; i++)
		zbuf[i] = 1.0;
    }

    xmin = MAX(xmin,0);
    length = (MIN(zwidth-1,xmax)-xmin+1);
    ymin = MAX(ymin,0);
    ymax = MIN(height-1,ymax);
    for (i=ymin; i<=ymax; i++)
    {
	ptr = (int *)(buf+width*i+xmin*4);
	for (x=0; x<length; x++)
	    ptr[x] = fill;
    }
    length = MIN(zwidth-1,xmax)-xmin+1; 
    if (flag)
	for (i=ymin; i<=ymax; i++)
	{
	    pos = i*zwidth+xmin;
	    for (x=0; x<length; x++)
	        zbuf[pos+x] = 1.0;
	}
}

/* }}} */

/* {{{ single lines */

#define WIDENAME wideline
#define NAME Xmgr_24line
#define PTR_INCR width>>2
#define PTR_TYPE int
#define PTR_INIT (int *)(buf+y1*width+4*x1)
#define WIDEYDOPIXEL ptr[i*ptrIncr+x] = col;
#define WIDEXDOPIXEL ptr[y*ptrIncr+i] = col;
#define DOPIXEL *ptr = col;
#define VARIABLES int col = RGBtoVal(color[0], color[1], color[2]);
#include "MGRline.h"


#define WIDENAME wideZline
#define NAME Xmgr_24Zline
#define PTR_INCR width>>2
#define ZBUFFER
#define PTR_TYPE int
#define PTR_INIT (int *)(buf+y1*width+4*x1)
#define WIDEYDOPIXEL ptr[i*ptrIncr+x] = col;
#define WIDEXDOPIXEL ptr[y*ptrIncr+i] = col;
#define DOPIXEL *ptr = col;
#define VARIABLES int col = RGBtoVal(color[0], color[1], color[2]);
#include "MGRline.h"


#define WIDENAME wideGline
#define NAME Xmgr_24Gline
#define PTR_INCR width>>2
#define GOURAUD
#define COLOR
#define PTR_TYPE int
#define PTR_INIT (int *)(buf+y1*width+4*x1)
#define WIDEYDOPIXEL ptr[i*ptrIncr+x] =  RGBtoVal(r, g, b);
#define WIDEXDOPIXEL ptr[y*ptrIncr+i] =  RGBtoVal(r, g, b);
#define DOPIXEL *ptr =  RGBtoVal(r, g, b);
#include "MGRline.h"


#define WIDENAME wideGZline
#define NAME Xmgr_24GZline
#define PTR_INCR width>>2
#define ZBUFFER
#define GOURAUD
#define COLOR
#define PTR_TYPE int
#define PTR_INIT (int *)(buf+y1*width+4*x1)
#define WIDEYDOPIXEL ptr[i*ptrIncr+x] =  RGBtoVal(r, g, b);
#define WIDEXDOPIXEL ptr[y*ptrIncr+i] =  RGBtoVal(r, g, b);
#define DOPIXEL *ptr =  RGBtoVal(r, g, b);
#include "MGRline.h"

/* }}} */

/* {{{ polygon scan conversion */

#define INIT (int *)(buf+width*y+x1*4)

#define NAME Xmgr_doLines
#define PTR_TYPE int
#define PTR_INIT INIT
#define VARIABLES int col=RGBtoVal(color[0], color[1], color[2]);
#define DOPIXEL *ptr = col;
#include "MGRdolines.h"

#define NAME Xmgr_ZdoLines
#define ZBUFFER
#define PTR_TYPE int
#define PTR_INIT INIT
#define VARIABLES int col=RGBtoVal(color[0], color[1], color[2]);
#define DOPIXEL *ptr = col;
#include "MGRdolines.h"

#define NAME Xmgr_GdoLines
#define PTR_TYPE int
#define PTR_INIT INIT
#define DOPIXEL *ptr = RGBtoVal(r,g,b);
#define GOURAUD
#define COLOR
#include "MGRdolines.h"

#define NAME Xmgr_GZdoLines
#define ZBUFFER
#define PTR_TYPE int
#define PTR_INIT INIT
#define DOPIXEL *ptr = RGBtoVal(r,g,b);
#define GOURAUD
#define COLOR
#include "MGRdolines.h"

void
Xmgr_24Zpoly(unsigned char *buf, float *zbuf, int zwidth,
	     int width, int height, CPoint3 *p, int n, int *color)
{
    Xmgr_Zpolyscan(buf, zbuf, zwidth, width, height, p, n, color, mug,
		   Xmgr_ZdoLines);
}

void
Xmgr_24poly(unsigned char *buf, float *zbuf, int zwidth, 
	    int width, int height, CPoint3 *p, int n, int *color)
{
    Xmgr_polyscan(buf, zbuf, zwidth, width, height, p, n, color, mug,
		  Xmgr_doLines);
}

void
Xmgr_24GZpoly(unsigned char *buf, float *zbuf, int zwidth, int width, int height,
	     CPoint3 *p, int n, int *dummy)
{
    Xmgr_GZpolyscan(buf, zbuf, zwidth, width, height, p, n, dummy, mug,
		    Xmgr_GZdoLines);
}

void
Xmgr_24Gpoly(unsigned char *buf, float *zbuf, int zwidth, int width, int height,
	     CPoint3 *p, int n, int *dummy)
{
    Xmgr_Gpolyscan(buf, zbuf, zwidth, width, height, p, n, dummy, mug,
		    Xmgr_GdoLines);
}

/* }}} */

/* {{{ multi-line scan conversion */

#ifdef __GNUC__
inline
#endif
static void
setZpixel(unsigned char *buf, float *zbuf, int zwidth, 
	  int width, int height, CPoint3 *p, int *color)
{
    if (p->z < zbuf[(int)(p->y)*zwidth+(int)p->x])
	((int *)buf)[(int)(p->y)*(width/4)+(int)p->x] = 
	    RGBtoVal(color[0], color[1], color[2]);
}

#ifdef __GNUC__
inline
#endif
static void
setpixel(unsigned char *buf, int zwidth, 
	  int width, int height, CPoint3 *p, int *color)
{
    ((int *)buf)[(int)(p->y)*(width/4)+(int)p->x] = 
	RGBtoVal(color[0], color[1], color[2]);
}

void
Xmgr_24polyline(unsigned char *buf, float *zbuf, int zwidth, int width, int height, 
		CPoint3 *p, int n, int lwidth, int *color)
{
    int i;
    CPoint3 *cp;

    if (n == 1)
    {
	setpixel(buf, zwidth, width, height, p, color);
	return;
    }

    for (i=0, cp=p; i<n-1; i++, cp++)
	if (cp->drawnext)
	    Xmgr_24line(buf, zbuf, zwidth, width, height, cp, cp+1,
			 lwidth, color);
}


void
Xmgr_24Zpolyline(unsigned char *buf, float *zbuf, int zwidth, int width, int height, 
		 CPoint3 *p, int n, int lwidth, int *color)
{
    int i;
    CPoint3 *cp;

    if (n == 1)
    {
	setZpixel(buf, zbuf, zwidth, width, height, p, color);
	return;
    }

    for (i=0, cp=p; i<n-1; i++)
	if (cp->drawnext)
	    Xmgr_24Zline(buf, zbuf, zwidth, width, height, cp, cp+1,
			 lwidth, color);
}


void
Xmgr_24Gpolyline(unsigned char *buf, float *zbuf, int zwidth, int width, int height, 
		 CPoint3 *p, int n, int lwidth, int *color)
{
    int i;
    CPoint3 *cp;

    if (n == 1)
    {
	setpixel(buf, zwidth, width, height, p, color);
	return;
    }

    for (i=0, cp=p; i<n-1; i++, cp++)
	if (cp->drawnext)
	    Xmgr_gradWrapper(buf, zbuf, zwidth, width, height, cp, cp+1,
			     lwidth, Xmgr_24line, Xmgr_24Gline);
}


void
Xmgr_24GZpolyline(unsigned char *buf, float *zbuf, int zwidth, int width, int height, 
		 CPoint3 *p, int n, int lwidth, int *color)
{
    int i;
    CPoint3 *cp;

    if (n == 1)
    {
	setZpixel(buf, zbuf, zwidth, width, height, p, color);
	return;
    }

    for (i=0, cp=p; i<n-1; i++, cp++)
	if (cp->drawnext)
	    Xmgr_gradWrapper(buf, zbuf, zwidth, width, height, cp, cp+1,
			     lwidth, Xmgr_24Zline, Xmgr_24GZline);
}

/* }}} */

/*
Local variables:
folded-file: t
*/

