/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */
static char *copyright = "Copyright (C) 1992 The Geometry Center";

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "quadP.h"

Quad *
QuadCreate (exist, classp, a_list)
    Quad *exist;
    GeomClass *classp;
    va_list a_list;
{
    register Quad *q;
    QuadP *p = (QuadP *)NULL;
    Point3 *p3;
    QuadN *n = (QuadN *)NULL;
    QuadC *c = (QuadC *)NULL;
    int attr;
    int copy = 1, fourd = 0;
    int i,j;

    if (exist == NULL) {
	q = OOGLNewE(Quad, "QuadCreate: new Quad");
        GGeomInit (q, classp, QUADMAGIC, NULL);
	q->flag = q->maxquad = 0;
        q->p = (QuadP *)NULL;
        q->n = (QuadN *)NULL;
        q->c = (QuadC *)NULL;
    } else {
	/* Check that exist is a Quad. */
	q = exist;
    }

    while (attr = va_arg(a_list, int))   /* parse argument list */
      switch (attr) {
	case CR_FLAG:
            q->flag = va_arg(a_list, int);
	    break;

	case CR_NELEM:
	    q->maxquad = va_arg(a_list, int);
	    break;

	case CR_POINT4:
	    p = va_arg(a_list, QuadP *);
            if (exist) OOGLFree(q->p);
            if (p == NULL) {
               q->p = NULL;
               q->maxquad = 0;
            } else if (copy) {
		q->p = OOGLNewNE(QuadP,q->maxquad,"QuadCreate vertices");
		memcpy(q->p, p, q->maxquad * sizeof(QuadP));
            } else {
		q->p = p; /* caller relinquishes ownership of data */
	    }
	    break;

	case CR_POINT:
	    p3 = va_arg(a_list, Point3 *);
            if (exist) OOGLFree(q->p);
            if (p3 == NULL) {
               q->p = NULL;
               q->maxquad = 0;
            } else if (copy) {
		q->p = OOGLNewNE(QuadP,q->maxquad,"QuadCreate vertices");
		Pt3ToPt4(p3, &q->p[0][0], q->maxquad * 4);
            } else {
		Pt3ToPt4(p3, &q->p[0][0], q->maxquad * 4);
	    }
	    break;

	case CR_NORMAL:
	    n = va_arg(a_list, QuadN *);
            if (exist && q->n) OOGLFree(q->n);
	    if (n == NULL) {
		q->n = NULL;
            } else if (copy) {
		q->n = OOGLNewNE(QuadN,q->maxquad,"QuadCreate normals");
		memcpy(q->n, n, q->maxquad*sizeof(QuadN));
            } else
		q->n = n;
            q->flag |= QUAD_N;
	    break;

	case CR_COLOR:
	    c = va_arg(a_list, QuadC *);
            if (exist && q->c) OOGLFree(q->c);
	    if (c == NULL) {
               q->c = NULL;
            } else if (copy) {
		q->c = OOGLNewNE(QuadC, q->maxquad, "QuadCreate: colors");
		memcpy(q->c, c, q->maxquad*sizeof(QuadC));
            }
            else q->c = c;
            q->flag |= QUAD_C;
	    break;

	default:
            if (GeomDecorate(q, &copy, attr, &a_list)) {
	       OOGLError (0, "QuadCreate: Undefined option: %d",attr);
	       if (!exist) GeomDelete((Geom *)q);
	       return NULL;
            }
      }

    if (q->p == NULL && q->maxquad > 0 ||
        q->p != NULL && q->maxquad <= 0) {
	OOGLError (0,"QuadCreate: inconsistent number of quads");
	if (!exist) GeomDelete((Geom *)q);
	return NULL;
    }

    /* compute the value that flag should have */
    if(n == NULL) q->flag &= ~QUAD_N;
    if(c == NULL) q->flag &= ~QUAD_C;

    return (Quad *) q;
}
