/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/*
 * Save a PolyList (in .off format).
 */

#include "npolylistP.h"

NPolyList *
NPolyListFSave(pl, outf, fname)
	register NPolyList *pl;	/* Thing to save */
	FILE *outf;			/* Stream to save it on */
	char *fname;			/* File name for error msgs */
{
	int i, k, n;
	NPoly *p;
	float *v;
	ColorA *c;

	/* We don't really know the number of edges and it's a pain to count.
	 * Assume Euler number 2.
	 */
	fprintf(outf, "%s%snOFF %d\n%d %d %d\n",
		&"C"[pl->flags & PL_HASVCOL ? 0 : 1],
		&"4"[pl->geomflags & VERT_4D ? 0 : 1],
		pl->pdim - (pl->geomflags & VERT_4D ? 0 : 1),
		pl->n_verts, pl->n_polys,
		0);

	for(i = pl->n_verts, v = pl->v, c = pl->vcol; --i >= 0; ) {
	  if(pl->geomflags & VERT_4D) {
	    for(k = pl->pdim; --k >= 0; )
		fprintf(outf, "%g ", *v++);
	  } else {
	    float denom = v[pl->pdim-1];
	    for(k = pl->pdim; --k > 0; )
		fprintf(outf, "%g ", *v++/denom);
	    v++;
	  }
	  if(pl->flags & PL_HASVCOL) {
	    fprintf(outf, "  %g %g %g %g", c->r, c->g, c->b, c->a);
	    c++;
	  }
	  fputc('\n', outf);
	}

	fputc('\n', outf);
	for(i = pl->n_polys, p = pl->p; --i >= 0; p++) {
	    fprintf(outf, "\n%d	", p->n_vertices);
	    for(k = 0; k < p->n_vertices; k++)
		fprintf(outf, " %d", pl->vi[p->vi0 + k]);
	    if((pl->flags & (PL_HASPCOL|PL_HASVCOL)) == PL_HASPCOL) {
		fprintf(outf, "\t%g %g %g %g",
			p->pcol.r, p->pcol.g, p->pcol.b, p->pcol.a);
	    }
	}
	fputc('\n', outf);

	return (ferror(outf) ? NULL : pl);
}
