/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "meshP.h"

Mesh           *
MeshEvert(m)
Mesh           *m;
{
	int i;
	Point3 *n;

	if (m)
	     {
		     if (m->flag & MESH_EVERT)
			  m->flag &= ~MESH_EVERT;
		     else
			  m->flag |= MESH_EVERT;
		     if (m->flag & MESH_N) {
			     for (i = 0, n = m->n; i < m->nu*m->nv; i++,n++){
				     n->x = -n->x;
				     n->y = -n->y;
				     n->z = -n->z;
			     }
		     } else {
			     MeshComputeNormals(m);
		     }
	     }
}
