/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "bboxP.h"

BBox *
BBoxBound(bbox, T)
	BBox	*bbox;
	Transform T;
{
	if(bbox == NULL)
		return NULL;

	if(T == NULL || T == TM_IDENTITY)
		return (BBox *) GeomCopy((Geom *)bbox);	/* entirely trivial! */

	return BBoxTransform((BBox *)GeomCopy((Geom *)bbox), T);
}

BBox *
BBox_ND_hack(BBox *b, float *p, int nfloats)
{
    float vmin, vmax;

    if(nfloats <= 0)
	return b;
    if(b == NULL) {
	b = (BBox *)GeomCCreate(NULL, BBoxMethods(), CR_END);
	vmin = vmax = *p++;
	nfloats--;
    } else {
	vmin = b->min.x;
	vmax = b->max.x;
    }
    for( ; --nfloats >= 0; p++) {
	if(vmin > *p) vmin = *p;
	if(vmax < *p) vmax = *p;
    }
    b->min.x = b->min.y = b->min.z = vmin;
    b->max.x = b->max.y = b->max.z = vmax;
    b->min.w = b->max.w = 1;
    return b;
}
