/*
 * cmodel.h: declarations for functions dealing with
 *    conformal model of hyperbolic or spherical space
 */


#ifndef PMODEL_H

#include "polylistP.h"
#include "vectP.h"
#include "meshP.h"
#include "quadP.h"

void set_cm_refine(double cosmaxbend, int maxrefine, int show_subdivision);

void cmodel_clear(int space);
void cm_read_polylist(PolyList *polylist);
void cm_read_vect(Vect *v);
void cm_read_quad(Quad *q);
void cmodel_draw(int plflags);
void cm_draw_mesh(Mesh *m);

#endif
