#include "mibload.h"
#include "../common/drawer.h"
#include "../common/ui.h"
#include "gvui.h"

static /* prefix to ``char Root[]...'' */
#include "interface/Material.mib"

/* private methods and variables */
/*****************************************************************************/

static void matt_sliders(Widget, XtPointer, XmScaleCallbackStruct *);
static void matt_entries(Widget w, XtPointer data, XmAnyCallbackStruct *cbs);
extern void ap_toggle(Widget w, XtPointer data, XmToggleButtonCallbackStruct *cbs);
extern void set_ap_toggle(Widget w, int *current, Appearance *ap, int flagbit);

static Widget shell,
	TransparentToggle;

static struct _slider {
   float min, max;
   int  val;
   int mtcode;
   char *slidername, *textname;
   Widget sliderw, textw;
   float lastval;
} sliders[] = {
  { 1.0, 128.0, DRAWER_SHININESS, MT_SHININESS, "ShininessScale", "ShininessText" },
  { 0.0, 1.0,	DRAWER_KS, MT_Ks,	  "SpecularScale", "SpecularText" },
  { 0.0, 1.0,	DRAWER_KD, MT_Kd,	  "DiffuseScale", "DiffuseText" },
  { 0.0, 1.0,	DRAWER_KA, MT_Ka,	  "AmbientScale", "AmbientText" },
  { 0.0, 1.0,	DRAWER_ALPHA, MT_ALPHA,	  "AlphaScale", "AlphaText" },
};

#define		S_SHINY		0
#define		S_SPECULAR	1
#define		S_DIFFUSE	2
#define		S_AMBIENT	3
#define		S_ALPHA		4

/*****************************************************************************/

void ui_load_materialpanel()
{
  int	     i;
  struct _slider *s;
  Widget     mattform,
	     HideButton;

  mib_Widget *mattload;
  Atom       AProtocol;
  static char Material[] = "Material";

/*****************************************************************************/

  shell = ui_make_panel_and_form(Material, Root, False,
		&mattform);

/*mattload = mib_load_interface(mattform, "interface/Material.mib",
		MI_FROMFILE);*/
  mattload = mib_load_interface(mattform, Root,
		MI_FROMSTRING);
 
  XtManageChild(mattform);

/*****************************************************************************/

  HideButton = mib_find_name(mattload, "HideButton")->me;
  TransparentToggle = mib_find_name(mattload, "TransparentToggle")->me;
  XtAddCallback(HideButton, XmNactivateCallback, (XtCallbackProc) ui_hide,
		(XtPointer) Material);

  for(i = 0, s = sliders; i < COUNT(sliders); i++, s++) {
    s->sliderw = mib_find_name(mattload, s->slidername)->me;
    s->textw = mib_find_name(mattload, s->textname)->me;
    XtAddCallback(s->sliderw, XmNdragCallback,
		(XtCallbackProc) matt_sliders, (XtPointer) i);
    XtAddCallback(s->sliderw, XmNvalueChangedCallback,
		(XtCallbackProc) matt_sliders, (XtPointer) i);
    XtAddCallback(s->textw, XmNactivateCallback,
		(XtCallbackProc) matt_entries, (XtPointer) i);
    XtAddCallback(s->textw, XmNlosingFocusCallback,
		(XtCallbackProc) matt_entries, (XtPointer) i);
  }
  XtAddCallback(TransparentToggle, XmNvalueChangedCallback,
		  (XtCallbackProc) ap_toggle,
		  (XtPointer)DRAWER_TRANSPARENT);

}


/*****************************************************************************/

static void matt_sliders(Widget w, XtPointer data, XmScaleCallbackStruct *cbs)
{
  struct _slider *s = &(sliders[(int)data]);
  float val = (float)cbs->value;
  float conv = ((s->max - s->min)/100.0)*val + s->min;

  drawer_float(GEOMID(uistate.targetgeom), s->val, conv);
  s->lastval = conv;
  ui_set_ftext(s->textw, conv);
}

static void matt_entries(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  struct _slider *s = &sliders[(int)data];
  char *str = XmTextFieldGetString(s->textw);
  char *estr;
  float val = strtod(str, &estr);

  if(*str != '\0' && *estr == '\0') {
    if(fabs(s->lastval - val) > .001) {
	XmScaleSetValue(s->sliderw, (int)(100.0*(val - s->min)/(s->max - s->min)));
	s->lastval = val;
    }
  } else {
    ui_set_ftext(s->textw, s->lastval);
  }
}

/*****************************************************************************/

void ui_target_materialpanel(int id)
{
  int		i;
  double      val;
  int         conv;
  DGeom      *dg;
  Appearance *ap;
  Material *mt = NULL;
  struct _slider *s;

  if ((dg = (DGeom *)drawer_get_object(id)))
  {
    ap = drawer_get_ap(id);
    ApGet(ap, AP_MAT, &mt);
   
    set_ap_toggle(TransparentToggle, &i, ap, APF_TRANSP);
    if(mt == NULL)
	return;
    for(i = 0; i < COUNT(sliders); i++) {
	s = &sliders[i];
	if(MtGet(mt, s->mtcode, &val) > 0) {
	    conv = (int)(100.0*(val - s->min)/(s->max - s->min));
	    XmScaleSetValue(s->sliderw, conv);
	    ui_set_ftext(s->textw, val);
	    s->lastval = val;
	}
    }
  }
}

/*****************************************************************************/
