/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef WINDOWDEF
#define WINDOWDEF

#include <stdio.h>
#include "reference.h"

#include "ooglutil.h"
#include "streampool.h"

typedef struct {
	int xmin, xmax, ymin, ymax;
} WnPosition;

typedef struct WnWindow WnWindow;

/* Public WnWindow methods: */

extern WnWindow *WnCreate(int firstattr, ... /*, WN_END */);
extern WnWindow *WnSet(WnWindow *, int firstattr, ... /*, WN_END */);
extern int	 WnGet(WnWindow *, int attr, void *value);
extern void	 WnDelete(WnWindow *);
extern WnWindow *WnCopy(WnWindow *);
extern WnWindow *WnMerge(WnWindow *src, WnWindow *dst);

extern int WnStreamOut( Pool *, Handle *, WnWindow * );

/*
 * Attributes for WnCreate(), WnSet(), WnGet().
 *
 * Supplying a NULL pointer, or -1 value, for one of these
 * unsets the corresponding value.
 * 
 * Initially, all values are unset.
 *
 * WnGet()'s returned value
 *	on an invalid token is -1
 *	on an unset value is 0
 *	on a  set value is 1
 */
				/* Set/Create type	Get type	*/
#define	WN_END		900	/* ---------------	--------	*/
#define WN_XSIZE	901	/* int			int *		*/
#define WN_YSIZE	902	/* int			int *		*/
#define WN_PREFPOS	903	/* WnPosition *		WnPosition *	*/
#define	WN_VIEWPORT	904	/* WnPosition *		WnPosition *	*/
#define	WN_CURPOS	905	/* WnPosition *		WnPosition *	*/
#define	WN_NAME		906	/* char *		char **		*/
/*
 * The following attributes always have a value (may not be "unset"):
 */
#define WN_ENLARGE	907	/* int			int *		*/
#define WN_SHRINK	908	/* int			int *		*/
#define WN_NOBORDER	909	/* int			int *		*/
#define WN_ASPECT	910	/* --- unsettable ---	float *		*/
#define	WN_PIXELASPECT	911	/* float		float *		*/

#define WN_ABLOCK	912	/* void **ablock	--ungettable--	*/
/*
  WN_END:	end of attribute list
  WN_XSIZE:	desired window width in pixels
  WN_YSIZE:	desired window height in pixels
  WN_PREFPOS:	desired absolute position of window (pixels)
  WN_VIEWPORT:	viewport relative to window (pixels)
  WN_CURPOS:	window's real position (pixels)
  WN_NAME:	window name
  WN_ENLARGE:	window enlargable from pref size? (1=yes, 0=no) (default:1)
  WN_SHRINK:	window shrinkable from pref size? (1=yes, 0=no) (default:1)
  WN_NOBORDER:	draw window without border? (1=yes, 0=no)	(default:0)
  WN_ASPECT:	the window's current aspect ratio; the window package updates
		  this automatically when you set the CURPOS attribute.
  WN_PIXELASPECT: pixel aspect ratio, i.e. screen X pixel size / Y pixel size.
		Default is 1.0, but may change e.g. for stereo hardware.
		Taken into account by WN_ASPECT */

#endif /* WINDOWDEF */
