/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef TEXTPDEF
#define TEXTPDEF

#include "geomclass.h"
#include "text.h"

typedef struct GText {
	GEOMFIELDS
	char *str;
	Geom *fontobj;
	Handle *fontobjhandle;
	GFont *font;
	short xjust, yjust;
	float scale;
	GText *next;
} GText;

typedef struct GFont {
	Geom *fontobj;
	int maxcode;
	struct gchar {
	    unsigned char xmin, ymin, xmax, ymax;
	    int coff;
	} *code;
} GFont;

extern GText *GTextCreate( GeomText *, GeomClass *, va_list );
extern void   GTextDelete( GeomText * );
extern GText *GTextCopy( GeomText * );
extern GText *GTextPick( GeomText *, Pick *, Appearance *, Transform );
extern GText *GTextFLoad( FILE *f, char *fname );
extern GText *GTextFSave( GeomText *, FILE * );
extern BBox  *GTextBound( GeomText *, Transform );
extern GText *GTextDraw( GeomText * );

#endif /*TEXTPDEF*/
