/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * app_init.c
 *
 * This procedure should initialize the application and
 * create any application-specific commands using Tcl_CreateCommand.
 *
 * One may also set the default rc filename and a directory for tcl commands.
 *
 * It expects to be able to find the tcl procs app_init_tcl and app_init_tk
 * and an mkindex.tcl file in the tcl directory.
 *
 */

#include <tk.h>
#include <stdio.h>

#include "constants.h"
#include "utilities.h"
#include "view.h"
#include "tcl_dstool.h"
#include "init_local.h"

char RC_FILENAME[] = "~/.wishrc";
Tcl_Interp *interp;

/* declare local procs */
static void app_create_commands(Tcl_Interp *interp);
static int interruptCmd(ClientData clientData, Tcl_Interp *interp,
		 int argc, char *argv[]);

int
app_init(Tcl_Interp *tcl_interp)
{
  char tcldir[SIZE_OF_DIR];

  /* save the tcl interp */
  interp = tcl_interp;

  /* call any application specific initialization */
  dstool_init();

  /* create any special tcl commands */
  Plot_Init(interp);
  app_create_commands(interp);

  /* give application directory containing tcl and tk commands */
  if (get_dstool_path(tcldir, DSTOOL_TCL_DIR))
    prepend_to_auto_path(tcldir);
  if (get_dstool_path(tcldir, MY_DSTOOL_TCL_DIR))
    prepend_to_auto_path(tcldir);
  
  /* call application tcl and tk initialization mode */
  if (Tcl_Eval(interp, "app_init_tcl") == TCL_ERROR)
    return TCL_ERROR;
  if (Tcl_Eval(interp, "app_init_tk") == TCL_ERROR)
    return TCL_ERROR;
  if (Tcl_Eval(interp, "my_app_init") == TCL_ERROR)
    return TCL_ERROR;

  /* make shortcut to tcl update command */
  setup_tcl_update();

  /* load default init file */
  Tcl_Eval(interp, "load(go)");       /* loads dstool.config */
  Tcl_Eval(interp, "load(infile)");   /* loads -infile <filename> */

  
  return TCL_OK;
}


/*
 * create new tcl commands
 */
static void
app_create_commands(Tcl_Interp *interp)
{
  Tcl_CreateCommand(interp,"pm", pmCmd, (ClientData) NULL, 
		    (Tcl_CmdDeleteProc *) NULL);
  Tcl_CreateCommand(interp,"window_register", winCmd, (ClientData) NULL, 
		    (Tcl_CmdDeleteProc *) NULL);
  Tcl_CreateCommand(interp,"interrupt", interruptCmd, (ClientData) NULL, 
		    (Tcl_CmdDeleteProc *) NULL);
  Tcl_CreateCommand(interp,"gv", gvCmd, (ClientData) NULL, 
		    (Tcl_CmdDeleteProc *) NULL);
}


static int
interruptCmd(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
  set_interrupt();
  return TCL_OK;
}
