/****************************************************************/
/* file sysdep.c

ARIBAS interpreter for Arithmetic
Copyright (C) 1996 O.Forster

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Address of the author

	Otto Forster
	Math. Institut der LMU
	Theresienstr. 39
	D-80333 Muenchen, Germany

Email	forster@rz.mathematik.uni-muenchen.de
*/
/****************************************************************/

/*
** sysdep.c
** sytemabhaengige Funktionen
** fuer stack check, timer, random seed
** sowie appl_init fuer ATARI-Version
**
** date of last change
** 94-09-15
** 96-10-22:	SysDUM
*/

#include "common.h"

#if defined(MsDOS) || defined(DjGPP)
#include <dos.h>
#endif

#ifdef ATARIST
#include <tos.h>
#endif

#ifdef DOSorUNiX
#include <signal.h>
#endif

#if defined(ATARIST) || defined(MsDOS)
#include <time.h>
#endif

/*
** if you have (under UNIX) compiling problems with the system
** dependent functions, define the symbol SysDUM or TimeDUM
** Then dummy functions will be substituted; the ARIBAS function
** timer and the random initialization will not work properly,
** but the rest will be unchanged.
*/
#ifdef genUNiX
#ifdef SysDUM
#define StackDUM
#define TimeDUM
#endif
#endif

#if defined(genUNiX) || defined(DjGPP)
#ifndef TimeDUM
#ifdef SCOUNiX
#include <sys/types.h>
#include <sys/timeb.h>
#include <time.h>
#else	/* ifndef SCOUNiX */
#include <sys/time.h>
static struct timezone t_z = {0,0};
#endif
#endif	/* TimeDUM */
#endif

#ifdef ATARIST
#include <vdi.h>
#include <aes.h>
int contrl[12],
    intin[128],
    intout[128],
    ptsin[128],
    ptsout[128];

int work_in[12],
    work_out[57];

PUBLIC int VDI_handle;
#endif

PUBLIC void stacklimit	_((void));
PUBLIC long stkcheck	_((void));
PUBLIC long timer	_((void));
PUBLIC int sysrand	_((void));
PUBLIC void prologue	_((void));
PUBLIC int epilogue	_((void));

/*-------------------------------------------------------------*/
PRIVATE long StackLimit;

#ifdef MsDOS
#define STACKLEN	64000
extern unsigned _stklen = STACKLEN;
#endif

#ifdef genUNiX
#define STACKLEN	400000
#endif

#ifdef DjGPP
#define STACKLEN	128000
#endif

/*-------------------------------------------------------------*/
#ifdef ATARIST
PUBLIC void stacklimit()
{
	extern long _StkLim;	/* im Startmodul TCSTSTK.O */

	StackLimit = _StkLim;
}
#endif

#ifdef MsDOS
PUBLIC void stacklimit()
{
	char ptr;

	StackLimit = (long)&ptr - (long)_stklen;
}
#endif

#if defined(genUNiX) || defined(DjGPP)
PUBLIC void stacklimit()
{
	char ptr;

	StackLimit = (long)&ptr - STACKLEN;
}
#endif
/*-------------------------------------------------------------*/
/*
** Returns length of free stack; used in EVAL.C
** not very portable!
*/

PUBLIC long stkcheck()
{
	long len;
#ifdef StackDUM
	len = 32000;
#else
	extern long StackLimit;
	char stkptr;

	len = (long)&stkptr - StackLimit;
#endif
	return(len);
}
/*-------------------------------------------------------------*/
#ifdef ATARIST
#define TMULT	5
#endif
#ifdef MsDOS
#define TMULT	54
#endif

#if defined(ATARIST) || defined(MsDOS)
PUBLIC long timer()
{
	long t = clock();
	t *= TMULT;
	return(t);
}
#endif

#if defined(genUNiX) || defined(DjGPP)
PUBLIC long timer()
{
#ifdef TimeDUM
	return(0);
#else
#ifdef SCOUNiX
	struct timeb tb;

	ftime(&tb);
	return(tb.time*1000 + tb.millitm);
#else
	struct timeval tv;

	gettimeofday(&tv,&t_z);
	return(tv.tv_sec * 1000 + tv.tv_usec/1000);
#endif
#endif
}
#endif
/*-------------------------------------------------------------*/
#ifdef ATARIST
PUBLIC int sysrand()
{
       return clock();
}
#endif

#ifdef MsDOS
PUBLIC int sysrand()
{
	randomize();
	return(rand());
}
#endif

#if defined(genUNiX) || defined(DjGPP)
PUBLIC int sysrand()
{
#ifdef SCOUNiX
	struct timeb tb;

	ftime(&tb);
	return(tb.time*1000 + tb.millitm);
#else
#ifndef TimeDUM
	struct timeval tv;

	gettimeofday(&tv,&t_z);
	return(tv.tv_usec);
#else
	return timer() + 37421;
#endif
#endif
}
#endif
/*------------------------------------------------------------------*/
PUBLIC void prologue()
{
#ifdef ATARIST

	int i, handle;
	int dum;

	if(appl_init() < 0) {
		puts("error in appl_init");
		exit(1);
	}
	for(i=1; i<10; i++)
		work_in[i] = 0;
	work_in[10] = 2;
	work_in[0] = graf_handle(&dum, &dum, &dum, &dum);
	v_opnvwk(work_in, &handle, work_out);
	if(handle <= 0) {
		puts("error during program initialization");
		exit(2);
	}
	v_hide_c(handle);
	v_enter_cur(handle);
	VDI_handle = handle;
#endif

#ifdef DOSorUNiX
	signal(SIGINT,ctrlcreset);
#endif
	return;
}
/*------------------------------------------------------------------*/
PUBLIC int epilogue()
{
	int ret = 0;
#ifdef ATARIST
	v_exit_cur(VDI_handle);
	v_show_c(VDI_handle,1);
	v_clsvwk(VDI_handle);
	ret = appl_exit();
#endif
	return(ret);
}
/*****************************************************************/
