# $Id: standard.tcl,v 1.17 1998/10/25 22:23:39 cthulhu Exp $
# 
#

#
# Removes the standard toolbar from display
#

proc undisplayStandardToolbar {mother} {
    pack forget $mother.standard
    pack forget $mother
}

#
# Displays the standard toolbar
#

proc displayStandardToolbar {mother nextone} {

    catch {destroy $mother.standard}
    frame $mother.standard
    frame $mother.standard.g1
    button $mother.standard.g1.new -image new_im -command newSpreadsheet
    button $mother.standard.g1.close -image close_im \
            -command {deleteSpreadsheet $activeSheet}
    button $mother.standard.g1.open -image open_im -command loadSheet
    button $mother.standard.g1.save -image save_im \
                    -command {SaveSheet $activeSheet $activeSheet.wk1}
    button $mother.standard.g1.print -image print_im \
            -command {printSheet}
    button $mother.standard.g1.preview -image preview_im \
            -command {
        set previewFile /tmp/.xxl_prev_[pid]
        puts "Printing to page $previewFile"
        getPrintParamsFromSheet
        computePrintParams
        doPrintSheet $previewFile $activePrintRange $colorMode $paperWidth \
                $paperHeight $typeView $scale $fromPage $toPage
        exec ghostview $previewFile &
        after 5000 "exec rm $previewFile"

    }

    frame $mother.standard.g2
    button $mother.standard.g2.cut -image cut_im \
	-command {rangeInitCommand copyData ; \
		      killCommand}
    button $mother.standard.g2.copy -image copy_im \
            -command {rangeInitCommand copyData}
    button $mother.standard.g2.move -image move_im \
	-command {rangeInitCommand moveData}
    button $mother.standard.g2.paint -image paint_im \
	-command {copyExec}
    
    frame $mother.standard.g3
    button $mother.standard.g3.redo -image redo_bm \
	-command {UndoRedo $activeSheet 1} -state disabled
    button $mother.standard.g3.undo -image undo_bm \
	-command {UndoRedo $activeSheet 0} -state disabled
    
    frame $mother.standard.g4
    button $mother.standard.g4.autosum -image sum_bm \
	-command {AutoSum}
    button $mother.standard.g4.funcmenu -image funcs_bm \
	-command {FuncMenu}
    
    frame $mother.standard.g5
    button $mother.standard.g5.sortasc -image ascend_bm  \
	-command { SortFromToolbar 1}
    button $mother.standard.g5.sortdesc -image descend_bm \
	-command { SortFromToolbar 0}

    frame $mother.standard.g6
    button $mother.standard.g6.calc -image calc_im \
            -command {SheetRecalc $activeSheet}


    pack $mother.standard.g1.new $mother.standard.g1.close \
            $mother.standard.g1.open \
            $mother.standard.g1.save $mother.standard.g1.print \
            $mother.standard.g1.preview \
            -side left -fill both
    pack $mother.standard.g2.cut $mother.standard.g2.copy \
            $mother.standard.g2.move $mother.standard.g2.paint \
            -side left -fill both
    pack $mother.standard.g3.redo $mother.standard.g3.undo -side left \
            -fill both
    pack $mother.standard.g4.autosum $mother.standard.g4.funcmenu -side left \
            -fill both
    pack $mother.standard.g5.sortasc $mother.standard.g5.sortdesc -side left \
            -fill both
    pack $mother.standard.g6.calc -side left \
            -fill both
    
    pack $mother.standard.g6 $mother.standard.g5 $mother.standard.g4 \
            $mother.standard.g3 \
            $mother.standard.g2 $mother.standard.g1 -side right -padx 0.2c
    
    pack $mother.standard -side top -anchor w -before $nextone
#    pack $mother -fill x -side top -before $nextone

    bind $mother.standard.g1.new <Enter> \
	{HelpMessage "Create a new spreadsheet"}
    bind $mother.standard.g1.close <Enter> \
	{HelpMessage "Close this spreadsheet" }
    bind $mother.standard.g1.open <Enter> \
	{HelpMessage "Open an existing spreadsheet" }
    bind $mother.standard.g1.print <Enter> \
	{HelpMessage "Print this spreadsheet" }
    bind $mother.standard.g1.preview <Enter> \
	{HelpMessage "Print preview this spreadsheet" }
    bind $mother.standard.g1.save <Enter> \
	{HelpMessage "Save this spreadsheet" }

    bind $mother.standard.g2.cut <Enter> \
		{HelpMessage "Cut" }
    bind $mother.standard.g2.copy <Enter> \
		{HelpMessage "Copy" }
    bind $mother.standard.g2.move <Enter> \
		{HelpMessage "Move" }
    bind $mother.standard.g2.paint <Enter> \
		{HelpMessage "Paste" }

    bind $mother.standard.g3.redo <Enter> \
		{HelpMessage "Redo" }
    bind $mother.standard.g3.undo <Enter> \
		{HelpMessage "Undo" }
	
    bind $mother.standard.g4.autosum <Enter> \
		{HelpMessage "Autosum" }
    bind $mother.standard.g4.funcmenu <Enter> \
		{HelpMessage "Insert function" }

    bind $mother.standard.g5.sortasc <Enter> \
		{HelpMessage "Sort ascending" }
    bind $mother.standard.g5.sortdesc <Enter> \
		{HelpMessage "Sort descending" }

    bind $mother.standard.g6.calc <Enter> \
	{HelpMessage "Calculate now" }

    bind all <Leave> \
	{HelpMessage "" }
}


# 
# $Log: standard.tcl,v $
# Revision 1.17  1998/10/25 22:23:39  cthulhu
# Cut should now work.
#
# Revision 1.16  1998/10/11 23:11:26  cthulhu
# Autosum help message was wrong.
#
# Revision 1.15  1998/10/07 22:01:49  cthulhu
# Paste button was disabled for some reason, now active and using new paste
# 	calling convention.
#
# Revision 1.14  1998/08/24 18:35:06  cthulhu
# Added tooltips.
#
# Revision 1.13  1998/08/06 21:08:35  aml
# Released alpha version of Abacus.
#
# Revision 1.12  1997/02/10 15:10:07  aml
# Print settings now are saved to file.
# Fixed buggy error message when loading sheets.
#
# Revision 1.11  1997/01/07  01:07:42  aml
# Error propagation for formulas fixed.
# Edit operations in place.
#
# Revision 1.10  1996/10/10  22:55:26  aml
# Print preview. Improvements on print command.
#
# Revision 1.9  1996/10/09 13:55:04  aml
# First cut of full print.
#
# Revision 1.8  1996/03/07 20:32:57  aml
# Created print range ability.
# Set in gray non-working menus.
# Created RangeKill command.
# Created round function and macros for single argument functions.
#
# Revision 1.7  1996/02/13  21:55:20  aml
# Fixed problems with change to elf.
# RangeCopy created. Works !
# Pressed mouse leaving canvas will cause scroll. Works, but needs to
# keep moving.
#
# Revision 1.6  1996/02/13  12:03:43  aml
# Fixed bug with range definition via mouse.
# Fixed bug in range iterators.
#
# Revision 1.5  1996/01/27  23:10:26  aml
# CellCopy created.
# CellGet fixed.
# Tcl range operators created.
# User interface improved. Cell references and ranges
# can now be defined with the mouse.
#
# Revision 1.4  1996/01/09  18:34:50  aml
# Load, save, open, close and exit now work properly (hopefuly).
# Sheet utility functions also work : SheetExists, SheetEmpty, SheetModified
#
# Revision 1.3  1995/12/14  12:13:03  aml
# Version 0.4.2
#
# Revision 1.2  1995/11/08  22:25:02  aml
# Added call to new
#
# Revision 1.1  1995/11/08  22:10:52  aml
# Initial revision
#
#





