/*								-*- C++ -*-
 * $Id: WIN_enhdialogbox.h,v 1.1 1996-09-25 11:06:51+02 mho Exp $
 *
 * Purpose: enhanced dialog box
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef EnhDialogBox_h
#define EnhDialogBox_h

#ifdef __GNUG__
#pragma interface
#endif

class wxEnhDialogBox : public wxDialogBox {
DECLARE_DYNAMIC_CLASS(wxEnhDialogBox)
public:
    wxPanel *userPanel;

    wxEnhDialogBox(void);
    wxEnhDialogBox(wxFrame *frame, Const char *title, Bool modal = FALSE,
		   wxFunction fun = NULL, int space=-1,
		   int x=-1, int y=-1, int width=-1, int height=-1,
		   long style = wxENH_DEFAULT,
		   Constdata char *name = wxEnhDialogBoxNameStr);
    ~wxEnhDialogBox();

    Bool Create(wxFrame *frame, Const char *title, Bool modal = FALSE,
		wxFunction fun = NULL, int space=-1,
		int x=-1, int y=-1, int width=-1, int height=-1,
		long style = wxENH_DEFAULT,
		Constdata char *name = wxEnhDialogBoxNameStr);

    wxButton  *AddCmd(char *label,wxFunction fun=NULL, int tag = 0);
    wxButton  *AddCmd(wxBitmap *bitmap,wxFunction fun=NULL, int tag = 0);
    wxButton  *GetCmd(int number);
    void      Fit(void);
    void      SetPin(Bool flag);
    void      SetStatus(char *label=NULL) { SetStatusText(label); }
    Bool      Show(Bool show, Bool flag=FALSE);
};

#endif // EnhDialogBox_h
