/*
 * Copyright (c) 1997, 1998 Akira Yoshiyama <yosshy@debian.or.jp>
 * Copyright (c) 1998 Fumitoshi UKAI <ukai@debian.or.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public Licenses as
 * published by the Free Software Foundation; either version 2 of 
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
  ucs2mbs.h
  the global header file for ucs2-mbs conversion.
  written by A. Yoshiyama <yosshy@debian.or.jp>
  COPYRIGHT: GPL2
  */

#ifndef UCS2MBS_H
#define UCS2MBS_H

#include <asm/types.h>

/*
  esc_policy
  flag for escape sequence policy:
  */
extern int escpolicy;
extern int table_wcs2mbs_maxentry;

#define STATELESS  0
#define HAS_STATE  1

typedef struct {
  char key;       /** key code (upper byte of UCS2) **/
  __u16 pointer;   /** entry pointer to lower table **/
} upper_table_t;

/*
  struct table_wcs2mbs_t
  miscellaneous variable for ucs2-mbs conversion
  */
typedef struct {
  int   mbcnum;		/* number of multibyte characters/1UCS2 **/
  const char  *escseq;	/* escape sequence string **/
  int   esnum;		/* number of escape sequence */
  const upper_table_t  *uppertable;	/* table of upper character of UCS2 */
  const char           *lowertable;	/* table of lower character of UCS2 */
} table_wcs2mbs_t;

#endif /* UCS2MBS_H */
       
