//	videcmdw.h:	Header for videcmdw class
//=======================================================================

#ifndef videCMDW_H
#define videCMDW_H

#include <v/vcmdwin.h>	// So we can use vCmdWindow
#include <v/vmenu.h>	// For the menu pane
#include <v/vutil.h>	// For V Utilities
#include <v/vcmdpane.h> // command pane
#include <v/vstatusp.h>	// For the status pane
#include <v/vfont.h>	// for fonts

#ifdef vDEBUG
#include <v/vdebug.h>
#endif

#include "videmake.h"	// our make class

#include "vedcnv.h"	// vedCanvasPane

    enum {m_updateMkFile = 500 };

    class videCmdWindow;
    class vTextEdCmdInterp;

    class videCmdWindow : public vCmdWindow
      {
	friend int AppMain(int, char**);	// allow AppMain access

      public:		//---------------------------------------- public
	videCmdWindow(char*, int, int);
	virtual ~videCmdWindow();
	virtual void WindowCommand(ItemVal id, ItemVal val, CmdType cType);
	virtual void KeyIn(vKey keysym, unsigned int shift);

	void ChangeLoc(long line, int col);
	void ChangeInsMode(int IsInsMode, char* msg = 0);
	void StatusMessage(char *msg);
	void ErrorMsg(char *str);
	int OpenFile(char* name, int RdOnly = 0, int notify = 1);
	int CheckClose(int ask = 1);
        int SetViewWindow(char *name);
        int AddLine(char* line);
        vedTextEditor* GetTextEd() { return vedCanvas; }
        void SetRdOnly(int ro);
        void GotoErrorLine();
        char* GetFileName() { return fileName; }

      protected:	//--------------------------------------- protected
        videCmdWindow* FindCmdWin(char* fname);
        
  
      private:		//--------------------------------------- private

	// Standard elements
	vMenuPane* videMenu;		// For the menu bar
	vedTextEditor* vedCanvas;	// For the canvas
	vCommandPane* videCmdPane;	// for the command pane
	vStatusPane* videStatus;	// For the status bar
        vFont vedFont;			// for the font

	// Dialogs associated with CmdWindow

        // Other stuff
        videMake* ideMake;
        vTextEdCmdInterp* vedCI;	// command interp

	char fileName[maxFileNameSize+2];


      };
#endif
