#ifndef PAMC_PRIVATE_H
#define PAMC_PRIVATE_H

/*
 * Copyright (c) 1998 Andrew G. Morgan <morgan@linux.kernel.org>
 * All rights reserved.
 *
 * The license for this source code should accompany this file.  Its
 * md5 checksum is: cac41ac118b52c96cf248baec7237381
 */

#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include <security/pam_client.h>

#undef DEBUG

#ifdef DEBUG
# include <security/_pam_macros.h>
#else /* DEBUG */
# define D(x)
#endif /* DEBUG */

struct pamc_agent_struct {
    struct pamc_agent_struct *next, *previous;
    pid_t pid;
    int status;
    char *id;
    int to_agent, from_agent;
};


struct pamc_handle_struct {
    char *path;
    struct pamc_agent_struct *stack;
    struct pamc_agent_struct *current;
};


#ifndef PAMC_DEFAULT_PATH_FORMAT
#define PAMC_DEFAULT_PATH_FORMAT "%s/%s.agent"
#endif /* PAMC_DEFAULT_PATH_FORMAT */

#ifndef PAMC_DEFAULT_PATH
#define PAMC_DEFAULT_PATH "/usr/sbin/pamc"
#endif /* PAMC_DEFAULT_PATH */

#endif /* PAMC_PRIVATE_H */
