 /*****************************************************************************
*
*   asn2ff.c
*   	convert an ASN.1 entry to flat file format, using the FFPrintArrayPtrs. 
*
*****************************************************************************/
#include <accentr.h>
#include "asn2ff.h"
#include "asn2ffp.h"
#include "ffprint.h"
#include <subutil.h>
#include <objall.h>
#include <objcode.h>
#include <lsqfetch.h>

FILE *fpl;

#define NUM 21
Args myargs[NUM] = {
	{"Filename for asn.1 input","stdin",NULL,NULL,TRUE,'a',ARG_FILE_IN,0.0,0,NULL},
	{"Input is a Seq-entry","F", NULL ,NULL ,TRUE,'e',ARG_BOOLEAN,0.0,0,NULL},
	{"Input asnfile in binary mode","F",NULL,NULL,TRUE,'b',ARG_BOOLEAN,0.0,0,NULL},
	{"Output Filename","stdout", NULL,NULL,TRUE,'o',ARG_FILE_OUT,0.0,0,NULL},
	{"Show Sequence?","T", NULL ,NULL ,TRUE,'h',ARG_BOOLEAN,0.0,0,NULL},
    {"Log errors to file named:",NULL,NULL,NULL,TRUE,'l',ARG_FILE_OUT, 0.0,0,NULL},
	{"Output Format?: b for GenBank, p for GenPept, e for EMBL, s for PseudoEMBL, x for   GenBankSelect, z for EMBLPEPT,",
	"b", NULL,NULL,TRUE,'f',ARG_STRING,0.0,0,NULL},
	{"Output mode?: r for release, d for dump, s for Sequin, c for Chromoscope, k for dir-sub-debug, l for dir-sub, e for revise","r", NULL ,NULL ,TRUE,'m',ARG_STRING,0.0,0,NULL},
	{"Input is a Seq-submit","F", NULL ,NULL ,TRUE,'s',ARG_BOOLEAN,0.0,0,NULL},
	{"Show gi numbers?","T", NULL ,NULL ,TRUE,'g',ARG_BOOLEAN,0.0,0,NULL},
	{"Non-Strict gene_binding","T", NULL ,NULL ,TRUE,'n',ARG_BOOLEAN,0.0,0,NULL},
	{"Show error messages","T", NULL ,NULL ,TRUE,'v',ARG_BOOLEAN,0.0,0,NULL},
	{"Show verbose message text","F", NULL ,NULL ,TRUE,'t',ARG_BOOLEAN,0.0,0,NULL},
	{"Use HTML output format?","F", NULL,NULL,TRUE,'w',ARG_BOOLEAN,0.0,0,NULL},
	{"Output is one top bioseq only","F", NULL ,NULL ,TRUE,'q',
	ARG_BOOLEAN,0.0,0,NULL},
	{"Output is one top bioseq only in genome view","F", NULL ,NULL ,TRUE,'G',
	ARG_BOOLEAN,0.0,0,NULL},
	{"Output is map bioseqs only ","F", NULL ,NULL ,TRUE,'M',
	ARG_BOOLEAN,0.0,0,NULL},
	{"Output error logfile","stderr", NULL,NULL,TRUE,'r',ARG_FILE_OUT,0.0,0,NULL},
	{"Show new gene features?","T",NULL,NULL,TRUE,'p',ARG_BOOLEAN,0.0,0,NULL},
	{"New algorithm for orgnames?",
	"F",NULL,NULL,TRUE,'z',ARG_BOOLEAN,0.0,0,NULL},
	{"Print help format only?",
	"F",NULL,NULL,TRUE,'y',ARG_BOOLEAN,0.0,0,NULL},
	};


static MsgAnswer LIBCALLBACK myHook (MsgKey key, ErrSev sev, const char *caption, const char *message)
{
	fprintf(fpl, "%s\n", message);
	return ANS_OK;
}

Int2 Main()
{

	AsnIoPtr aip;
	AsnTypePtr atp = NULL, atp1, atp2;
	AsnModulePtr amp;
	Boolean error_msgs=TRUE, show_gi= TRUE, show_seq = TRUE, non_strict=TRUE;
	SeqEntryPtr the_set;
	SeqSubmitPtr ssp;
	StdPrintOptionsPtr Spop = NULL;
	FILE *fp;
	Uint1 format, mode;
	Boolean good = FALSE;
	Asn2ffJobPtr		ajp;
	Uint2 entityID;
	Int4 num, total;
	
	ValNodePtr splicing_desc = NULL, citsub;
	PubdescPtr	pdp;
	CitSubPtr	the_cit;

					/* check command line arguments */

	if ( ! GetArgs("asn2ff",NUM, myargs))
		return 1;

					/* load the sequence alphabets  */
					/* (and sequence parse trees)   */
	ErrSetMessageLevel(SEV_NONE);
	ErrSetOptFlags(EO_SHOW_CODES);
	ErrSetOptFlags(EO_XLATE_CODES);
	if (myargs[12].intvalue)   /* show the verbose error messages? */
		ErrSetOptFlags(EO_MSG_MSGTEXT);

	if (myargs[13].intvalue)   /* use HTML format for output? */
		init_www();
	if (! SeqEntryLoad())
		ErrShow();
	
	if (myargs[8].intvalue) {
		if (! SubmitAsnLoad())
			Message(MSG_FATAL, "Unable to load parse trees.");
		
		atp1 = AsnFind("Seq-submit");
		if (atp1 == NULL)
			Message(MSG_FATAL, "Unable to find Seq-submit");
		atp = AsnFind("Seq-submit");
		if (atp == NULL)
			Message(MSG_FATAL, "Unable to find Seq-submit");

	} else {
		atp = AsnFind("Bioseq-set"); /* get the initial type pointers */
		if (atp == NULL)
			ErrShow();
	
		atp2 = AsnFind("Bioseq-set.seq-set.E");
		if (atp2 == NULL)
			ErrShow();
	}

			/* open the i/o files in the right mode */

	if ((aip = 
		AsnIoOpen (myargs[0].strvalue, myargs[2].intvalue?"rb":"r")) == NULL)
		exit (1);

	if ( (fp = FileOpen (myargs[3].strvalue, "w")) == NULL) {
		ErrPostEx(SEV_ERROR,0,0, "Can't open %s", myargs[3].strvalue);
		exit (1);
	}
	if ( (fpl = FileOpen (myargs[17].strvalue, "w")) == NULL) {
		ErrPostEx(SEV_ERROR,0,0, "Can't open %s", myargs[17].strvalue);
		exit (1);
	}

	SetMessageHook(myHook);

    if (myargs[5].strvalue != NULL) { 			/* log errors instead of die */
        if (! ErrSetLog (myargs[5].strvalue))
            ErrShow();
        else
            ErrSetOpts (ERR_TEE, ERR_LOG_ON);
    }

	if (! myargs[4].intvalue)   /* show the sequence */
		show_seq = FALSE;

	if (! myargs[9].intvalue)   /* show the gi numbers? */
		show_gi = FALSE;

	if (!myargs[10].intvalue)   /* Non-Strict binding of genes to feats */
		non_strict = FALSE;

	if (! myargs[11].intvalue)   /* Show validator error messages */
		error_msgs = FALSE;

	format = GENBANK_FMT;
	if (StringICmp(myargs[6].strvalue, "b") == 0)
		format = GENBANK_FMT;
	else if (StringICmp(myargs[6].strvalue, "p") == 0)
		format = GENPEPT_FMT;
	else if (StringICmp(myargs[6].strvalue, "e") == 0)
		format = EMBL_FMT;
	else if (StringICmp(myargs[6].strvalue, "s") == 0)
		format = PSEUDOEMBL_FMT;
	else if (StringICmp(myargs[6].strvalue, "x") == 0)
		format = SELECT_FMT;
	else if (StringICmp(myargs[6].strvalue, "z") == 0)
		format = EMBLPEPT_FMT;

	if (format == GENPEPT_FMT)
	{
		if (PrintTemplateSetLoad ("asn2ff.prt"))
		{
			ErrShow();
		}
		Spop = StdPrintOptionsNew(NULL);
		if (Spop)
		{
			Spop->newline = "~";
			Spop->indent = "";
		}
		else
		{
			Message (MSG_FATAL, "StdPrintOptionsNew failed");
		}
	}

	mode = RELEASE_MODE;
	if (StringICmp(myargs[7].strvalue, "r") == 0)
		mode = RELEASE_MODE;
	if (StringICmp(myargs[7].strvalue, "l") == 0)
		mode = DIRSUB_MODE;
	if (StringICmp(myargs[7].strvalue, "k") == 0)
		mode = DIRSUB_DEBUG_MODE;
	if (StringICmp(myargs[7].strvalue, "e") == 0)
		mode = REVISE_MODE;
	if (StringICmp(myargs[7].strvalue, "d") == 0)
		mode = DUMP_MODE;
	if (StringICmp(myargs[7].strvalue, "s") == 0)
		mode = SEQUIN_MODE;
	if (StringICmp(myargs[7].strvalue, "c") == 0)
		mode = CHROMO_MODE;

#ifdef ENABLE_ENTREZ
	EntrezBioseqFetchEnable ("asn2ff", FALSE); 
#endif
#ifdef ENABLE_LOCAL
	BioseqFetchInit(FALSE);
#endif
	ajp = (Asn2ffJobPtr) MemNew(sizeof(Asn2ffJob));
	ajp->show_gene = myargs[18].intvalue;
	ajp->show_seq = show_seq;
	ajp->show_gi = show_gi;
	ajp->error_msgs = error_msgs;
	ajp->non_strict = non_strict;
	ajp->null_str = FALSE;
	ajp->format = format;
	ajp->mode = mode;
	ajp->fp = fp;
	ajp->Spop = Spop;
	ajp->gb_style = TRUE;  /* show only non_right_truncated features */
	
	if (myargs[14].intvalue) {
		ajp->gb_style = FALSE;
		ajp->only_one = TRUE;
		ajp->ignore_top = TRUE;
	}
	if (myargs[15].intvalue) {
		ajp->ignore_top = TRUE;
		ajp->genome_view = TRUE;
	}
	if (myargs[16].intvalue) {
		ajp->map_view = TRUE;
	}
	if (myargs[19].intvalue) {
		ajp->orgname = TRUE;
	}
	if (myargs[20].intvalue) {
		ajp->help = TRUE;
	}
	/* get pointer to all loaded ASN.1 modules */
	amp = AsnAllModPtr();
	if (amp == NULL)
		ErrShow();

	total = 0;
	num = 0;
	if (myargs[8].intvalue) {
		if (mode == DUMP_MODE) {
		    aip->scan_for_start = TRUE;  /* scan past any garbage */
		}
		while ((atp = AsnReadId(aip, amp, atp)) != NULL) {
			if (atp == atp1) {	
				ssp = SeqSubmitAsnRead(aip, atp);
				if (ssp->datatype == 1) {
					if ((SeqSubmitToFlat(ssp, fp, mode, FALSE, format, 
							myargs[18].intvalue)) == TRUE)
					{
						num++;
					}
				} 
				SeqSubmitFree(ssp);
				
			} else {
				AsnReadVal(aip, atp, NULL);
			} 
		}
	} else if (myargs[1].intvalue) {
		the_set = SeqEntryAsnRead(aip, NULL);
		entityID = ObjMgrGetEntityIDForPointer(the_set);
		if (entityID == 0)
			ErrPostStr(SEV_WARNING, 0, 0, "Couldn't get entityID");
		ajp->entityID = entityID;
		ajp->sep = the_set;
		good = asn2ff_print(ajp);
		if (good == FALSE) {
	/*		ErrPostEx(SEV_WARNING, 1, 1, "Couldn't find valid entry\n"); */
		} else {
			num++;
			total++;
		}
		SeqEntryFree(the_set);
	} else {
		while ((atp = AsnReadId(aip, amp, atp)) != NULL)
		{
			if (atp == atp2)    /* top level Seq-entry */
			{
				the_set = SeqEntryAsnRead(aip, atp);
				total++;
				entityID = ObjMgrGetEntityIDForPointer(the_set);
				if (entityID == 0)
					ErrPostStr(SEV_WARNING, 0, 0, "Couldn't get entityID");
				ajp->entityID = entityID;
				ajp->sep = the_set;
				good = asn2ff_print(ajp);
				if (good == FALSE) {
			/*	ErrPostEx(SEV_WARNING, 1, 1, "Couldn't find valid entry\n"); */
				} else {
					num++;
				}
				SeqEntryFree(the_set);
			}
			else
				AsnReadVal(aip, atp, NULL);
		}
				
	}

#ifdef ENABLE_ENTREZ
	EntrezBioseqFetchDisable (); 
#endif
#ifdef ENABLE_LOCAL
	BioseqFetchDisable();
#endif
	if (num == 0) {
		ErrPostStr(SEV_WARNING, 1, 1, "No valid entries found");
	} else if (num < total) {
		ErrPostEx(SEV_WARNING, 1, 1, "[%ld] entries have been processed [total - %ld]\n", num, total);
	}
	if (format == GENPEPT_FMT && Spop != NULL) {
		Spop = StdPrintOptionsFree(Spop);
	}
	MemFree(ajp);
	AsnIoClose(aip);
	FileClose(fp);
	return(0);
}
