NAME
     wnswap -- swap 2 variables

SYNOPSIS
     #include "wnswap.h"

     wn_swap(a,b,type)

     wn_order(a,b,type)

DESCRIPTION
     "wn_swap" is a macro which swaps "a" and "b".   "a" and "b" must
     be of type "type".  "type" is used to declare a temporary.

     "wn_order" is a macro which uses "wn_swap" to swap "a" and "b" 
     so that "a" <= "b".

EXAMPLES
     {
       int a,b;

       ...
       wn_swap(a,b,int);
       ...
     }

     {
       ptr p1,p2;

       ...
       wn_swap(p1,p2,ptr);
       ...
     }

     {
       char *p1,*p2;

       ...
       wn_swap(p1,p2,char *);
       ...
     }

     {
       double d1,d2;

       ...
       wn_order(d1,d2,double);
       ...
     }

BUGS

SEE ALSO
     wnsort

AUTHOR
     Will Naylor


