#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include <Xm/Form.h>
#include <Xm/ComboBoxP.h>
#include "XdbPrintTree.c"
#include "XdbPrintResources.c"

#if !defined(CB_List)
#define CB_List(w) \
        (((XmComboBoxWidget)(w))->combo_box.list)
#endif

int
main(int argc, char **argv)
{
  Widget toplevel, widget, bb, list;
  XtAppContext app;
  XmString item;
  Arg args[10];
  int n = 0;

  XtSetLanguageProc(NULL, NULL, NULL);

  toplevel = XtVaAppInitialize(&app, "ComBox", NULL, 0, &argc, argv, NULL, NULL);

  bb = XmCreateForm(toplevel, "bb", NULL, 0);
  XtManageChild(bb);

  widget = XmCreateDropDownComboBox(bb, "combo", args, n);
  XtVaSetValues(widget,
  	XmNtopAttachment, XmATTACH_FORM,
  	XmNbottomAttachment, XmATTACH_FORM,
  	XmNleftAttachment, XmATTACH_FORM,
  	XmNrightAttachment, XmATTACH_FORM,
  	NULL);

  /* use list routine to add items */
  list = CB_List(widget);

  item = XmStringCreateSimple("Item 1");
  XmListAddItem(list,item,0);
  item = XmStringCreateSimple("Item 2");
  XmListAddItem(list,item,0);
  item = XmStringCreateSimple("Item 3");
  XmListAddItem(list,item,0);
  item = XmStringCreateSimple("Item 4");
  XmListAddItem(list,item,0);
  item = XmStringCreateSimple("Item 5");
  XmListAddItem(list,item,0);

  XmComboBoxUpdate(widget);

  XtManageChild(widget);

  XtRealizeWidget(toplevel);

#if 0
  XdbPrintCompleteTree(toplevel);

#if 0
  XdbPrintResources(CB_ListShell(widget));
  XdbPrintResources(widget);
#endif

#endif

  XtAppMainLoop(app);

  exit(0);
}

