/* $Id: plat.h,v 1.3 1998/10/24 04:03:57 marcus Exp $
***************************************************************************

   LibGGI platform specific definitions

   Copyright (C) 1998	Marcus Sundberg		[marcus@ggi-project.org]
  
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#ifndef _GGI_INTERNAL_PLAT_H
#define _GGI_INTERNAL_PLAT_H

#include "config.h"

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif


#if defined(__GNUC__) && !defined(inline)
#define inline __inline__
#endif

#ifdef HAVE_USLEEP
#define _ggi_usleep	usleep
#else
void _ggi_usleep(unsigned int);
#endif

#ifdef HAVE_GETTIMEOFDAY
#define EV_TIMESTAMP(ev)  { gettimeofday(& (ev)->any.time, NULL); }
#else
#error This system does not have gettimeofday(), please define EV_TIMESTAMP()
#endif

#endif /* _GGI_INTERNAL_PLAT_H */
