/* $Id: Xvisual.h,v 1.15 1998/10/06 20:00:39 steve Exp $
***************************************************************************

   XFree86 Direct Graphics Access target for LibGGI

   Copyright (C) 1998 Steve Cheng   [steve@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ---------------------------------------------------------------------
   README:

   Programs need SUID root. You really should use KGI :-)

   This target makes a number of assumptions about the XFree86
   implementation of X Window System. So if DGA actually gets outside of
   XFree86 this target might not work. Blame it on XF86DGA's stupid design.

   When using the XF86DGA target, LibGGI programs will always segfault at
   the end. This happens because XF86DGA puts an atexit function to do some
   'cleanup' when the program exits.  However, the XF86DGA static library
   would be unloaded along with the target by ggiClose(), and calling the
   then-non-existent atexit function causes the segfault. A 'solution' used
   here is to _exit() when SIGSEGV is received.

   Likewise, XF86DGA will install a couple of new signal handlers; these are
   removed automatically on unloading of this target.

   See source for miscellaneous stuff.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include "../common/modelist.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#include <X11/extensions/xf86dga.h>
#include <X11/extensions/xf86vmode.h>

/* Never prevent apps from segfaulting on exit */
/*
#define ALWAYS_SEGFAULT_ON_EXIT
*/

/* Macros to gain and give up root privs, for mmapping /dev/mem. Note that
   they use the non-POSIX (but BSD 4.3 conformant) call seteuid() because
   regular setuid() does not allow regaining root privs when they have
   already been given up. */

#define GET_ROOT	seteuid(0)
#define GIVE_UP_ROOT	seteuid(getuid())
#define PERM_GIVE_UP_ROOT	setuid(getuid())

/* LIBGGI_PRIVATE info */

struct Xhooks { 
	Display *display;
	int screen;
	XF86VidModeModeInfo **dgamodes;
	ggi_modelistmode *modes;
	int num_modes;
	unsigned width;
	unsigned height;
	unsigned depth;
	unsigned size;
	Colormap cmap;
	Colormap cmap2; /* We need two colormaps to work around a bug
			   in XFree86 DGA... */
	int     activecmap;
        int     nocols;	    /* Number of colors in the colormap */
	int     pixperframe;
	void   *fb;
	int     stride;
	int     bank_size;
	int     mem_size;

	ggi_mutex XLibLock;
};

/* prototypes
 */
ggifunc_getmode		GGI_xf86dga_getmode;
ggifunc_setmode		GGI_xf86dga_setmode;
ggifunc_checkmode	GGI_xf86dga_checkmode;
ggifunc_getapi		GGI_xf86dga_getapi;
ggifunc_setflags	GGI_xf86dga_setflags;
ggifunc_eventpoll	GGI_xf86dga_eventpoll;
ggifunc_eventread	GGI_xf86dga_eventread;
ggifunc_seteventmask	GGIseteventmask;
ggifunc_setpalvec	GGI_xf86dga_setpalvec;
ggifunc_setreadframe	GGI_xf86dga_setreadframe;
ggifunc_setwriteframe	GGI_xf86dga_setwriteframe;

void _GGI_xf86dga_freedbs(ggi_visual *);

#define XLIB_PRIV(vis) ((struct Xhooks *)LIBGGI_PRIVATE(vis))
