/* $Id: visual.c,v 1.5 1998/10/18 15:52:49 becka Exp $
***************************************************************************

   Helper library for the implementation of SYNC mode on targets which are
   inherently ASYNC (e.g. X) and require manual flushes of the framebuffer.

   Mansync initialization.

   Copyright (C) 1998 Marcus Sundberg  [marcus@ggi-project.org]
   Copyright (C) 1998 Steve Cheng      [steve@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include "mansync.h"

int GGIdlinit(ggi_visual *visual,const char *args,void *argptr)
{
	_ggi_opmansync *ops = (_ggi_opmansync *) args;
	
	if (ops == NULL)
		ggiPanic("Target tried to use mansync helper in a wrong way!\n");

	ops->init   = _GGI_mansync_init;
	ops->deinit = _GGI_mansync_deinit;
	ops->start  = _GGI_mansync_start;
	ops->stop   = _GGI_mansync_stop;
	ops->ignore = _GGI_mansync_ignore;
	ops->cont   = _GGI_mansync_cont;

	return 0;
}

int GGIdlcleanup(ggi_visual *visual)
{
	return 0;
}

#include <ggi/internal/ggidlinit.h>
