/* $Id: crossblit.c,v 1.7 1998/09/26 03:20:59 marcus Exp $
***************************************************************************

   Graphics library for GGI.

   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]
   Copyright (C) 1998 Andrew Apted     [andrew.apted@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "stublib.h"

/* Cross blitting of a rectangular area.
 */
int GGI_stubs_crossblit(ggi_visual *src, int sx, int sy, int w, int h, 
			ggi_visual *dst, int dx, int dy)
{
	ggi_pixel cur_src;
	ggi_pixel cur_dst;

	/* clipping */

	if (dx < LIBGGI_GC(dst)->cliptl.x) {
		int diff = LIBGGI_GC(dst)->cliptl.x - dx;
		sx += diff;
		dx += diff;
		w  -= diff;
	}
	if (dy < LIBGGI_GC(dst)->cliptl.y) {
		int diff = LIBGGI_GC(dst)->cliptl.y - dy;
		sy += diff;
		dy += diff;
		h  -= diff;
	}
	if (dx+w > LIBGGI_GC(dst)->clipbr.x) {
		w = LIBGGI_GC(dst)->clipbr.x - dx;
	}
	if (dy+h > LIBGGI_GC(dst)->clipbr.y) {
		h = LIBGGI_GC(dst)->clipbr.y - dy;
	}

	if ((w <= 0) || (h <= 0)) {
		return 0;
	}
	
	cur_dst=0;	/* keep compiler quiet */

	ggiGetPixel(src, sx, sy, &cur_src);
	cur_src++; /* assure safe init */

	for (; h > 0; h--, sy++, dy++) {

		int x;
		for (x=0; x < w; x++) {

			ggi_pixel pixel;
			ggiGetPixel(src, sx+x, sy, &pixel);

			if (pixel != cur_src) {

				ggi_color col;
				ggiUnmapPixel(src, pixel, &col);

				cur_dst = ggiMapColor(dst, &col);
				cur_src = pixel;
			}
			
			ggiPutPixel(dst, dx+x, dy, cur_dst);
		}
	}

	return 0;
}

#if 0
/* This is the old stretching code.  I haven't deleted it -- it could
 * come it handy when implementing ggiStretchBlit() in libggi2d.
 */
	{		/* STETCH */

		ddx=dx;ssx=sx;erry=(dh-sh)>>1;ty=sy+sh;tx=sx+sw;
	
		/* The basic stretching core. Please speed me up. Teunis ? */
		for(;sy<ty;sy++) {
			erry+=dh;
			if (erry<=0) continue;

			dx=ddx;sx=ssx;errx=0;
			for(;sx<tx;sx++) {
				errx+=dw;
				if (errx<=0) continue;
				ggiGetPixel(src,sx,sy,&pixel);

				if (pixel!=lastpixel) {
					ggiUnmapPixel(src,lastpixel=pixel,&thecol);
					lasttrans=ggiMapColor(dst,&thecol);
				}
				
				while(errx>0) {
					ggiPutPixel(dst,dx++,dy,lasttrans);
					errx-=sw;
				}
			}
			do{
				dy++;erry-=sh;
				ggiCopyBox(dst,ddx,dy-1,dw,1,ddx,dy);
			} while(erry>0);
		}
	}		/* STETCH */
#endif
