/* $Id: pixel.c,v 1.8 1998/09/20 21:22:51 marcus Exp $
***************************************************************************

   Graphics library for GGI. Pixels.

   Copyright (C) 1997 Jason McMullan [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

/*******************************/
/* draw/get/put a single pixel */
/*******************************/

int GGIdrawpixel(ggi_visual *vis,int x,int y)
{
	CHECKXY(vis,x,y);
 
	*((uint32 *) ((uint8 *)LIBGGI_CURWRITE(vis)
	   + y*LIBGGI_FB_W_STRIDE(vis)+x*sizeof(uint32)))
		= LIBGGI_GC_FGCOLOR(vis);

	return 0;
}

int GGIdrawpixel_nc(ggi_visual *vis,int x,int y)
{
	*((uint32 *) ((uint8 *)LIBGGI_CURWRITE(vis)
	   + y*LIBGGI_FB_W_STRIDE(vis)+x*sizeof(uint32)))
		= LIBGGI_GC_FGCOLOR(vis);

	return 0;
}

int GGIputpixel_nc(ggi_visual *vis,int x,int y,ggi_pixel col)
{ 
	*((uint32 *) ((uint8 *)LIBGGI_CURWRITE(vis)
	   + y*LIBGGI_FB_W_STRIDE(vis)+x*sizeof(uint32)))
		= col;

	return 0;
}

int GGIputpixel(ggi_visual *vis,int x,int y,ggi_pixel col)
{ 
	CHECKXY(vis,x,y);

	*((uint32 *) ((uint8 *)LIBGGI_CURWRITE(vis)
	   + y*LIBGGI_FB_W_STRIDE(vis)+x*sizeof(uint32)))
		= col;

	return 0;
}

int GGIgetpixel(ggi_visual *vis,int x,int y,ggi_pixel *pixel)
{ 
	*pixel = *((uint32 *) ((uint8 *)LIBGGI_CURREAD(vis)
	   + y*LIBGGI_FB_R_STRIDE(vis)+x*sizeof(uint32)));
	
	return 0;
}
